/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.aspect;

import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.config.server.monitor.MetricsMonitor;
import com.alibaba.nacos.config.server.service.ConfigCacheService;
import com.alibaba.nacos.config.server.utils.GroupKey2;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.RequestUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RequestLogAspect {
    private static final String CLIENT_INTERFACE_PUBLISH_SINGLE_CONFIG = "execution(* com.alibaba.nacos.config.server.controller.ConfigController.publishConfig(..)) && args(request,response,dataId,group,tenant,content,..)";
    private static final String CLIENT_INTERFACE_GET_CONFIG = "execution(* com.alibaba.nacos.config.server.controller.ConfigController.getConfig(..)) && args(request,response,dataId,group,tenant,..)";
    private static final String CLIENT_INTERFACE_REMOVE_ALL_CONFIG = "execution(* com.alibaba.nacos.config.server.controller.ConfigController.deleteConfig(..)) && args(request,response,dataId,group,tenant,..)";

    @Around(value="execution(* com.alibaba.nacos.config.server.controller.ConfigController.publishConfig(..)) && args(request,response,dataId,group,tenant,content,..)")
    public Object interfacePublishSingle(ProceedingJoinPoint pjp, HttpServletRequest request, HttpServletResponse response, String dataId, String group, String tenant, String content) throws Throwable {
        String md5 = content == null ? null : MD5Utils.md5Hex((String)content, (String)"UTF-8");
        MetricsMonitor.getPublishMonitor().incrementAndGet();
        return this.logClientRequest("publish", pjp, request, response, dataId, group, tenant, md5);
    }

    @Around(value="execution(* com.alibaba.nacos.config.server.controller.ConfigController.deleteConfig(..)) && args(request,response,dataId,group,tenant,..)")
    public Object interfaceRemoveAll(ProceedingJoinPoint pjp, HttpServletRequest request, HttpServletResponse response, String dataId, String group, String tenant) throws Throwable {
        return this.logClientRequest("remove", pjp, request, response, dataId, group, tenant, null);
    }

    @Around(value="execution(* com.alibaba.nacos.config.server.controller.ConfigController.getConfig(..)) && args(request,response,dataId,group,tenant,..)")
    public Object interfaceGetConfig(ProceedingJoinPoint pjp, HttpServletRequest request, HttpServletResponse response, String dataId, String group, String tenant) throws Throwable {
        String groupKey = GroupKey2.getKey(dataId, group, tenant);
        String md5 = ConfigCacheService.getContentMd5(groupKey);
        MetricsMonitor.getConfigMonitor().incrementAndGet();
        return this.logClientRequest("get", pjp, request, response, dataId, group, tenant, md5);
    }

    private Object logClientRequest(String requestType, ProceedingJoinPoint pjp, HttpServletRequest request, HttpServletResponse response, String dataId, String group, String tenant, String md5) throws Throwable {
        String requestIp = RequestUtil.getRemoteIp(request);
        String appName = request.getHeader("Client-AppName");
        long st = System.currentTimeMillis();
        Object retVal = pjp.proceed();
        long rt = System.currentTimeMillis() - st;
        LogUtil.CLIENT_LOG.info("{}|{}|{}|{}|{}|{}|{}|{}|{}", new Object[]{rt, retVal, requestIp, requestType, dataId, group, tenant, md5, appName});
        return retVal;
    }
}

