/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.controller;

import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.config.server.model.capacity.Capacity;
import com.alibaba.nacos.config.server.service.capacity.CapacityService;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/cs/capacity"})
public class CapacityController {
    private static final Logger LOGGER = LoggerFactory.getLogger(CapacityController.class);
    private final CapacityService capacityService;

    @Autowired
    public CapacityController(CapacityService capacityService) {
        this.capacityService = capacityService;
    }

    @GetMapping
    public RestResult<Capacity> getCapacity(HttpServletResponse response, @RequestParam(required=false) String group, @RequestParam(required=false) String tenant) {
        if (group == null && tenant == null) {
            RestResult restResult = new RestResult();
            response.setStatus(400);
            restResult.setCode(400);
            restResult.setMessage("\u53c2\u6570group\u548ctenant\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            return restResult;
        }
        if (group == null && StringUtils.isBlank((CharSequence)tenant)) {
            RestResult restResult = new RestResult();
            response.setStatus(400);
            restResult.setCode(400);
            restResult.setMessage("tenant\u4e0d\u80fd\u4e3a\u7a7a\u5b57\u7b26\u4e32");
            return restResult;
        }
        RestResult restResult = new RestResult();
        try {
            response.setStatus(200);
            restResult.setCode(200);
            Capacity capacity = this.capacityService.getCapacityWithDefault(group, tenant);
            if (capacity == null) {
                LOGGER.warn("[getCapacity] capacity\u4e0d\u5b58\u5728\uff0c\u9700\u521d\u59cb\u5316 group: {}, tenant: {}", (Object)group, (Object)tenant);
                this.capacityService.initCapacity(group, tenant);
                capacity = this.capacityService.getCapacityWithDefault(group, tenant);
            }
            if (capacity != null) {
                restResult.setData((Object)capacity);
            }
        }
        catch (Exception e) {
            LOGGER.error("[getCapacity] ", (Throwable)e);
            response.setStatus(500);
            restResult.setCode(500);
            restResult.setMessage(e.getMessage());
        }
        return restResult;
    }

    @PostMapping
    public RestResult<Boolean> updateCapacity(HttpServletResponse response, @RequestParam(required=false) String group, @RequestParam(required=false) String tenant, @RequestParam(required=false) Integer quota, @RequestParam(required=false) Integer maxSize, @RequestParam(required=false) Integer maxAggrCount, @RequestParam(required=false) Integer maxAggrSize) {
        String targetFieldValue;
        String targetFieldName;
        if (StringUtils.isBlank((CharSequence)group) && StringUtils.isBlank((CharSequence)tenant)) {
            this.capacityService.initAllCapacity();
            RestResult restResult = new RestResult();
            this.setFailResult(response, (RestResult<Boolean>)restResult, 400);
            restResult.setMessage("\u53c2\u6570group\u548ctenant\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            return restResult;
        }
        if (quota == null && maxSize == null && maxAggrCount == null && maxAggrSize == null) {
            RestResult restResult = new RestResult();
            this.setFailResult(response, (RestResult<Boolean>)restResult, 400);
            restResult.setMessage("\u53c2\u6570quota\u3001maxSize\u3001maxAggrCount\u3001maxAggrSize\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            return restResult;
        }
        if (tenant == null) {
            targetFieldName = "group";
            targetFieldValue = group;
        } else {
            targetFieldName = "tenant";
            targetFieldValue = tenant;
        }
        RestResult restResult = new RestResult();
        if (StringUtils.isBlank((CharSequence)targetFieldValue)) {
            this.setFailResult(response, (RestResult<Boolean>)restResult, 400);
            restResult.setMessage(String.format("\u53c2\u6570%s\u4e3a\u7a7a", targetFieldName));
            return restResult;
        }
        try {
            boolean insertOrUpdateResult = this.capacityService.insertOrUpdateCapacity(group, tenant, quota, maxSize, maxAggrCount, maxAggrSize);
            if (insertOrUpdateResult) {
                this.setSuccessResult(response, (RestResult<Boolean>)restResult);
                restResult.setMessage(String.format("\u6210\u529f\u66f4\u65b0%s\u4e3a%s\u7684\u5bb9\u91cf\u4fe1\u606f\u914d\u7f6e", targetFieldName, targetFieldValue));
                return restResult;
            }
            this.setFailResult(response, (RestResult<Boolean>)restResult, 500);
            restResult.setMessage(String.format("%s\u4e3a%s\u7684\u5bb9\u91cf\u4fe1\u606f\u914d\u7f6e\u66f4\u65b0\u5931\u8d25", targetFieldName, targetFieldValue));
            return restResult;
        }
        catch (Exception e) {
            LOGGER.error("[updateCapacity] ", (Throwable)e);
            this.setFailResult(response, (RestResult<Boolean>)restResult, 500);
            restResult.setMessage(e.getMessage());
            return restResult;
        }
    }

    private void setFailResult(HttpServletResponse response, RestResult<Boolean> restResult, int statusCode) {
        response.setStatus(statusCode);
        restResult.setCode(statusCode);
        restResult.setData((Object)false);
    }

    private void setSuccessResult(HttpServletResponse response, RestResult<Boolean> restResult) {
        response.setStatus(200);
        restResult.setCode(200);
        restResult.setData((Object)true);
    }
}

