/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.controller;

import com.alibaba.nacos.api.config.ConfigType;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.auth.common.ActionTypes;
import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.model.RestResultUtils;
import com.alibaba.nacos.common.model.core.IResultCode;
import com.alibaba.nacos.common.utils.MapUtils;
import com.alibaba.nacos.common.utils.NamespaceUtil;
import com.alibaba.nacos.config.server.auth.ConfigResourceParser;
import com.alibaba.nacos.config.server.controller.ConfigServletInner;
import com.alibaba.nacos.config.server.controller.parameters.SameNamespaceCloneConfigBean;
import com.alibaba.nacos.config.server.model.ConfigAdvanceInfo;
import com.alibaba.nacos.config.server.model.ConfigAllInfo;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigInfo4Beta;
import com.alibaba.nacos.config.server.model.GroupkeyListenserStatus;
import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.config.server.model.SameConfigPolicy;
import com.alibaba.nacos.config.server.model.SampleResult;
import com.alibaba.nacos.config.server.model.event.ConfigDataChangeEvent;
import com.alibaba.nacos.config.server.result.code.ResultCodeEnum;
import com.alibaba.nacos.config.server.service.AggrWhitelist;
import com.alibaba.nacos.config.server.service.ConfigChangePublisher;
import com.alibaba.nacos.config.server.service.ConfigSubService;
import com.alibaba.nacos.config.server.service.repository.PersistService;
import com.alibaba.nacos.config.server.service.trace.ConfigTraceService;
import com.alibaba.nacos.config.server.utils.MD5Util;
import com.alibaba.nacos.config.server.utils.ParamUtils;
import com.alibaba.nacos.config.server.utils.RequestUtil;
import com.alibaba.nacos.config.server.utils.TimeUtils;
import com.alibaba.nacos.config.server.utils.ZipUtils;
import com.alibaba.nacos.sys.utils.InetUtils;
import java.io.IOException;
import java.net.URLDecoder;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/v1/cs/configs"})
public class ConfigController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigController.class);
    private static final String EXPORT_CONFIG_FILE_NAME = "nacos_config_export_";
    private static final String EXPORT_CONFIG_FILE_NAME_EXT = ".zip";
    private static final String EXPORT_CONFIG_FILE_NAME_DATE_FORMAT = "yyyyMMddHHmmss";
    private final ConfigServletInner inner;
    private final PersistService persistService;
    private final ConfigSubService configSubService;

    @Autowired
    public ConfigController(ConfigServletInner configServletInner, PersistService persistService, ConfigSubService configSubService) {
        this.inner = configServletInner;
        this.persistService = persistService;
        this.configSubService = configSubService;
    }

    @PostMapping
    @Secured(action=ActionTypes.WRITE, parser=ConfigResourceParser.class)
    public Boolean publishConfig(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="content") String content, @RequestParam(value="tag", required=false) String tag, @RequestParam(value="appName", required=false) String appName, @RequestParam(value="src_user", required=false) String srcUser, @RequestParam(value="config_tags", required=false) String configTags, @RequestParam(value="desc", required=false) String desc, @RequestParam(value="use", required=false) String use, @RequestParam(value="effect", required=false) String effect, @RequestParam(value="type", required=false) String type, @RequestParam(value="schema", required=false) String schema) throws NacosException {
        String srcIp = RequestUtil.getRemoteIp(request);
        String requestIpApp = RequestUtil.getAppName(request);
        srcUser = RequestUtil.getSrcUserName(request);
        if (!ConfigType.isValidType((String)type).booleanValue()) {
            type = ConfigType.getDefaultType().getType();
        }
        ParamUtils.checkTenant(tenant);
        ParamUtils.checkParam(dataId, group, "datumId", content);
        ParamUtils.checkParam(tag);
        HashMap<String, Object> configAdvanceInfo = new HashMap<String, Object>(10);
        MapUtils.putIfValNoNull(configAdvanceInfo, (Object)"config_tags", (Object)configTags);
        MapUtils.putIfValNoNull(configAdvanceInfo, (Object)"desc", (Object)desc);
        MapUtils.putIfValNoNull(configAdvanceInfo, (Object)"use", (Object)use);
        MapUtils.putIfValNoNull(configAdvanceInfo, (Object)"effect", (Object)effect);
        MapUtils.putIfValNoNull(configAdvanceInfo, (Object)"type", (Object)type);
        MapUtils.putIfValNoNull(configAdvanceInfo, (Object)"schema", (Object)schema);
        ParamUtils.checkParam(configAdvanceInfo);
        if (AggrWhitelist.isAggrDataId(dataId)) {
            LOGGER.warn("[aggr-conflict] {} attemp to publish single data, {}, {}", new Object[]{RequestUtil.getRemoteIp(request), dataId, group});
            throw new NacosException(403, "dataId:" + dataId + " is aggr");
        }
        Timestamp time = TimeUtils.getCurrentTime();
        String betaIps = request.getHeader("betaIps");
        ConfigInfo configInfo = new ConfigInfo(dataId, group, tenant, appName, content);
        configInfo.setType(type);
        if (StringUtils.isBlank((CharSequence)betaIps)) {
            if (StringUtils.isBlank((CharSequence)tag)) {
                this.persistService.insertOrUpdate(srcIp, srcUser, configInfo, time, configAdvanceInfo, true);
                ConfigChangePublisher.notifyConfigChange(new ConfigDataChangeEvent(false, dataId, group, tenant, time.getTime()));
            } else {
                this.persistService.insertOrUpdateTag(configInfo, tag, srcIp, srcUser, time, true);
                ConfigChangePublisher.notifyConfigChange(new ConfigDataChangeEvent(false, dataId, group, tenant, tag, time.getTime()));
            }
        } else {
            this.persistService.insertOrUpdateBeta(configInfo, betaIps, srcIp, srcUser, time, true);
            ConfigChangePublisher.notifyConfigChange(new ConfigDataChangeEvent(true, dataId, group, tenant, time.getTime()));
        }
        ConfigTraceService.logPersistenceEvent(dataId, group, tenant, requestIpApp, time.getTime(), InetUtils.getSelfIP(), "pub", content);
        return true;
    }

    @GetMapping
    @Secured(action=ActionTypes.READ, parser=ConfigResourceParser.class)
    public void getConfig(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="tag", required=false) String tag) throws IOException, ServletException, NacosException {
        ParamUtils.checkTenant(tenant);
        tenant = NamespaceUtil.processNamespaceParameter((String)tenant);
        ParamUtils.checkParam(dataId, group, "datumId", "content");
        ParamUtils.checkParam(tag);
        String clientIp = RequestUtil.getRemoteIp(request);
        this.inner.doGetConfig(request, response, dataId, group, tenant, tag, clientIp);
    }

    @GetMapping(params={"show=all"})
    @Secured(action=ActionTypes.READ, parser=ConfigResourceParser.class)
    public ConfigAllInfo detailConfigInfo(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant) throws NacosException {
        ParamUtils.checkTenant(tenant);
        ParamUtils.checkParam(dataId, group, "datumId", "content");
        return this.persistService.findConfigAllInfo(dataId, group, tenant);
    }

    @DeleteMapping
    @Secured(action=ActionTypes.WRITE, parser=ConfigResourceParser.class)
    public Boolean deleteConfig(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="tag", required=false) String tag) throws NacosException {
        ParamUtils.checkTenant(tenant);
        ParamUtils.checkParam(dataId, group, "datumId", "rm");
        ParamUtils.checkParam(tag);
        String clientIp = RequestUtil.getRemoteIp(request);
        String srcUser = RequestUtil.getSrcUserName(request);
        if (StringUtils.isBlank((CharSequence)tag)) {
            this.persistService.removeConfigInfo(dataId, group, tenant, clientIp, srcUser);
        } else {
            this.persistService.removeConfigInfoTag(dataId, group, tenant, tag, clientIp, srcUser);
        }
        Timestamp time = TimeUtils.getCurrentTime();
        ConfigTraceService.logPersistenceEvent(dataId, group, tenant, null, time.getTime(), clientIp, "remove", null);
        ConfigChangePublisher.notifyConfigChange(new ConfigDataChangeEvent(false, dataId, group, tenant, tag, time.getTime()));
        return true;
    }

    @DeleteMapping(params={"delType=ids"})
    @Secured(action=ActionTypes.WRITE, parser=ConfigResourceParser.class)
    public RestResult<Boolean> deleteConfigs(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="ids") List<Long> ids) {
        String clientIp = RequestUtil.getRemoteIp(request);
        Timestamp time = TimeUtils.getCurrentTime();
        List<ConfigInfo> configInfoList = this.persistService.removeConfigInfoByIds(ids, clientIp, null);
        if (!CollectionUtils.isEmpty(configInfoList)) {
            for (ConfigInfo configInfo : configInfoList) {
                ConfigChangePublisher.notifyConfigChange(new ConfigDataChangeEvent(false, configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), time.getTime()));
                ConfigTraceService.logPersistenceEvent(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), null, time.getTime(), clientIp, "remove", null);
            }
        }
        return RestResultUtils.success((Object)true);
    }

    @GetMapping(value={"/catalog"})
    @Secured(action=ActionTypes.READ, parser=ConfigResourceParser.class)
    public RestResult<ConfigAdvanceInfo> getConfigAdvanceInfo(@RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant) {
        RestResult rr = new RestResult();
        ConfigAdvanceInfo configInfo = this.persistService.findConfigAdvanceInfo(dataId, group, tenant);
        rr.setCode(200);
        rr.setData((Object)configInfo);
        return rr;
    }

    @PostMapping(value={"/listener"})
    @Secured(action=ActionTypes.READ, parser=ConfigResourceParser.class)
    public void listener(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Map<String, String> clientMd5Map;
        request.setAttribute("org.apache.catalina.ASYNC_SUPPORTED", (Object)true);
        String probeModify = request.getParameter("Listening-Configs");
        if (StringUtils.isBlank((CharSequence)probeModify)) {
            throw new IllegalArgumentException("invalid probeModify");
        }
        probeModify = URLDecoder.decode(probeModify, "UTF-8");
        try {
            clientMd5Map = MD5Util.getClientMd5Map(probeModify);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("invalid probeModify");
        }
        this.inner.doPollingConfig(request, response, clientMd5Map, probeModify.length());
    }

    @GetMapping(value={"/listener"})
    @Secured(action=ActionTypes.READ, parser=ConfigResourceParser.class)
    public GroupkeyListenserStatus getListeners(@RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false) String tenant, @RequestParam(value="sampleTime", required=false, defaultValue="1") int sampleTime) throws Exception {
        group = StringUtils.isBlank((CharSequence)group) ? "DEFAULT_GROUP" : group;
        SampleResult collectSampleResult = this.configSubService.getCollectSampleResult(dataId, group, tenant, sampleTime);
        GroupkeyListenserStatus gls = new GroupkeyListenserStatus();
        gls.setCollectStatus(200);
        if (collectSampleResult.getLisentersGroupkeyStatus() != null) {
            gls.setLisentersGroupkeyStatus(collectSampleResult.getLisentersGroupkeyStatus());
        }
        return gls;
    }

    @GetMapping(params={"search=accurate"})
    @Secured(action=ActionTypes.READ, parser=ConfigResourceParser.class)
    public Page<ConfigInfo> searchConfig(@RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="appName", required=false) String appName, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="config_tags", required=false) String configTags, @RequestParam(value="pageNo") int pageNo, @RequestParam(value="pageSize") int pageSize) {
        HashMap<String, Object> configAdvanceInfo = new HashMap<String, Object>(100);
        if (StringUtils.isNotBlank((CharSequence)appName)) {
            configAdvanceInfo.put("appName", appName);
        }
        if (StringUtils.isNotBlank((CharSequence)configTags)) {
            configAdvanceInfo.put("config_tags", configTags);
        }
        try {
            return this.persistService.findConfigInfo4Page(pageNo, pageSize, dataId, group, tenant, configAdvanceInfo);
        }
        catch (Exception e) {
            String errorMsg = "serialize page error, dataId=" + dataId + ", group=" + group;
            LOGGER.error(errorMsg, (Throwable)e);
            throw new RuntimeException(errorMsg, e);
        }
    }

    @GetMapping(params={"search=blur"})
    @Secured(action=ActionTypes.READ, parser=ConfigResourceParser.class)
    public Page<ConfigInfo> fuzzySearchConfig(@RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="appName", required=false) String appName, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="config_tags", required=false) String configTags, @RequestParam(value="pageNo") int pageNo, @RequestParam(value="pageSize") int pageSize) {
        HashMap<String, Object> configAdvanceInfo = new HashMap<String, Object>(50);
        if (StringUtils.isNotBlank((CharSequence)appName)) {
            configAdvanceInfo.put("appName", appName);
        }
        if (StringUtils.isNotBlank((CharSequence)configTags)) {
            configAdvanceInfo.put("config_tags", configTags);
        }
        try {
            return this.persistService.findConfigInfoLike4Page(pageNo, pageSize, dataId, group, tenant, configAdvanceInfo);
        }
        catch (Exception e) {
            String errorMsg = "serialize page error, dataId=" + dataId + ", group=" + group;
            LOGGER.error(errorMsg, (Throwable)e);
            throw new RuntimeException(errorMsg, e);
        }
    }

    @DeleteMapping(params={"beta=true"})
    @Secured(action=ActionTypes.WRITE, parser=ConfigResourceParser.class)
    public RestResult<Boolean> stopBeta(@RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant) {
        RestResult rr = new RestResult();
        try {
            this.persistService.removeConfigInfo4Beta(dataId, group, tenant);
        }
        catch (Exception e) {
            LOGGER.error("remove beta data error", (Throwable)e);
            rr.setCode(500);
            rr.setData((Object)false);
            rr.setMessage("remove beta data error");
            return rr;
        }
        ConfigChangePublisher.notifyConfigChange(new ConfigDataChangeEvent(true, dataId, group, tenant, System.currentTimeMillis()));
        rr.setCode(200);
        rr.setData((Object)true);
        rr.setMessage("stop beta ok");
        return rr;
    }

    @GetMapping(params={"beta=true"})
    @Secured(action=ActionTypes.READ, parser=ConfigResourceParser.class)
    public RestResult<ConfigInfo4Beta> queryBeta(@RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant) {
        RestResult rr = new RestResult();
        try {
            ConfigInfo4Beta ci = this.persistService.findConfigInfo4Beta(dataId, group, tenant);
            rr.setCode(200);
            rr.setData((Object)ci);
            rr.setMessage("stop beta ok");
            return rr;
        }
        catch (Exception e) {
            LOGGER.error("remove beta data error", (Throwable)e);
            rr.setCode(500);
            rr.setMessage("remove beta data error");
            return rr;
        }
    }

    @GetMapping(params={"export=true"})
    @Secured(action=ActionTypes.READ, parser=ConfigResourceParser.class)
    public ResponseEntity<byte[]> exportConfig(@RequestParam(value="dataId", required=false) String dataId, @RequestParam(value="group", required=false) String group, @RequestParam(value="appName", required=false) String appName, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="ids", required=false) List<Long> ids) {
        ids.removeAll(Collections.singleton(null));
        tenant = NamespaceUtil.processNamespaceParameter((String)tenant);
        List<ConfigAllInfo> dataList = this.persistService.findAllConfigInfo4Export(dataId, group, tenant, appName, ids);
        ArrayList<ZipUtils.ZipItem> zipItemList = new ArrayList<ZipUtils.ZipItem>();
        StringBuilder metaData = null;
        for (ConfigInfo configInfo : dataList) {
            if (StringUtils.isNotBlank((CharSequence)configInfo.getAppName())) {
                String metaDataId;
                if (metaData == null) {
                    metaData = new StringBuilder();
                }
                if ((metaDataId = configInfo.getDataId()).contains(".")) {
                    metaDataId = metaDataId.substring(0, metaDataId.lastIndexOf(".")) + "~" + metaDataId.substring(metaDataId.lastIndexOf(".") + 1);
                }
                metaData.append(configInfo.getGroup()).append(".").append(metaDataId).append(".app=").append(configInfo.getAppName()).append("\r\n");
            }
            String itemName = configInfo.getGroup() + "/" + configInfo.getDataId();
            zipItemList.add(new ZipUtils.ZipItem(itemName, configInfo.getContent()));
        }
        if (metaData != null) {
            zipItemList.add(new ZipUtils.ZipItem(".meta.yml", metaData.toString()));
        }
        HttpHeaders headers = new HttpHeaders();
        String string = EXPORT_CONFIG_FILE_NAME + DateFormatUtils.format((Date)new Date(), (String)EXPORT_CONFIG_FILE_NAME_DATE_FORMAT) + EXPORT_CONFIG_FILE_NAME_EXT;
        headers.add("Content-Disposition", "attachment;filename=" + string);
        return new ResponseEntity((Object)ZipUtils.zip(zipItemList), (MultiValueMap)headers, HttpStatus.OK);
    }

    @PostMapping(params={"import=true"})
    @Secured(action=ActionTypes.WRITE, parser=ConfigResourceParser.class)
    public RestResult<Map<String, Object>> importAndPublishConfig(HttpServletRequest request, @RequestParam(value="src_user", required=false) String srcUser, @RequestParam(value="namespace", required=false) String namespace, @RequestParam(value="policy", defaultValue="ABORT") SameConfigPolicy policy, MultipartFile file) throws NacosException {
        HashMap<String, Integer> failedData = new HashMap<String, Integer>(4);
        if (Objects.isNull(file)) {
            return RestResultUtils.buildResult((IResultCode)ResultCodeEnum.DATA_EMPTY, failedData);
        }
        if (StringUtils.isNotBlank((CharSequence)(namespace = NamespaceUtil.processNamespaceParameter((String)namespace))) && this.persistService.tenantInfoCountByTenantId(namespace) <= 0) {
            failedData.put("succCount", 0);
            return RestResultUtils.buildResult((IResultCode)ResultCodeEnum.NAMESPACE_NOT_EXIST, failedData);
        }
        ArrayList<ConfigAllInfo> configInfoList = null;
        try {
            List<ZipUtils.ZipItem> itemList;
            ZipUtils.UnZipResult unziped = ZipUtils.unzip(file.getBytes());
            ZipUtils.ZipItem metaDataZipItem = unziped.getMetaDataItem();
            HashMap<String, String> metaDataMap = new HashMap<String, String>(16);
            if (metaDataZipItem != null) {
                String[] metaDataArr;
                String metaDataStr = metaDataZipItem.getItemData();
                for (String metaDataItem : metaDataArr = metaDataStr.split("\r\n")) {
                    String[] metaDataItemArr = metaDataItem.split("=");
                    if (metaDataItemArr.length != 2) {
                        failedData.put("succCount", 0);
                        return RestResultUtils.buildResult((IResultCode)ResultCodeEnum.METADATA_ILLEGAL, failedData);
                    }
                    metaDataMap.put(metaDataItemArr[0], metaDataItemArr[1]);
                }
            }
            if ((itemList = unziped.getZipItemList()) != null && !itemList.isEmpty()) {
                configInfoList = new ArrayList<ConfigAllInfo>(itemList.size());
                for (ZipUtils.ZipItem zipItem : itemList) {
                    String[] groupAdnDataId = zipItem.getItemName().split("/");
                    if (!zipItem.getItemName().contains("/") || groupAdnDataId.length != 2) {
                        failedData.put("succCount", 0);
                        return RestResultUtils.buildResult((IResultCode)ResultCodeEnum.DATA_VALIDATION_FAILED, failedData);
                    }
                    String group = groupAdnDataId[0];
                    String dataId = groupAdnDataId[1];
                    String tempDataId = dataId;
                    if (tempDataId.contains(".")) {
                        tempDataId = tempDataId.substring(0, tempDataId.lastIndexOf(".")) + "~" + tempDataId.substring(tempDataId.lastIndexOf(".") + 1);
                    }
                    String metaDataId = group + "." + tempDataId + ".app";
                    ConfigAllInfo ci = new ConfigAllInfo();
                    ci.setTenant(namespace);
                    ci.setGroup(group);
                    ci.setDataId(dataId);
                    ci.setContent(zipItem.getItemData());
                    if (metaDataMap.get(metaDataId) != null) {
                        ci.setAppName((String)metaDataMap.get(metaDataId));
                    }
                    configInfoList.add(ci);
                }
            }
        }
        catch (IOException e) {
            failedData.put("succCount", 0);
            LOGGER.error("parsing data failed", (Throwable)e);
            return RestResultUtils.buildResult((IResultCode)ResultCodeEnum.PARSING_DATA_FAILED, failedData);
        }
        if (configInfoList == null || configInfoList.isEmpty()) {
            failedData.put("succCount", 0);
            return RestResultUtils.buildResult((IResultCode)ResultCodeEnum.DATA_EMPTY, failedData);
        }
        String srcIp = RequestUtil.getRemoteIp(request);
        String requestIpApp = RequestUtil.getAppName(request);
        Timestamp time = TimeUtils.getCurrentTime();
        Map<String, Object> saveResult = this.persistService.batchInsertOrUpdate(configInfoList, srcUser, srcIp, null, time, false, policy);
        for (ConfigInfo configInfo : configInfoList) {
            ConfigChangePublisher.notifyConfigChange(new ConfigDataChangeEvent(false, configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), time.getTime()));
            ConfigTraceService.logPersistenceEvent(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), requestIpApp, time.getTime(), InetUtils.getSelfIP(), "pub", configInfo.getContent());
        }
        return RestResultUtils.success((String)"\u5bfc\u5165\u6210\u529f", saveResult);
    }

    @PostMapping(params={"clone=true"})
    @Secured(action=ActionTypes.WRITE, parser=ConfigResourceParser.class)
    public RestResult<Map<String, Object>> cloneConfig(HttpServletRequest request, @RequestParam(value="src_user", required=false) String srcUser, @RequestParam(value="tenant", required=true) String namespace, @RequestBody(required=true) List<SameNamespaceCloneConfigBean> configBeansList, @RequestParam(value="policy", defaultValue="ABORT") SameConfigPolicy policy) throws NacosException {
        HashMap<String, Integer> failedData = new HashMap<String, Integer>(4);
        if (CollectionUtils.isEmpty(configBeansList)) {
            failedData.put("succCount", 0);
            return RestResultUtils.buildResult((IResultCode)ResultCodeEnum.NO_SELECTED_CONFIG, failedData);
        }
        configBeansList.removeAll(Collections.singleton(null));
        namespace = NamespaceUtil.processNamespaceParameter((String)namespace);
        if (StringUtils.isNotBlank((CharSequence)namespace) && this.persistService.tenantInfoCountByTenantId(namespace) <= 0) {
            failedData.put("succCount", 0);
            return RestResultUtils.buildResult((IResultCode)ResultCodeEnum.NAMESPACE_NOT_EXIST, failedData);
        }
        ArrayList<Long> idList = new ArrayList<Long>(configBeansList.size());
        Map<Long, SameNamespaceCloneConfigBean> configBeansMap = configBeansList.stream().collect(Collectors.toMap(SameNamespaceCloneConfigBean::getCfgId, cfg -> {
            idList.add(cfg.getCfgId());
            return cfg;
        }, (k1, k2) -> k1));
        List<ConfigAllInfo> queryedDataList = this.persistService.findAllConfigInfo4Export(null, null, null, null, idList);
        if (queryedDataList == null || queryedDataList.isEmpty()) {
            failedData.put("succCount", 0);
            return RestResultUtils.buildResult((IResultCode)ResultCodeEnum.DATA_EMPTY, failedData);
        }
        ArrayList<ConfigAllInfo> configInfoList4Clone = new ArrayList<ConfigAllInfo>(queryedDataList.size());
        for (ConfigAllInfo ci : queryedDataList) {
            SameNamespaceCloneConfigBean prarmBean = configBeansMap.get(ci.getId());
            ConfigAllInfo ci4save = new ConfigAllInfo();
            ci4save.setTenant(namespace);
            ci4save.setType(ci.getType());
            ci4save.setGroup(prarmBean != null && StringUtils.isNotBlank((CharSequence)prarmBean.getGroup()) ? prarmBean.getGroup() : ci.getGroup());
            ci4save.setDataId(prarmBean != null && StringUtils.isNotBlank((CharSequence)prarmBean.getDataId()) ? prarmBean.getDataId() : ci.getDataId());
            ci4save.setContent(ci.getContent());
            if (StringUtils.isNotBlank((CharSequence)ci.getAppName())) {
                ci4save.setAppName(ci.getAppName());
            }
            configInfoList4Clone.add(ci4save);
        }
        if (configInfoList4Clone.isEmpty()) {
            failedData.put("succCount", 0);
            return RestResultUtils.buildResult((IResultCode)ResultCodeEnum.DATA_EMPTY, failedData);
        }
        String srcIp = RequestUtil.getRemoteIp(request);
        String requestIpApp = RequestUtil.getAppName(request);
        Timestamp time = TimeUtils.getCurrentTime();
        Map<String, Object> saveResult = this.persistService.batchInsertOrUpdate(configInfoList4Clone, srcUser, srcIp, null, time, false, policy);
        for (ConfigInfo configInfo : configInfoList4Clone) {
            ConfigChangePublisher.notifyConfigChange(new ConfigDataChangeEvent(false, configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), time.getTime()));
            ConfigTraceService.logPersistenceEvent(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), requestIpApp, time.getTime(), InetUtils.getSelfIP(), "pub", configInfo.getContent());
        }
        return RestResultUtils.success((String)"Clone Completed Successfully", saveResult);
    }
}

