/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.manager;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.task.AbstractDelayTask;
import com.alibaba.nacos.common.task.engine.NacosDelayTaskExecuteEngine;
import com.alibaba.nacos.config.server.manager.TaskManagerMBean;
import com.alibaba.nacos.config.server.monitor.MetricsMonitor;
import com.alibaba.nacos.config.server.utils.LogUtil;
import java.lang.management.ManagementFactory;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import javax.management.ObjectName;
import org.slf4j.Logger;

public final class TaskManager
extends NacosDelayTaskExecuteEngine
implements TaskManagerMBean {
    private static final Logger LOGGER = LogUtil.DEFAULT_LOG;
    private String name;
    Condition notEmpty;

    public TaskManager(String name) {
        super(name, LOGGER, 100L);
        this.notEmpty = this.lock.newCondition();
        this.name = name;
    }

    public void close() {
        try {
            super.shutdown();
        }
        catch (NacosException nacosException) {
            // empty catch block
        }
    }

    public void await() throws InterruptedException {
        this.lock.lock();
        try {
            while (!this.isEmpty()) {
                this.notEmpty.await();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        this.lock.lock();
        boolean isawait = false;
        try {
            while (!this.isEmpty()) {
                isawait = this.notEmpty.await(timeout, unit);
            }
            boolean bl = isawait;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addTask(Object key, AbstractDelayTask newTask) {
        super.addTask(key, newTask);
        MetricsMonitor.getDumpTaskMonitor().set(this.tasks.size());
    }

    public AbstractDelayTask removeTask(Object key) {
        AbstractDelayTask result = super.removeTask(key);
        MetricsMonitor.getDumpTaskMonitor().set(this.tasks.size());
        return result;
    }

    protected void processTasks() {
        super.processTasks();
        MetricsMonitor.getDumpTaskMonitor().set(this.tasks.size());
        if (this.tasks.isEmpty()) {
            this.lock.lock();
            try {
                this.notEmpty.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public String getTaskInfos() {
        StringBuilder sb = new StringBuilder();
        for (Object taskType : this.getAllProcessorKey()) {
            sb.append(taskType).append(":");
            AbstractDelayTask task = (AbstractDelayTask)this.tasks.get(taskType);
            if (task != null) {
                sb.append(new Date(task.getLastProcessTime()).toString());
            } else {
                sb.append("finished");
            }
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public void init() {
        try {
            ObjectName oName = new ObjectName(this.name + ":type=" + TaskManager.class.getSimpleName());
            ManagementFactory.getPlatformMBeanServer().registerMBean(this, oName);
        }
        catch (Exception e) {
            LOGGER.error("registerMBean_fail", (Object)"\u6ce8\u518cmbean\u51fa\u9519", (Object)e);
        }
    }
}

