/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.repository.embedded;

import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.config.server.service.repository.PaginationHelper;
import com.alibaba.nacos.config.server.service.repository.embedded.DatabaseOperate;
import com.alibaba.nacos.config.server.service.sql.EmbeddedStorageContextUtils;
import java.util.List;
import org.springframework.jdbc.core.RowMapper;

class EmbeddedPaginationHelperImpl<E>
implements PaginationHelper {
    private final DatabaseOperate databaseOperate;

    public EmbeddedPaginationHelperImpl(DatabaseOperate databaseOperate) {
        this.databaseOperate = databaseOperate;
    }

    public Page<E> fetchPage(String sqlCountRows, String sqlFetchRows, Object[] args, int pageNo, int pageSize, RowMapper rowMapper) {
        return this.fetchPage(sqlCountRows, sqlFetchRows, args, pageNo, pageSize, (Long)null, rowMapper);
    }

    public Page<E> fetchPage(String sqlCountRows, String sqlFetchRows, Object[] args, int pageNo, int pageSize, Long lastMaxId, RowMapper rowMapper) {
        if (pageNo <= 0 || pageSize <= 0) {
            throw new IllegalArgumentException("pageNo and pageSize must be greater than zero");
        }
        Integer rowCountInt = this.databaseOperate.queryOne(sqlCountRows, args, Integer.class);
        if (rowCountInt == null) {
            throw new IllegalArgumentException("fetchPageLimit error");
        }
        int pageCount = rowCountInt / pageSize;
        if (rowCountInt > pageSize * pageCount) {
            ++pageCount;
        }
        Page page = new Page();
        page.setPageNumber(pageNo);
        page.setPagesAvailable(pageCount);
        page.setTotalCount(rowCountInt);
        if (pageNo > pageCount) {
            return page;
        }
        int startRow = (pageNo - 1) * pageSize;
        String selectSql = sqlFetchRows + " OFFSET " + startRow + " ROWS FETCH NEXT " + pageSize + " ROWS ONLY";
        List result = this.databaseOperate.queryMany(selectSql, args, rowMapper);
        for (Object item : result) {
            page.getPageItems().add(item);
        }
        return page;
    }

    public Page<E> fetchPageLimit(String sqlCountRows, String sqlFetchRows, Object[] args, int pageNo, int pageSize, RowMapper rowMapper) {
        if (pageNo <= 0 || pageSize <= 0) {
            throw new IllegalArgumentException("pageNo and pageSize must be greater than zero");
        }
        Integer rowCountInt = this.databaseOperate.queryOne(sqlCountRows, Integer.class);
        if (rowCountInt == null) {
            throw new IllegalArgumentException("fetchPageLimit error");
        }
        int pageCount = rowCountInt / pageSize;
        if (rowCountInt > pageSize * pageCount) {
            ++pageCount;
        }
        Page page = new Page();
        page.setPageNumber(pageNo);
        page.setPagesAvailable(pageCount);
        page.setTotalCount(rowCountInt);
        if (pageNo > pageCount) {
            return page;
        }
        String selectSql = sqlFetchRows.replaceAll("(?i)LIMIT \\?,\\?", "OFFSET ? ROWS FETCH NEXT ? ROWS ONLY");
        List result = this.databaseOperate.queryMany(selectSql, args, rowMapper);
        for (Object item : result) {
            page.getPageItems().add(item);
        }
        return page;
    }

    public Page<E> fetchPageLimit(String sqlCountRows, Object[] args1, String sqlFetchRows, Object[] args2, int pageNo, int pageSize, RowMapper rowMapper) {
        if (pageNo <= 0 || pageSize <= 0) {
            throw new IllegalArgumentException("pageNo and pageSize must be greater than zero");
        }
        Integer rowCountInt = this.databaseOperate.queryOne(sqlCountRows, args1, Integer.class);
        if (rowCountInt == null) {
            throw new IllegalArgumentException("fetchPageLimit error");
        }
        int pageCount = rowCountInt / pageSize;
        if (rowCountInt > pageSize * pageCount) {
            ++pageCount;
        }
        Page page = new Page();
        page.setPageNumber(pageNo);
        page.setPagesAvailable(pageCount);
        page.setTotalCount(rowCountInt);
        if (pageNo > pageCount) {
            return page;
        }
        String selectSql = sqlFetchRows.replaceAll("(?i)LIMIT \\?,\\?", "OFFSET ? ROWS FETCH NEXT ? ROWS ONLY");
        List result = this.databaseOperate.queryMany(selectSql, args2, rowMapper);
        for (Object item : result) {
            page.getPageItems().add(item);
        }
        return page;
    }

    public Page<E> fetchPageLimit(String sqlFetchRows, Object[] args, int pageNo, int pageSize, RowMapper rowMapper) {
        if (pageNo <= 0 || pageSize <= 0) {
            throw new IllegalArgumentException("pageNo and pageSize must be greater than zero");
        }
        Page page = new Page();
        String selectSql = sqlFetchRows.replaceAll("(?i)LIMIT \\?,\\?", "OFFSET ? ROWS FETCH NEXT ? ROWS ONLY");
        List result = this.databaseOperate.queryMany(selectSql, args, rowMapper);
        for (Object item : result) {
            page.getPageItems().add(item);
        }
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLimit(String sql, Object[] args) {
        String sqlUpdate = sql.replaceAll("limit \\?", "OFFSET 0 ROWS FETCH NEXT ? ROWS ONLY");
        EmbeddedStorageContextUtils.addSqlContext(sqlUpdate, args);
        try {
            this.databaseOperate.update(EmbeddedStorageContextUtils.getCurrentSqlContext());
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }
}

