/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.utils;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.config.server.utils.PropertyUtil;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ParamUtils {
    private static char[] validChars = new char[]{'_', '-', '.', ':'};
    private static final int TAG_MAX_LEN = 16;
    private static final int TANANT_MAX_LEN = 128;

    public static boolean isValid(String param) {
        if (param == null) {
            return false;
        }
        int length = param.length();
        for (int i = 0; i < length; ++i) {
            char ch = param.charAt(i);
            if (Character.isLetterOrDigit(ch) || ParamUtils.isValidChar(ch)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidChar(char ch) {
        for (char c : validChars) {
            if (c != ch) continue;
            return true;
        }
        return false;
    }

    public static void checkParam(String dataId, String group, String datumId, String content) throws NacosException {
        if (StringUtils.isBlank((CharSequence)dataId) || !ParamUtils.isValid(dataId.trim())) {
            throw new NacosException(400, "invalid dataId : " + dataId);
        }
        if (StringUtils.isBlank((CharSequence)group) || !ParamUtils.isValid(group)) {
            throw new NacosException(400, "invalid group : " + group);
        }
        if (StringUtils.isBlank((CharSequence)datumId) || !ParamUtils.isValid(datumId)) {
            throw new NacosException(400, "invalid datumId : " + datumId);
        }
        if (StringUtils.isBlank((CharSequence)content)) {
            throw new NacosException(400, "content is blank : " + content);
        }
        if (content.length() > PropertyUtil.getMaxContent()) {
            throw new NacosException(400, "invalid content, over " + PropertyUtil.getMaxContent());
        }
    }

    public static void checkParam(String tag) {
        if (StringUtils.isNotBlank((CharSequence)tag)) {
            if (!ParamUtils.isValid(tag.trim())) {
                throw new IllegalArgumentException("invalid tag : " + tag);
            }
            if (tag.length() > 16) {
                throw new IllegalArgumentException("too long tag, over 16");
            }
        }
    }

    public static void checkParam(Map<String, Object> configAdvanceInfo) throws NacosException {
        for (Map.Entry<String, Object> configAdvanceInfoTmp : configAdvanceInfo.entrySet()) {
            if ("config_tags".equals(configAdvanceInfoTmp.getKey())) {
                if (configAdvanceInfoTmp.getValue() == null) continue;
                String[] tagArr = ((String)configAdvanceInfoTmp.getValue()).split(",");
                if (tagArr.length > 5) {
                    throw new NacosException(400, "too much config_tags, over 5");
                }
                for (String tag : tagArr) {
                    if (tag.length() <= 64) continue;
                    throw new NacosException(400, "too long tag, over 64");
                }
                continue;
            }
            if ("desc".equals(configAdvanceInfoTmp.getKey())) {
                if (configAdvanceInfoTmp.getValue() == null || ((String)configAdvanceInfoTmp.getValue()).length() <= 128) continue;
                throw new NacosException(400, "too long desc, over 128");
            }
            if ("use".equals(configAdvanceInfoTmp.getKey())) {
                if (configAdvanceInfoTmp.getValue() == null || ((String)configAdvanceInfoTmp.getValue()).length() <= 32) continue;
                throw new NacosException(400, "too long use, over 32");
            }
            if ("effect".equals(configAdvanceInfoTmp.getKey())) {
                if (configAdvanceInfoTmp.getValue() == null || ((String)configAdvanceInfoTmp.getValue()).length() <= 32) continue;
                throw new NacosException(400, "too long effect, over 32");
            }
            if ("type".equals(configAdvanceInfoTmp.getKey())) {
                if (configAdvanceInfoTmp.getValue() == null || ((String)configAdvanceInfoTmp.getValue()).length() <= 32) continue;
                throw new NacosException(400, "too long type, over 32");
            }
            if ("schema".equals(configAdvanceInfoTmp.getKey())) {
                if (configAdvanceInfoTmp.getValue() == null || ((String)configAdvanceInfoTmp.getValue()).length() <= 32768) continue;
                throw new NacosException(400, "too long schema, over 32768");
            }
            throw new NacosException(400, "invalid param");
        }
    }

    public static void checkTenant(String tenant) {
        if (StringUtils.isNotBlank((CharSequence)tenant)) {
            if (!ParamUtils.isValid(tenant.trim())) {
                throw new IllegalArgumentException("invalid tenant");
            }
            if (tenant.length() > 128) {
                throw new IllegalArgumentException("too long tag, over 128");
            }
        }
    }
}

