/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.query;

import org.olap4j.OlapException;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.MetadataElement;
import org.olap4j.query.AbstractSelection;
import org.olap4j.query.Olap4jNodeConverter;
import org.olap4j.query.Selection;

class LevelSelectionImpl
extends AbstractSelection {
    protected Level level;

    public LevelSelectionImpl(Level level, Dimension dimension, Selection.Operator operator) {
        super(dimension, operator);
        this.level = level;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.level == null ? 0 : this.level.getUniqueName().hashCode());
        result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
        result = 31 * result + (this.selectionContext == null ? 0 : this.selectionContext.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LevelSelectionImpl)) {
            return false;
        }
        LevelSelectionImpl other = (LevelSelectionImpl)obj;
        if (this.level == null ? other.level != null : !this.level.getUniqueName().equals(other.level.getUniqueName())) {
            return false;
        }
        if (this.operator == null ? other.operator != null : !this.operator.equals((Object)other.operator)) {
            return false;
        }
        return !(this.selectionContext == null ? other.selectionContext != null : !this.selectionContext.equals(other.selectionContext));
    }

    public MetadataElement getRootElement() {
        return this.level;
    }

    public ParseTreeNode visit() {
        if (this.level.getLevelType().equals(Level.Type.ALL) && this.operator.equals((Object)Selection.Operator.MEMBERS)) {
            try {
                return Olap4jNodeConverter.toOlap4j(this.level.getHierarchy().getDefaultMember(), Selection.Operator.MEMBER);
            }
            catch (OlapException e) {
                e.printStackTrace();
            }
        }
        return Olap4jNodeConverter.toOlap4j(this.level, this.operator);
    }

    public void setOperator(Selection.Operator operator) {
        if (!operator.equals((Object)Selection.Operator.MEMBERS)) {
            throw new IllegalArgumentException("Selections based on a Level have to be of Operator MEMBERS.");
        }
        super.setOperator(operator);
    }
}

