/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.command;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.redisson.RedissonShutdownException;
import org.redisson.ScanResult;
import org.redisson.api.NodeType;
import org.redisson.cache.LRUCacheMap;
import org.redisson.client.RedisAskException;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisException;
import org.redisson.client.RedisLoadingException;
import org.redisson.client.RedisMovedException;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.RedisResponseTimeoutException;
import org.redisson.client.RedisRetryException;
import org.redisson.client.RedisTimeoutException;
import org.redisson.client.WriteRedisConnectionException;
import org.redisson.client.codec.BaseCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.CommandsData;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.connection.NodeSource;
import org.redisson.liveobject.core.RedissonObjectBuilder;
import org.redisson.misc.LogHelper;
import org.redisson.misc.RedisURI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisExecutor<V, R> {
    static final Logger log = LoggerFactory.getLogger(RedisExecutor.class);
    final boolean readOnlyMode;
    final RedisCommand<V> command;
    final Object[] params;
    final CompletableFuture<R> mainPromise;
    final boolean ignoreRedirect;
    final RedissonObjectBuilder objectBuilder;
    final ConnectionManager connectionManager;
    final RedissonObjectBuilder.ReferenceType referenceType;
    final boolean noRetry;
    CompletableFuture<RedisConnection> connectionFuture;
    NodeSource source;
    MasterSlaveEntry entry;
    Codec codec;
    volatile int attempt;
    volatile Optional<Timeout> timeout = Optional.empty();
    volatile BiConsumer<R, Throwable> mainPromiseListener;
    volatile ChannelFuture writeFuture;
    volatile RedisException exception;
    int attempts;
    long retryInterval;
    long responseTimeout;
    private static final Map<ClassLoader, Map<Codec, Codec>> CODECS = new LRUCacheMap<ClassLoader, Map<Codec, Codec>>(25, 0L, 0L);

    public RedisExecutor(boolean readOnlyMode, NodeSource source, Codec codec, RedisCommand<V> command, Object[] params, CompletableFuture<R> mainPromise, boolean ignoreRedirect, ConnectionManager connectionManager, RedissonObjectBuilder objectBuilder, RedissonObjectBuilder.ReferenceType referenceType, boolean noRetry) {
        this.readOnlyMode = readOnlyMode;
        this.source = source;
        this.codec = codec;
        this.command = command;
        this.params = params;
        this.mainPromise = mainPromise;
        this.ignoreRedirect = ignoreRedirect;
        this.connectionManager = connectionManager;
        this.objectBuilder = objectBuilder;
        this.noRetry = noRetry;
        this.attempts = connectionManager.getServiceManager().getConfig().getRetryAttempts();
        this.retryInterval = connectionManager.getServiceManager().getConfig().getRetryInterval();
        this.responseTimeout = connectionManager.getServiceManager().getConfig().getTimeout();
        this.referenceType = referenceType;
    }

    public void execute() {
        if (this.mainPromise.isCancelled()) {
            this.free();
            return;
        }
        if (!this.connectionManager.getServiceManager().getShutdownLatch().acquire()) {
            this.free();
            this.mainPromise.completeExceptionally(new RedissonShutdownException("Redisson is shutdown"));
            return;
        }
        this.codec = this.getCodec(this.codec);
        CompletableFuture<RedisConnection> connectionFuture = this.getConnection();
        CompletableFuture attemptPromise = new CompletableFuture();
        this.mainPromiseListener = (r, e) -> {
            if (!this.mainPromise.isCancelled()) {
                return;
            }
            if (connectionFuture.cancel(false)) {
                log.debug("Connection obtaining canceled for {}", this.command);
                this.timeout.ifPresent(Timeout::cancel);
                if (attemptPromise.cancel(false)) {
                    this.free();
                }
            } else if (this.command.isBlockingCommand()) {
                RedisConnection c = connectionFuture.getNow(null);
                if (this.writeFuture.cancel(false)) {
                    attemptPromise.cancel(false);
                } else {
                    c.forceFastReconnectAsync().whenComplete((res, ex) -> attemptPromise.cancel(true));
                }
            }
        };
        if (this.attempt == 0) {
            this.mainPromise.whenComplete((r, e) -> {
                if (this.mainPromiseListener != null) {
                    this.mainPromiseListener.accept((R)r, (Throwable)e);
                }
            });
        }
        this.scheduleRetryTimeout(connectionFuture, attemptPromise);
        this.scheduleConnectionTimeout(attemptPromise, connectionFuture);
        connectionFuture.whenComplete((connection, e) -> {
            if (connectionFuture.isCancelled()) {
                this.connectionManager.getServiceManager().getShutdownLatch().release();
                return;
            }
            if (connectionFuture.isDone() && connectionFuture.isCompletedExceptionally()) {
                this.connectionManager.getServiceManager().getShutdownLatch().release();
                this.exception = this.convertException(connectionFuture);
                if (this.attempt == this.attempts) {
                    attemptPromise.completeExceptionally(this.exception);
                }
                return;
            }
            this.sendCommand(attemptPromise, (RedisConnection)connection);
            this.scheduleWriteTimeout(attemptPromise);
            this.writeFuture.addListener((GenericFutureListener)((ChannelFutureListener)future -> this.checkWriteFuture(this.writeFuture, attemptPromise, (RedisConnection)connection)));
        });
        attemptPromise.whenComplete((r, e) -> {
            this.releaseConnection(attemptPromise, connectionFuture);
            this.checkAttemptPromise(attemptPromise, connectionFuture);
        });
    }

    private void scheduleConnectionTimeout(CompletableFuture<R> attemptPromise, CompletableFuture<RedisConnection> connectionFuture) {
        if (this.retryInterval > 0L && this.attempts > 0) {
            return;
        }
        this.timeout.ifPresent(Timeout::cancel);
        TimerTask task = timeout -> {
            if (connectionFuture.cancel(false)) {
                this.exception = new RedisTimeoutException("Unable to acquire connection! " + this.connectionFuture + "Increase connection pool size or timeout. Node source: " + this.source + ", command: " + LogHelper.toString(this.command, this.params) + " after " + this.attempt + " retry attempts");
                attemptPromise.completeExceptionally(this.exception);
            }
        };
        this.timeout = Optional.of(this.connectionManager.getServiceManager().newTimeout(task, this.responseTimeout, TimeUnit.MILLISECONDS));
    }

    private void scheduleWriteTimeout(CompletableFuture<R> attemptPromise) {
        if (this.retryInterval > 0L && this.attempts > 0) {
            return;
        }
        this.timeout.ifPresent(Timeout::cancel);
        TimerTask task = timeout -> {
            if (this.writeFuture.cancel(false)) {
                this.exception = new RedisTimeoutException("Command still hasn't been written into connection! Check connection with Redis node: " + this.connectionFuture.join().getRedisClient().getAddr() + " for TCP packet drops. Try to increase nettyThreads setting.  Node source: " + this.source + ", connection: " + this.connectionFuture.join() + ", command: " + LogHelper.toString(this.command, this.params) + " after " + this.attempt + " retry attempts");
                attemptPromise.completeExceptionally(this.exception);
            }
        };
        this.timeout = Optional.of(this.connectionManager.getServiceManager().newTimeout(task, this.responseTimeout, TimeUnit.MILLISECONDS));
    }

    private void scheduleRetryTimeout(final CompletableFuture<RedisConnection> connectionFuture, final CompletableFuture<R> attemptPromise) {
        if (this.retryInterval == 0L || this.attempts == 0) {
            return;
        }
        TimerTask retryTimerTask = new TimerTask(){

            public void run(Timeout t) throws Exception {
                if (attemptPromise.isDone()) {
                    return;
                }
                if (connectionFuture.cancel(false)) {
                    RedisExecutor.this.exception = new RedisTimeoutException("Unable to acquire connection! " + connectionFuture + "Increase connection pool size. Node source: " + RedisExecutor.this.source + ", command: " + LogHelper.toString(RedisExecutor.this.command, RedisExecutor.this.params) + " after " + RedisExecutor.this.attempt + " retry attempts");
                } else if (connectionFuture.isDone() && !connectionFuture.isCompletedExceptionally()) {
                    if (RedisExecutor.this.writeFuture == null || !RedisExecutor.this.writeFuture.isDone()) {
                        if (RedisExecutor.this.attempt == RedisExecutor.this.attempts) {
                            if (RedisExecutor.this.writeFuture != null && RedisExecutor.this.writeFuture.cancel(false)) {
                                if (RedisExecutor.this.exception == null) {
                                    RedisExecutor.this.exception = new RedisTimeoutException("Command still hasn't been written into connection! Check connection with Redis node: " + ((RedisConnection)RedisExecutor.this.getNow(connectionFuture)).getRedisClient().getAddr() + " for TCP packet drops. Try to increase nettyThreads setting.  Node source: " + RedisExecutor.this.source + ", connection: " + RedisExecutor.this.getNow(connectionFuture) + ", command: " + LogHelper.toString(RedisExecutor.this.command, RedisExecutor.this.params) + " after " + RedisExecutor.this.attempt + " retry attempts");
                                }
                                attemptPromise.completeExceptionally(RedisExecutor.this.exception);
                            }
                            return;
                        }
                        ++RedisExecutor.this.attempt;
                        RedisExecutor.this.scheduleRetryTimeout(connectionFuture, attemptPromise);
                        return;
                    }
                    if (RedisExecutor.this.writeFuture.isSuccess()) {
                        return;
                    }
                }
                if (RedisExecutor.this.mainPromise.isCancelled()) {
                    if (attemptPromise.cancel(false)) {
                        RedisExecutor.this.free();
                    }
                    return;
                }
                if (RedisExecutor.this.attempt == RedisExecutor.this.attempts) {
                    if (RedisExecutor.this.exception != null) {
                        attemptPromise.completeExceptionally(RedisExecutor.this.exception);
                    }
                    return;
                }
                if (!attemptPromise.cancel(false)) {
                    return;
                }
                ++RedisExecutor.this.attempt;
                if (log.isDebugEnabled()) {
                    log.debug("attempt {} for command {} and params {} to {}", new Object[]{RedisExecutor.this.attempt, RedisExecutor.this.command, LogHelper.toString(RedisExecutor.this.params), RedisExecutor.this.source});
                }
                RedisExecutor.this.mainPromiseListener = null;
                RedisExecutor.this.execute();
            }
        };
        this.timeout = Optional.of(this.connectionManager.getServiceManager().newTimeout(retryTimerTask, this.retryInterval, TimeUnit.MILLISECONDS));
    }

    protected void free() {
        this.free(this.params);
    }

    protected void free(Object[] params) {
        for (Object obj : params) {
            ReferenceCountUtil.safeRelease((Object)obj);
        }
    }

    private void checkWriteFuture(ChannelFuture future, CompletableFuture<R> attemptPromise, RedisConnection connection) {
        if (future.isCancelled() || attemptPromise.isDone()) {
            return;
        }
        if (!future.isSuccess()) {
            this.exception = new WriteRedisConnectionException("Unable to write command into connection! Increase nettyThreads setting. Node source: " + this.source + ", connection: " + connection + ", command: " + LogHelper.toString(this.command, this.params) + " after " + this.attempt + " retry attempts", future.cause());
            if (this.attempt == this.attempts) {
                attemptPromise.completeExceptionally(this.exception);
            }
            return;
        }
        this.scheduleResponseTimeout(attemptPromise, connection);
    }

    private void scheduleResponseTimeout(CompletableFuture<R> attemptPromise, RedisConnection connection) {
        this.timeout.ifPresent(Timeout::cancel);
        long timeoutTime = this.responseTimeout;
        if (this.command != null && this.command.isBlockingCommand()) {
            long popTimeout = 0L;
            if (RedisCommands.BLOCKING_COMMANDS.contains(this.command)) {
                for (int i = 0; i < this.params.length - 1; ++i) {
                    if (!"BLOCK".equals(this.params[i])) continue;
                    popTimeout = Long.valueOf(this.params[i + 1].toString());
                    break;
                }
            } else {
                popTimeout = Long.valueOf(this.params[this.params.length - 1].toString()) * 1000L;
            }
            this.handleBlockingOperations(attemptPromise, connection, popTimeout);
            if (popTimeout == 0L) {
                return;
            }
            timeoutTime += popTimeout;
            timeoutTime += 1000L;
        }
        long timeoutAmount = timeoutTime;
        TimerTask timeoutResponseTask = timeout -> {
            if (this.isResendAllowed(this.attempt, this.attempts)) {
                if (!attemptPromise.cancel(false)) {
                    return;
                }
                this.connectionManager.getServiceManager().newTimeout(t -> {
                    ++this.attempt;
                    if (log.isDebugEnabled()) {
                        log.debug("response timeout. new attempt {} for command {} and params {} node {}", new Object[]{this.attempt, this.command, LogHelper.toString(this.params), this.source});
                    }
                    this.mainPromiseListener = null;
                    this.execute();
                }, this.retryInterval, TimeUnit.MILLISECONDS);
                return;
            }
            attemptPromise.completeExceptionally(new RedisResponseTimeoutException("Redis server response timeout (" + timeoutAmount + " ms) occured after " + this.attempt + " retry attempts, is non-idempotent command: " + (this.command != null && this.command.isNoRetry()) + " Check connection with Redis node: " + connection.getRedisClient().getAddr() + " for TCP packet drops or bandwidth limits.  Try to increase nettyThreads and/or timeout settings. Command: " + LogHelper.toString(this.command, this.params) + ", channel: " + connection.getChannel()));
        };
        this.timeout = Optional.of(this.connectionManager.getServiceManager().newTimeout(timeoutResponseTask, timeoutTime, TimeUnit.MILLISECONDS));
    }

    protected boolean isResendAllowed(int attempt, int attempts) {
        return attempt < attempts && !this.noRetry && (this.command == null || !this.command.isBlockingCommand() && !this.command.isNoRetry());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleBlockingOperations(CompletableFuture<R> attemptPromise, RedisConnection connection, long popTimeout) {
        FutureListener listener = f -> this.mainPromise.completeExceptionally(new RedissonShutdownException("Redisson is shutdown"));
        Timeout scheduledFuture = popTimeout != 0L ? this.connectionManager.getServiceManager().newTimeout(timeout -> {
            if (attemptPromise.complete(null)) {
                connection.forceFastReconnectAsync();
            }
        }, popTimeout + 3000L, TimeUnit.MILLISECONDS) : null;
        this.mainPromise.whenComplete((res, e) -> {
            if (scheduledFuture != null) {
                scheduledFuture.cancel();
            }
            FutureListener futureListener = listener;
            synchronized (futureListener) {
                this.connectionManager.getServiceManager().getShutdownPromise().removeListener((GenericFutureListener)listener);
            }
            if ((this.mainPromise.isCancelled() || e instanceof InterruptedException) && !attemptPromise.isDone()) {
                log.debug("Canceled blocking operation {} used {}", this.command, (Object)connection);
                connection.forceFastReconnectAsync().whenComplete((r, ex) -> attemptPromise.cancel(true));
                return;
            }
            if (e instanceof RedissonShutdownException) {
                attemptPromise.completeExceptionally((Throwable)e);
            }
        });
        FutureListener futureListener = listener;
        synchronized (futureListener) {
            if (!this.mainPromise.isDone()) {
                this.connectionManager.getServiceManager().getShutdownPromise().addListener((GenericFutureListener)listener);
            }
        }
    }

    protected Throwable cause(CompletableFuture<?> future) {
        try {
            future.getNow(null);
            return null;
        }
        catch (CompletionException ex2) {
            return ex2.getCause();
        }
        catch (CancellationException ex1) {
            return ex1;
        }
    }

    protected void checkAttemptPromise(CompletableFuture<R> attemptFuture, CompletableFuture<RedisConnection> connectionFuture) {
        this.timeout.ifPresent(Timeout::cancel);
        if (attemptFuture.isCancelled()) {
            return;
        }
        try {
            ClientConnectionsEntry ce;
            RedisConnection connection;
            this.mainPromiseListener = null;
            Throwable cause = this.cause(attemptFuture);
            if (cause instanceof RedisMovedException && !this.ignoreRedirect) {
                RedisMovedException ex = (RedisMovedException)cause;
                if (this.source.getRedirect() == NodeSource.Redirect.MOVED) {
                    this.mainPromise.completeExceptionally(new RedisException("MOVED redirection loop detected. Node " + this.source.getAddr() + " has further redirect to " + ex.getUrl()));
                    return;
                }
                this.onException();
                CompletableFuture<RedisURI> ipAddrFuture = this.connectionManager.getServiceManager().resolveIP(ex.getUrl());
                ipAddrFuture.whenComplete((ip, e) -> {
                    if (e != null) {
                        this.handleError(connectionFuture, (Throwable)e);
                        return;
                    }
                    this.source = new NodeSource(ex.getSlot(), (RedisURI)ip, NodeSource.Redirect.MOVED);
                    this.execute();
                });
                return;
            }
            if (cause instanceof RedisAskException && !this.ignoreRedirect) {
                RedisAskException ex = (RedisAskException)cause;
                this.onException();
                CompletableFuture<RedisURI> ipAddrFuture = this.connectionManager.getServiceManager().resolveIP(ex.getUrl());
                ipAddrFuture.whenComplete((ip, e) -> {
                    if (e != null) {
                        this.handleError(connectionFuture, (Throwable)e);
                        return;
                    }
                    this.source = new NodeSource(ex.getSlot(), (RedisURI)ip, NodeSource.Redirect.ASK);
                    this.execute();
                });
                return;
            }
            if (cause instanceof RedisLoadingException && (connection = (RedisConnection)connectionFuture.getNow(null)) != null && (ce = this.entry.getEntry(connection.getRedisClient())) != null && ce.getNodeType() == NodeType.SLAVE) {
                this.source = new NodeSource(this.entry.getClient());
                this.execute();
                return;
            }
            if (cause instanceof RedisRetryException && this.attempt < this.attempts) {
                this.onException();
                this.connectionManager.getServiceManager().newTimeout(timeout -> {
                    ++this.attempt;
                    this.execute();
                }, this.retryInterval, TimeUnit.MILLISECONDS);
                return;
            }
            this.free();
            this.handleResult(attemptFuture, connectionFuture);
        }
        catch (Exception e2) {
            this.handleError(connectionFuture, e2);
        }
    }

    protected void handleResult(CompletableFuture<R> attemptPromise, CompletableFuture<RedisConnection> connectionFuture) throws ReflectiveOperationException {
        R res;
        try {
            res = attemptPromise.getNow(null);
        }
        catch (CompletionException e) {
            this.handleError(connectionFuture, e.getCause());
            return;
        }
        catch (CancellationException e) {
            this.handleError(connectionFuture, e);
            return;
        }
        if (res instanceof ScanResult) {
            ((ScanResult)res).setRedisClient(this.getNow(connectionFuture).getRedisClient());
        }
        this.handleSuccess(this.mainPromise, connectionFuture, res);
    }

    protected void onException() {
    }

    protected void handleError(CompletableFuture<RedisConnection> connectionFuture, Throwable cause) {
        this.mainPromise.completeExceptionally(cause);
    }

    protected void handleSuccess(CompletableFuture<R> promise, CompletableFuture<RedisConnection> connectionFuture, R res) throws ReflectiveOperationException {
        if (this.objectBuilder != null) {
            this.handleReference(promise, res);
        } else {
            promise.complete(res);
        }
    }

    private void handleReference(CompletableFuture<R> promise, R res) throws ReflectiveOperationException {
        if (this.objectBuilder != null) {
            promise.complete(this.objectBuilder.tryHandleReference(res, this.referenceType));
        } else {
            promise.complete(res);
        }
    }

    protected void sendCommand(CompletableFuture<R> attemptPromise, RedisConnection connection) {
        if (this.source.getRedirect() == NodeSource.Redirect.ASK) {
            ArrayList list = new ArrayList(2);
            CompletableFuture promise = new CompletableFuture();
            list.add(new CommandData(promise, this.codec, RedisCommands.ASKING, new Object[0]));
            list.add(new CommandData<V, R>(attemptPromise, this.codec, this.command, this.params));
            CompletableFuture<Void> main = new CompletableFuture<Void>();
            this.writeFuture = connection.send(new CommandsData(main, list, false, false));
        } else {
            if (log.isDebugEnabled()) {
                String connectionType = " ";
                if (connection instanceof RedisPubSubConnection) {
                    connectionType = " pubsub ";
                }
                log.debug("acquired{}connection for command {} and params {} from slot {} using node {}... {}", new Object[]{connectionType, this.command, LogHelper.toString(this.params), this.source, connection.getRedisClient().getAddr(), connection});
            }
            this.writeFuture = connection.send(new CommandData<V, R>(attemptPromise, this.codec, this.command, this.params));
            if (this.connectionManager.getServiceManager().getConfig().getMasterConnectionPoolSize() < 10 && !this.command.isBlockingCommand()) {
                this.release(connection);
            }
        }
    }

    protected void releaseConnection(CompletableFuture<R> attemptPromise, CompletableFuture<RedisConnection> connectionFuture) {
        if (connectionFuture.isDone() && connectionFuture.isCompletedExceptionally()) {
            return;
        }
        RedisConnection connection = this.getNow(connectionFuture);
        this.connectionManager.getServiceManager().getShutdownLatch().release();
        if (this.connectionManager.getServiceManager().getConfig().getMasterConnectionPoolSize() < 10) {
            if (this.source.getRedirect() == NodeSource.Redirect.ASK || this.getClass() != RedisExecutor.class || this.command != null && this.command.isBlockingCommand()) {
                this.release(connection);
            }
        } else {
            this.release(connection);
        }
        if (log.isDebugEnabled()) {
            String connectionType = " ";
            if (connection instanceof RedisPubSubConnection) {
                connectionType = " pubsub ";
            }
            log.debug("connection{}released for command {} and params {} from slot {} using connection {}", new Object[]{connectionType, this.command, LogHelper.toString(this.params), this.source, connection});
        }
    }

    private void release(RedisConnection connection) {
        if (this.readOnlyMode) {
            this.entry.releaseRead(connection);
        } else {
            this.entry.releaseWrite(connection);
        }
    }

    public RedisClient getRedisClient() {
        return this.getNow(this.connectionFuture).getRedisClient();
    }

    protected CompletableFuture<RedisConnection> getConnection() {
        this.connectionFuture = this.readOnlyMode ? this.connectionReadOp(this.command) : this.connectionWriteOp(this.command);
        return this.connectionFuture;
    }

    protected Codec getCodec(Codec codec) {
        Map map;
        if (codec == null) {
            return null;
        }
        if (!this.connectionManager.getServiceManager().getCfg().isUseThreadClassLoader()) {
            return codec;
        }
        for (Class<?> clazz : BaseCodec.SKIPPED_CODECS) {
            if (!clazz.isAssignableFrom(codec.getClass())) continue;
            return codec;
        }
        Codec codecToUse = codec;
        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
        if (threadClassLoader != null && (codecToUse = (Codec)(map = CODECS.computeIfAbsent(threadClassLoader, k -> new LRUCacheMap(200, 0L, 0L))).get(codec)) == null) {
            try {
                codecToUse = (Codec)codec.getClass().getConstructor(ClassLoader.class, codec.getClass()).newInstance(threadClassLoader, codec);
            }
            catch (NoSuchMethodException e) {
                codecToUse = codec;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            map.put(codec, codecToUse);
        }
        return codecToUse;
    }

    protected <T> T getNow(CompletableFuture<T> future) {
        try {
            return future.getNow(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected <T> RedisException convertException(CompletableFuture<T> future) {
        Throwable cause = this.cause(future);
        if (cause instanceof RedisException) {
            return (RedisException)cause;
        }
        return new RedisException("Unexpected exception while processing command", cause);
    }

    final CompletableFuture<RedisConnection> connectionReadOp(RedisCommand<?> command) {
        this.entry = this.getEntry(true);
        if (this.entry == null) {
            CompletableFuture<RedisConnection> f = new CompletableFuture<RedisConnection>();
            f.completeExceptionally(this.connectionManager.getServiceManager().createNodeNotFoundException(this.source));
            return f;
        }
        if (this.source.getRedirect() != null) {
            return this.entry.connectionReadOp(command, this.source.getAddr());
        }
        if (this.source.getRedisClient() != null) {
            return this.entry.connectionReadOp(command, this.source.getRedisClient());
        }
        return this.entry.connectionReadOp(command);
    }

    final CompletableFuture<RedisConnection> connectionWriteOp(RedisCommand<?> command) {
        this.entry = this.getEntry(false);
        if (this.entry == null) {
            CompletableFuture<RedisConnection> f = new CompletableFuture<RedisConnection>();
            f.completeExceptionally(this.connectionManager.getServiceManager().createNodeNotFoundException(this.source));
            return f;
        }
        if (this.source.getRedirect() != null && !this.source.getAddr().equals(this.entry.getClient().getAddr()) && this.entry.hasSlave(this.source.getAddr())) {
            return this.entry.redirectedConnectionWriteOp(command, this.source.getAddr());
        }
        return this.entry.connectionWriteOp(command);
    }

    private MasterSlaveEntry getEntry(boolean read) {
        if (this.source.getRedirect() != null) {
            return this.connectionManager.getEntry(this.source.getAddr());
        }
        MasterSlaveEntry entry = this.source.getEntry();
        if (this.source.getRedisClient() != null) {
            entry = this.connectionManager.getEntry(this.source.getRedisClient());
        }
        if (entry == null && this.source.getSlot() != null) {
            entry = read ? this.connectionManager.getReadEntry(this.source.getSlot()) : this.connectionManager.getWriteEntry(this.source.getSlot());
        }
        return entry;
    }
}

