/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.command;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.redisson.RedisClientResult;
import org.redisson.RedissonReference;
import org.redisson.RedissonShutdownException;
import org.redisson.SlotCallback;
import org.redisson.api.RFuture;
import org.redisson.api.RedissonClient;
import org.redisson.api.RedissonReactiveClient;
import org.redisson.client.RedisAskException;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisException;
import org.redisson.client.RedisLoadingException;
import org.redisson.client.RedisMovedException;
import org.redisson.client.RedisTimeoutException;
import org.redisson.client.RedisTryAgainException;
import org.redisson.client.WriteRedisConnectionException;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.CommandsData;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.ScoredEntry;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.client.protocol.decoder.MapScanResult;
import org.redisson.client.protocol.decoder.ScanObjectEntry;
import org.redisson.command.AsyncDetails;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.connection.NodeSource;
import org.redisson.misc.LogHelper;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonObjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandAsyncService
implements CommandAsyncExecutor {
    static final Logger log = LoggerFactory.getLogger(CommandAsyncService.class);
    final ConnectionManager connectionManager;
    protected RedissonClient redisson;
    protected RedissonReactiveClient redissonReactive;

    public CommandAsyncService(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    @Override
    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Override
    public CommandAsyncExecutor enableRedissonReferenceSupport(RedissonClient redisson) {
        if (redisson != null) {
            this.redisson = redisson;
            this.redissonReactive = null;
        }
        return this;
    }

    @Override
    public CommandAsyncExecutor enableRedissonReferenceSupport(RedissonReactiveClient redissonReactive) {
        if (redissonReactive != null) {
            this.redissonReactive = redissonReactive;
            this.redisson = null;
        }
        return this;
    }

    @Override
    public boolean isRedissonReferenceSupportEnabled() {
        return this.redisson != null || this.redissonReactive != null;
    }

    @Override
    public void syncSubscription(RFuture<?> future) {
        MasterSlaveServersConfig config = this.connectionManager.getConfig();
        try {
            int timeout = config.getTimeout() + config.getRetryInterval() * config.getRetryAttempts();
            if (!future.await(timeout)) {
                throw new RedisTimeoutException("Subscribe timeout: (" + timeout + "ms)");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        future.syncUninterruptibly();
    }

    @Override
    public <V> V get(RFuture<V> future) {
        if (!future.isDone()) {
            final CountDownLatch l = new CountDownLatch(1);
            future.addListener(new FutureListener<V>(){

                public void operationComplete(Future<V> future) throws Exception {
                    l.countDown();
                }
            });
            boolean interrupted = false;
            while (!future.isDone()) {
                try {
                    l.await();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        if (future.isSuccess()) {
            return future.getNow();
        }
        throw this.convertException(future);
    }

    @Override
    public boolean await(RFuture<?> future, long timeout, TimeUnit timeoutUnit) throws InterruptedException {
        final CountDownLatch l = new CountDownLatch(1);
        future.addListener(new FutureListener<Object>(){

            public void operationComplete(Future<Object> future) throws Exception {
                l.countDown();
            }
        });
        return l.await(timeout, timeoutUnit);
    }

    @Override
    public <T, R> RFuture<R> readAsync(RedisClient client, MasterSlaveEntry entry, Codec codec, RedisCommand<T> command, Object ... params) {
        RPromise mainPromise = this.connectionManager.newPromise();
        this.async(true, new NodeSource(entry, client), codec, command, params, mainPromise, 0);
        return mainPromise;
    }

    @Override
    public <T, R> RFuture<R> readAsync(RedisClient client, String name, Codec codec, RedisCommand<T> command, Object ... params) {
        RPromise mainPromise = this.connectionManager.newPromise();
        int slot = this.connectionManager.calcSlot(name);
        this.async(true, new NodeSource(slot, client), codec, command, params, mainPromise, 0);
        return mainPromise;
    }

    @Override
    public <T, R> RFuture<R> readAsync(RedisClient client, Codec codec, RedisCommand<T> command, Object ... params) {
        RPromise mainPromise = this.connectionManager.newPromise();
        this.async(true, new NodeSource(client), codec, command, params, mainPromise, 0);
        return mainPromise;
    }

    @Override
    public <T, R> RFuture<Collection<R>> readAllAsync(RedisCommand<T> command, Object ... params) {
        final RPromise<Collection<R>> mainPromise = this.connectionManager.newPromise();
        Collection<MasterSlaveEntry> nodes = this.connectionManager.getEntrySet();
        final ArrayList results = new ArrayList();
        final AtomicInteger counter = new AtomicInteger(nodes.size());
        FutureListener listener = new FutureListener<R>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void operationComplete(Future<R> future) throws Exception {
                if (!future.isSuccess()) {
                    mainPromise.tryFailure(future.cause());
                    return;
                }
                Object result = future.getNow();
                if (result instanceof Collection) {
                    List list = results;
                    synchronized (list) {
                        results.addAll((Collection)result);
                    }
                }
                List list = results;
                synchronized (list) {
                    results.add(result);
                }
                if (counter.decrementAndGet() == 0 && !mainPromise.isDone()) {
                    mainPromise.trySuccess(results);
                }
            }
        };
        for (MasterSlaveEntry entry : nodes) {
            RPromise promise = this.connectionManager.newPromise();
            promise.addListener(listener);
            this.async(true, new NodeSource(entry), this.connectionManager.getCodec(), command, params, promise, 0);
        }
        return mainPromise;
    }

    @Override
    public <T, R> RFuture<R> readRandomAsync(RedisCommand<T> command, Object ... params) {
        RPromise mainPromise = this.connectionManager.newPromise();
        ArrayList<MasterSlaveEntry> nodes = new ArrayList<MasterSlaveEntry>(this.connectionManager.getEntrySet());
        Collections.shuffle(nodes);
        this.retryReadRandomAsync(command, mainPromise, nodes, params);
        return mainPromise;
    }

    private <R, T> void retryReadRandomAsync(final RedisCommand<T> command, final RPromise<R> mainPromise, final List<MasterSlaveEntry> nodes, final Object ... params) {
        RPromise attemptPromise = this.connectionManager.newPromise();
        attemptPromise.addListener(new FutureListener<R>(){

            public void operationComplete(Future<R> future) throws Exception {
                if (future.isSuccess()) {
                    if (future.getNow() == null) {
                        if (nodes.isEmpty()) {
                            mainPromise.trySuccess(null);
                        } else {
                            CommandAsyncService.this.retryReadRandomAsync(command, mainPromise, nodes, params);
                        }
                    } else {
                        mainPromise.trySuccess(future.getNow());
                    }
                } else {
                    mainPromise.tryFailure(future.cause());
                }
            }
        });
        MasterSlaveEntry entry = nodes.remove(0);
        this.async(true, new NodeSource(entry), this.connectionManager.getCodec(), command, params, attemptPromise, 0);
    }

    @Override
    public <T> RFuture<Void> writeAllAsync(RedisCommand<T> command, Object ... params) {
        return this.writeAllAsync(command, null, params);
    }

    @Override
    public <R, T> RFuture<R> writeAllAsync(RedisCommand<T> command, SlotCallback<T, R> callback, Object ... params) {
        return this.allAsync(false, command, callback, params);
    }

    @Override
    public <R, T> RFuture<R> readAllAsync(RedisCommand<T> command, SlotCallback<T, R> callback, Object ... params) {
        return this.allAsync(true, command, callback, params);
    }

    private <T, R> RFuture<R> allAsync(boolean readOnlyMode, RedisCommand<T> command, final SlotCallback<T, R> callback, Object ... params) {
        final RPromise mainPromise = this.connectionManager.newPromise();
        Collection<MasterSlaveEntry> nodes = this.connectionManager.getEntrySet();
        final AtomicInteger counter = new AtomicInteger(nodes.size());
        FutureListener listener = new FutureListener<T>(){

            public void operationComplete(Future<T> future) throws Exception {
                if (!future.isSuccess()) {
                    mainPromise.tryFailure(future.cause());
                    return;
                }
                if (callback != null) {
                    callback.onSlotResult(future.getNow());
                }
                if (counter.decrementAndGet() == 0) {
                    if (callback != null) {
                        mainPromise.trySuccess(callback.onFinish());
                    } else {
                        mainPromise.trySuccess(null);
                    }
                }
            }
        };
        for (MasterSlaveEntry entry : nodes) {
            RPromise promise = this.connectionManager.newPromise();
            promise.addListener(listener);
            this.async(readOnlyMode, new NodeSource(entry), this.connectionManager.getCodec(), command, params, promise, 0);
        }
        return mainPromise;
    }

    @Override
    public <V> RedisException convertException(RFuture<V> future) {
        return future.cause() instanceof RedisException ? (RedisException)future.cause() : new RedisException("Unexpected exception while processing command", future.cause());
    }

    private NodeSource getNodeSource(String key) {
        int slot = this.connectionManager.calcSlot(key);
        MasterSlaveEntry entry = this.connectionManager.getEntry(slot);
        return new NodeSource(entry);
    }

    @Override
    public <T, R> RFuture<R> readAsync(String key, Codec codec, RedisCommand<T> command, Object ... params) {
        RPromise mainPromise = this.connectionManager.newPromise();
        NodeSource source = this.getNodeSource(key);
        this.async(true, source, codec, command, params, mainPromise, 0);
        return mainPromise;
    }

    @Override
    public <T, R> RFuture<R> readAsync(MasterSlaveEntry entry, Codec codec, RedisCommand<T> command, Object ... params) {
        RPromise mainPromise = this.connectionManager.newPromise();
        this.async(true, new NodeSource(entry), codec, command, params, mainPromise, 0);
        return mainPromise;
    }

    @Override
    public <T, R> RFuture<R> writeAsync(MasterSlaveEntry entry, Codec codec, RedisCommand<T> command, Object ... params) {
        RPromise mainPromise = this.connectionManager.newPromise();
        this.async(false, new NodeSource(entry), codec, command, params, mainPromise, 0);
        return mainPromise;
    }

    @Override
    public <T, R> RFuture<R> readAsync(String key, RedisCommand<T> command, Object ... params) {
        return this.readAsync(key, this.connectionManager.getCodec(), command, params);
    }

    @Override
    public <T, R> RFuture<R> evalReadAsync(String key, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        NodeSource source = this.getNodeSource(key);
        return this.evalAsync(source, true, codec, evalCommandType, script, keys, params);
    }

    @Override
    public <T, R> RFuture<R> evalReadAsync(MasterSlaveEntry entry, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        return this.evalAsync(new NodeSource(entry), true, codec, evalCommandType, script, keys, params);
    }

    @Override
    public <T, R> RFuture<R> evalReadAsync(RedisClient client, String name, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        int slot = this.connectionManager.calcSlot(name);
        return this.evalAsync(new NodeSource(slot, client), true, codec, evalCommandType, script, keys, params);
    }

    @Override
    public <T, R> RFuture<R> evalWriteAsync(String key, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        NodeSource source = this.getNodeSource(key);
        return this.evalAsync(source, false, codec, evalCommandType, script, keys, params);
    }

    @Override
    public <T, R> RFuture<R> evalWriteAsync(MasterSlaveEntry entry, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        return this.evalAsync(new NodeSource(entry), false, codec, evalCommandType, script, keys, params);
    }

    @Override
    public <T, R> RFuture<R> evalWriteAllAsync(RedisCommand<T> command, SlotCallback<T, R> callback, String script, List<Object> keys, Object ... params) {
        return this.evalAllAsync(false, command, callback, script, keys, params);
    }

    public <T, R> RFuture<R> evalAllAsync(boolean readOnlyMode, RedisCommand<T> command, final SlotCallback<T, R> callback, String script, List<Object> keys, Object ... params) {
        final RPromise mainPromise = this.connectionManager.newPromise();
        Collection<MasterSlaveEntry> entries = this.connectionManager.getEntrySet();
        final AtomicInteger counter = new AtomicInteger(entries.size());
        FutureListener listener = new FutureListener<T>(){

            public void operationComplete(Future<T> future) throws Exception {
                if (!future.isSuccess()) {
                    mainPromise.tryFailure(future.cause());
                    return;
                }
                callback.onSlotResult(future.getNow());
                if (counter.decrementAndGet() == 0 && !mainPromise.isDone()) {
                    mainPromise.trySuccess(callback.onFinish());
                }
            }
        };
        ArrayList<Object> args = new ArrayList<Object>(2 + keys.size() + params.length);
        args.add(script);
        args.add(keys.size());
        args.addAll(keys);
        args.addAll(Arrays.asList(params));
        for (MasterSlaveEntry entry : entries) {
            RPromise promise = this.connectionManager.newPromise();
            promise.addListener(listener);
            this.async(readOnlyMode, new NodeSource(entry), this.connectionManager.getCodec(), command, args.toArray(), promise, 0);
        }
        return mainPromise;
    }

    private <T, R> RFuture<R> evalAsync(NodeSource nodeSource, boolean readOnlyMode, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        RPromise mainPromise = this.connectionManager.newPromise();
        ArrayList<Object> args = new ArrayList<Object>(2 + keys.size() + params.length);
        args.add(script);
        args.add(keys.size());
        args.addAll(keys);
        args.addAll(Arrays.asList(params));
        this.async(readOnlyMode, nodeSource, codec, evalCommandType, args.toArray(), mainPromise, 0);
        return mainPromise;
    }

    @Override
    public <T, R> RFuture<R> writeAsync(String key, RedisCommand<T> command, Object ... params) {
        return this.writeAsync(key, this.connectionManager.getCodec(), command, params);
    }

    @Override
    public <T, R> RFuture<R> writeAsync(String key, Codec codec, RedisCommand<T> command, Object ... params) {
        RPromise mainPromise = this.connectionManager.newPromise();
        NodeSource source = this.getNodeSource(key);
        this.async(false, source, codec, command, params, mainPromise, 0);
        return mainPromise;
    }

    protected <V, R> void async(boolean readOnlyMode, final NodeSource source, Codec codec, final RedisCommand<V> command, final Object[] params, RPromise<R> mainPromise, int attempt) {
        if (mainPromise.isCancelled()) {
            this.free(params);
            return;
        }
        if (!this.connectionManager.getShutdownLatch().acquire()) {
            this.free(params);
            mainPromise.tryFailure(new RedissonShutdownException("Redisson is shutdown"));
            return;
        }
        final AsyncDetails details = AsyncDetails.acquire();
        if (this.isRedissonReferenceSupportEnabled()) {
            try {
                for (int i = 0; i < params.length; ++i) {
                    RedissonReference reference = RedissonObjectFactory.toReference(this.getConnectionManager().getCfg(), params[i]);
                    if (reference == null) continue;
                    params[i] = reference;
                }
            }
            catch (Exception e) {
                this.connectionManager.getShutdownLatch().release();
                this.free(params);
                mainPromise.tryFailure(e);
                return;
            }
        }
        final RFuture<RedisConnection> connectionFuture = readOnlyMode ? this.connectionManager.connectionReadOp(source, command) : this.connectionManager.connectionWriteOp(source, command);
        RPromise attemptPromise = this.connectionManager.newPromise();
        details.init(connectionFuture, attemptPromise, readOnlyMode, source, codec, command, params, mainPromise, attempt);
        FutureListener mainPromiseListener = new FutureListener<R>(){

            public void operationComplete(Future<R> future) throws Exception {
                if (future.isCancelled() && connectionFuture.cancel(false)) {
                    log.debug("Connection obtaining canceled for {}", (Object)command);
                    details.getTimeout().cancel();
                    if (details.getAttemptPromise().cancel(false)) {
                        CommandAsyncService.this.free(params);
                    }
                }
            }
        };
        TimerTask retryTimerTask = new TimerTask(){

            public void run(Timeout t) throws Exception {
                if (details.getAttemptPromise().isDone()) {
                    return;
                }
                if (details.getConnectionFuture().cancel(false)) {
                    CommandAsyncService.this.connectionManager.getShutdownLatch().release();
                } else if (details.getConnectionFuture().isSuccess()) {
                    if (details.getWriteFuture() == null || !details.getWriteFuture().isDone()) {
                        if (details.getAttempt() == CommandAsyncService.this.connectionManager.getConfig().getRetryAttempts()) {
                            if (details.getWriteFuture() != null && details.getWriteFuture().cancel(false)) {
                                if (details.getException() == null) {
                                    details.setException(new RedisTimeoutException("Unable to send command: " + command + " with params: " + LogHelper.toString(details.getParams()) + " after " + CommandAsyncService.this.connectionManager.getConfig().getRetryAttempts() + " retry attempts"));
                                }
                                details.getAttemptPromise().tryFailure(details.getException());
                            }
                            return;
                        }
                        details.incAttempt();
                        Timeout timeout = CommandAsyncService.this.connectionManager.newTimeout(this, CommandAsyncService.this.connectionManager.getConfig().getRetryInterval(), TimeUnit.MILLISECONDS);
                        details.setTimeout(timeout);
                        return;
                    }
                    if (details.getWriteFuture().isDone() && details.getWriteFuture().isSuccess()) {
                        return;
                    }
                }
                if (details.getMainPromise().isCancelled()) {
                    if (details.getAttemptPromise().cancel(false)) {
                        CommandAsyncService.this.free(details);
                        AsyncDetails.release(details);
                    }
                    return;
                }
                if (details.getAttempt() == CommandAsyncService.this.connectionManager.getConfig().getRetryAttempts()) {
                    if (details.getException() == null) {
                        details.setException(new RedisTimeoutException("Unable to send command: " + command + " with params: " + LogHelper.toString(details.getParams()) + " after " + CommandAsyncService.this.connectionManager.getConfig().getRetryAttempts() + " retry attempts"));
                    }
                    details.getAttemptPromise().tryFailure(details.getException());
                    return;
                }
                if (!details.getAttemptPromise().cancel(false)) {
                    return;
                }
                int count = details.getAttempt() + 1;
                if (log.isDebugEnabled()) {
                    log.debug("attempt {} for command {} and params {}", new Object[]{count, details.getCommand(), Arrays.toString(details.getParams())});
                }
                details.removeMainPromiseListener();
                CommandAsyncService.this.async(details.isReadOnlyMode(), details.getSource(), details.getCodec(), details.getCommand(), details.getParams(), details.getMainPromise(), count);
                AsyncDetails.release(details);
            }
        };
        Timeout timeout = this.connectionManager.newTimeout(retryTimerTask, this.connectionManager.getConfig().getRetryInterval(), TimeUnit.MILLISECONDS);
        details.setTimeout(timeout);
        details.setupMainPromiseListener(mainPromiseListener);
        connectionFuture.addListener(new FutureListener<RedisConnection>(){

            public void operationComplete(Future<RedisConnection> connFuture) throws Exception {
                if (connFuture.isCancelled()) {
                    return;
                }
                if (!connFuture.isSuccess()) {
                    CommandAsyncService.this.connectionManager.getShutdownLatch().release();
                    details.setException(CommandAsyncService.this.convertException(connectionFuture));
                    return;
                }
                if (details.getAttemptPromise().isDone() || details.getMainPromise().isDone()) {
                    CommandAsyncService.this.releaseConnection(source, connectionFuture, details.isReadOnlyMode(), details.getAttemptPromise(), details);
                    return;
                }
                final RedisConnection connection = (RedisConnection)connFuture.getNow();
                if (details.getSource().getRedirect() == NodeSource.Redirect.ASK) {
                    ArrayList list = new ArrayList(2);
                    RPromise promise = CommandAsyncService.this.connectionManager.newPromise();
                    list.add(new CommandData(promise, details.getCodec(), RedisCommands.ASKING, new Object[0]));
                    list.add(new CommandData(details.getAttemptPromise(), details.getCodec(), details.getCommand(), details.getParams()));
                    RPromise<Void> main = CommandAsyncService.this.connectionManager.newPromise();
                    ChannelFuture future = connection.send(new CommandsData(main, list));
                    details.setWriteFuture(future);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("acquired connection for command {} and params {} from slot {} using node {}... {}", new Object[]{details.getCommand(), Arrays.toString(details.getParams()), details.getSource(), connection.getRedisClient().getAddr(), connection});
                    }
                    ChannelFuture future = connection.send(new CommandData(details.getAttemptPromise(), details.getCodec(), details.getCommand(), details.getParams()));
                    details.setWriteFuture(future);
                }
                details.getWriteFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        CommandAsyncService.this.checkWriteFuture(details, connection);
                    }
                });
                CommandAsyncService.this.releaseConnection(source, connectionFuture, details.isReadOnlyMode(), details.getAttemptPromise(), details);
            }
        });
        attemptPromise.addListener(new FutureListener<R>(){

            public void operationComplete(Future<R> future) throws Exception {
                CommandAsyncService.this.checkAttemptFuture(source, details, future);
            }
        });
    }

    protected void free(Object[] params) {
        for (Object obj : params) {
            ReferenceCountUtil.safeRelease((Object)obj);
        }
    }

    protected <V, R> void free(AsyncDetails<V, R> details) {
        for (Object obj : details.getParams()) {
            ReferenceCountUtil.safeRelease((Object)obj);
        }
    }

    private <V, R> void checkWriteFuture(final AsyncDetails<V, R> details, final RedisConnection connection) {
        ChannelFuture future = details.getWriteFuture();
        if (future.isCancelled() || details.getAttemptPromise().isDone()) {
            return;
        }
        if (!future.isSuccess()) {
            log.trace("Can't write {} to {}", details.getCommand(), (Object)connection);
            details.setException(new WriteRedisConnectionException("Can't write command: " + details.getCommand() + ", params: " + LogHelper.toString(details.getParams()) + " to channel: " + future.channel(), future.cause()));
            if (details.getAttempt() == this.connectionManager.getConfig().getRetryAttempts()) {
                details.getAttemptPromise().tryFailure(details.getException());
            }
            return;
        }
        details.getTimeout().cancel();
        long timeoutTime = this.connectionManager.getConfig().getTimeout();
        if (RedisCommands.BLOCKING_COMMANDS.contains(details.getCommand().getName())) {
            Long popTimeout = Long.valueOf(details.getParams()[details.getParams().length - 1].toString());
            this.handleBlockingOperations(details, connection, popTimeout);
            if (popTimeout == 0L) {
                return;
            }
            timeoutTime += popTimeout * 1000L;
            timeoutTime += 1000L;
        }
        final long timeoutAmount = timeoutTime;
        TimerTask timeoutTask = new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                details.getAttemptPromise().tryFailure(new RedisTimeoutException("Redis server response timeout (" + timeoutAmount + " ms) occured for command: " + details.getCommand() + " with params: " + LogHelper.toString(details.getParams()) + " channel: " + connection.getChannel()));
            }
        };
        Timeout timeout = this.connectionManager.newTimeout(timeoutTask, timeoutTime, TimeUnit.MILLISECONDS);
        details.setTimeout(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R, V> void handleBlockingOperations(final AsyncDetails<V, R> details, final RedisConnection connection, Long popTimeout) {
        Timeout scheduledFuture;
        FutureListener<Boolean> listener = new FutureListener<Boolean>(){

            public void operationComplete(Future<Boolean> future) throws Exception {
                details.getMainPromise().tryFailure(new RedissonShutdownException("Redisson is shutdown"));
            }
        };
        if (popTimeout != 0L) {
            final Channel orignalChannel = connection.getChannel();
            scheduledFuture = this.connectionManager.newTimeout(new TimerTask(){

                public void run(Timeout timeout) throws Exception {
                    if (orignalChannel == connection.getChannel() && connection.isActive()) {
                        return;
                    }
                    if (details.getAttemptPromise().trySuccess(null)) {
                        connection.forceFastReconnectAsync();
                    }
                }
            }, popTimeout, TimeUnit.SECONDS);
        } else {
            scheduledFuture = null;
        }
        details.getMainPromise().addListener(new FutureListener<R>((FutureListener)listener, details, connection){
            final /* synthetic */ FutureListener val$listener;
            final /* synthetic */ AsyncDetails val$details;
            final /* synthetic */ RedisConnection val$connection;
            {
                this.val$listener = futureListener;
                this.val$details = asyncDetails;
                this.val$connection = redisConnection;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void operationComplete(Future<R> future) throws Exception {
                if (scheduledFuture != null) {
                    scheduledFuture.cancel();
                }
                FutureListener futureListener = this.val$listener;
                synchronized (futureListener) {
                    CommandAsyncService.this.connectionManager.getShutdownPromise().removeListener((FutureListener<Boolean>)this.val$listener);
                }
                if (future.isCancelled() && !this.val$details.getAttemptPromise().isDone()) {
                    log.debug("Canceled blocking operation {} used {}", this.val$details.getCommand(), (Object)this.val$connection);
                    this.val$connection.forceFastReconnectAsync().addListener(new FutureListener<Void>(){

                        public void operationComplete(Future<Void> future) throws Exception {
                            val$details.getAttemptPromise().cancel(true);
                        }
                    });
                    return;
                }
                if (future.cause() instanceof RedissonShutdownException) {
                    this.val$details.getAttemptPromise().tryFailure(future.cause());
                }
            }
        });
        FutureListener<Boolean> futureListener = listener;
        synchronized (futureListener) {
            if (!details.getMainPromise().isDone()) {
                this.connectionManager.getShutdownPromise().addListener(listener);
            }
        }
    }

    protected <V, R> void releaseConnection(final NodeSource source, final RFuture<RedisConnection> connectionFuture, final boolean isReadOnly, RPromise<R> attemptPromise, final AsyncDetails<V, R> details) {
        attemptPromise.addListener(new FutureListener<R>(){

            public void operationComplete(Future<R> future) throws Exception {
                if (!connectionFuture.isSuccess()) {
                    return;
                }
                RedisConnection connection = (RedisConnection)connectionFuture.getNow();
                CommandAsyncService.this.connectionManager.getShutdownLatch().release();
                if (isReadOnly) {
                    CommandAsyncService.this.connectionManager.releaseRead(source, connection);
                } else {
                    CommandAsyncService.this.connectionManager.releaseWrite(source, connection);
                }
                if (log.isDebugEnabled()) {
                    log.debug("connection released for command {} and params {} from slot {} using connection {}", new Object[]{details.getCommand(), Arrays.toString(details.getParams()), details.getSource(), connection});
                }
            }
        });
    }

    private <R, V> void checkAttemptFuture(final NodeSource source, final AsyncDetails<V, R> details, Future<R> future) {
        details.getTimeout().cancel();
        if (future.isCancelled()) {
            return;
        }
        details.removeMainPromiseListener();
        if (future.cause() instanceof RedisMovedException) {
            RedisMovedException ex = (RedisMovedException)future.cause();
            this.async(details.isReadOnlyMode(), new NodeSource(ex.getSlot(), ex.getUrl(), NodeSource.Redirect.MOVED), details.getCodec(), details.getCommand(), details.getParams(), details.getMainPromise(), details.getAttempt());
            AsyncDetails.release(details);
            return;
        }
        if (future.cause() instanceof RedisAskException) {
            RedisAskException ex = (RedisAskException)future.cause();
            this.async(details.isReadOnlyMode(), new NodeSource(ex.getSlot(), ex.getUrl(), NodeSource.Redirect.ASK), details.getCodec(), details.getCommand(), details.getParams(), details.getMainPromise(), details.getAttempt());
            AsyncDetails.release(details);
            return;
        }
        if (future.cause() instanceof RedisLoadingException) {
            this.async(details.isReadOnlyMode(), source, details.getCodec(), details.getCommand(), details.getParams(), details.getMainPromise(), details.getAttempt());
            AsyncDetails.release(details);
            return;
        }
        if (future.cause() instanceof RedisTryAgainException) {
            this.connectionManager.newTimeout(new TimerTask(){

                public void run(Timeout timeout) throws Exception {
                    CommandAsyncService.this.async(details.isReadOnlyMode(), source, details.getCodec(), details.getCommand(), details.getParams(), details.getMainPromise(), details.getAttempt());
                }
            }, 1L, TimeUnit.SECONDS);
            AsyncDetails.release(details);
            return;
        }
        this.free(details);
        if (future.isSuccess()) {
            Object res = future.getNow();
            if (res instanceof RedisClientResult) {
                ((RedisClientResult)res).setRedisClient(details.getConnectionFuture().getNow().getRedisClient());
            }
            if (this.isRedissonReferenceSupportEnabled()) {
                this.handleReference(details.getMainPromise(), res);
            } else {
                details.getMainPromise().trySuccess(res);
            }
        } else {
            details.getMainPromise().tryFailure(future.cause());
        }
        AsyncDetails.release(details);
    }

    private <R, V> void handleReference(RPromise<R> mainPromise, R res) {
        try {
            mainPromise.trySuccess(this.tryHandleReference(res));
        }
        catch (Exception e) {
            mainPromise.trySuccess(res);
        }
    }

    protected <T> T tryHandleReference(T o) {
        boolean hasConversion = false;
        if (o instanceof List) {
            List r = (List)o;
            for (int i = 0; i < r.size(); ++i) {
                Object ref = this.tryHandleReference0(r.get(i));
                if (ref == r.get(i)) continue;
                r.set(i, ref);
            }
            return o;
        }
        if (o instanceof Set) {
            Set set;
            Set r = (Set)o;
            boolean useNewSet = o instanceof LinkedHashSet;
            try {
                set = (Set)o.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                set = new LinkedHashSet();
            }
            for (Object i : r) {
                Object ref = this.tryHandleReference0(i);
                if (useNewSet) {
                    set.add(ref);
                } else {
                    try {
                        r.add(ref);
                        set.add(i);
                    }
                    catch (Exception e) {
                        useNewSet = true;
                        set.add(ref);
                    }
                }
                hasConversion |= ref != i;
            }
            if (!hasConversion) {
                return o;
            }
            if (useNewSet) {
                return (T)set;
            }
            if (!set.isEmpty()) {
                r.removeAll(set);
            }
            return o;
        }
        if (o instanceof Map) {
            Map map;
            Map r = (Map)o;
            boolean useNewMap = o instanceof LinkedHashMap;
            try {
                map = (Map)o.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                map = new LinkedHashMap();
            }
            for (Map.Entry e : r.entrySet()) {
                Map.Entry ref = this.tryHandleReference0(e);
                if (useNewMap) {
                    map.put(ref.getKey(), ref.getValue());
                } else {
                    try {
                        r.put(ref.getKey(), ref.getValue());
                        if (e.getKey() != ref.getKey()) {
                            map.put(e.getKey(), e.getValue());
                        }
                    }
                    catch (Exception ex) {
                        useNewMap = true;
                        map.put(ref.getKey(), ref.getValue());
                    }
                }
                hasConversion |= ref != e;
            }
            if (!hasConversion) {
                return o;
            }
            if (useNewMap) {
                return (T)map;
            }
            if (!map.isEmpty()) {
                r.keySet().removeAll(map.keySet());
            }
            return o;
        }
        if (o instanceof ListScanResult) {
            this.tryHandleReference(((ListScanResult)o).getValues());
            return o;
        }
        if (o instanceof MapScanResult) {
            MapScanResult scanResult = (MapScanResult)o;
            Map oldMap = ((MapScanResult)o).getMap();
            Map map = this.tryHandleReference(oldMap);
            if (map != oldMap) {
                MapScanResult newScanResult = new MapScanResult(scanResult.getPos(), map);
                newScanResult.setRedisClient(scanResult.getRedisClient());
                return (T)newScanResult;
            }
            return o;
        }
        return this.tryHandleReference0(o);
    }

    private <T> T tryHandleReference0(T o) {
        if (o instanceof RedissonReference) {
            return (T)this.fromReference(o);
        }
        if (o instanceof ScoredEntry && ((ScoredEntry)o).getValue() instanceof RedissonReference) {
            ScoredEntry se = (ScoredEntry)o;
            return (T)new ScoredEntry(se.getScore(), this.fromReference(se.getValue()));
        }
        if (o instanceof ScanObjectEntry) {
            ScanObjectEntry keyScan = (ScanObjectEntry)o;
            Object obj = this.tryHandleReference0(keyScan.getObj());
            return (T)(obj != keyScan.getObj() ? new ScanObjectEntry(keyScan.getBuf(), obj) : o);
        }
        if (o instanceof Map.Entry) {
            Map.Entry old = (Map.Entry)o;
            Object key = this.tryHandleReference0(old.getKey());
            Object value = this.tryHandleReference0(old.getValue());
            return (T)(value != old.getValue() || key != old.getKey() ? new AbstractMap.SimpleEntry(key, value) : o);
        }
        return o;
    }

    private <R> R fromReference(Object res) {
        try {
            return (R)(this.redisson != null ? RedissonObjectFactory.fromReference(this.redisson, (RedissonReference)res) : RedissonObjectFactory.fromReference(this.redissonReactive, (RedissonReference)res));
        }
        catch (Exception exception) {
            return (R)res;
        }
    }
}

