/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import org.reactivestreams.Publisher;
import org.redisson.api.RDequeReactive;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.ListFirstObjectDecoder;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.reactive.RedissonQueueReactive;

public class RedissonDequeReactive<V>
extends RedissonQueueReactive<V>
implements RDequeReactive<V> {
    private static final RedisCommand<Object> LRANGE_SINGLE = new RedisCommand<Object>("LRANGE", new ListFirstObjectDecoder());

    public RedissonDequeReactive(CommandReactiveExecutor commandExecutor, String name) {
        super(commandExecutor, name);
    }

    public RedissonDequeReactive(Codec codec, CommandReactiveExecutor commandExecutor, String name) {
        super(codec, commandExecutor, name);
    }

    @Override
    public Publisher<Void> addFirst(V e) {
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.LPUSH_VOID, this.getName(), this.encode(e));
    }

    @Override
    public Publisher<Void> addLast(V e) {
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.RPUSH_VOID, this.getName(), this.encode(e));
    }

    @Override
    public Publisher<V> getLast() {
        return this.commandExecutor.readReactive(this.getName(), this.codec, LRANGE_SINGLE, this.getName(), -1, -1);
    }

    @Override
    public Publisher<Boolean> offerFirst(V e) {
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.LPUSH_BOOLEAN, this.getName(), this.encode(e));
    }

    @Override
    public Publisher<Integer> offerLast(V e) {
        return this.offer(e);
    }

    @Override
    public Publisher<V> peekFirst() {
        return this.get(0L);
    }

    @Override
    public Publisher<V> peekLast() {
        return this.getLast();
    }

    @Override
    public Publisher<V> pollFirst() {
        return this.poll();
    }

    @Override
    public Publisher<V> pollLast() {
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.RPOP, this.getName());
    }

    @Override
    public Publisher<V> pop() {
        return this.poll();
    }

    @Override
    public Publisher<Void> push(V e) {
        return this.addFirst(e);
    }

    @Override
    public Publisher<Boolean> removeFirstOccurrence(Object o) {
        return this.remove(o, 1);
    }

    @Override
    public Publisher<V> removeFirst() {
        return this.poll();
    }

    @Override
    public Publisher<V> removeLast() {
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.RPOP, this.getName());
    }

    @Override
    public Publisher<Boolean> removeLastOccurrence(Object o) {
        return this.remove(o, -1);
    }
}

