/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.remote;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;

public class RequestId {
    private final long id0;
    private final long id1;

    public RequestId(String id) {
        this(ByteBufUtil.decodeHexDump((CharSequence)id));
    }

    public RequestId(byte[] buf) {
        ByteBuf b = Unpooled.wrappedBuffer((byte[])buf);
        try {
            this.id0 = b.readLong();
            this.id1 = b.readLong();
        }
        finally {
            b.release();
        }
    }

    public String toString() {
        ByteBuf id = Unpooled.buffer((int)16);
        try {
            id.writeLong(this.id0);
            id.writeLong(this.id1);
            String string = ByteBufUtil.hexDump((ByteBuf)id);
            return string;
        }
        finally {
            id.release();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id0 ^ this.id0 >>> 32);
        result = 31 * result + (int)(this.id1 ^ this.id1 >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequestId other = (RequestId)obj;
        if (this.id0 != other.id0) {
            return false;
        }
        return this.id1 == other.id1;
    }
}

