/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.log;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.openqa.selenium.remote.SessionId;

public class SessionLogsToFileRepository {
    private static final Logger LOG = Logger.getLogger(SessionLogsToFileRepository.class.getName());
    private final Map<SessionId, LogFile> sessionToLogFileMap = new HashMap<SessionId, LogFile>();

    public void createLogFileAndAddToMap(SessionId sessionId) throws IOException {
        File rcLogFile = File.createTempFile(sessionId.toString(), ".rclog");
        rcLogFile.deleteOnExit();
        LogFile logFile = new LogFile(rcLogFile.getAbsolutePath());
        this.sessionToLogFileMap.put(sessionId, logFile);
    }

    public synchronized void flushRecordsToLogFile(SessionId sessionId, List<LogRecord> records) throws IOException {
        LogFile logFile = this.sessionToLogFileMap.get(sessionId);
        if (logFile == null) {
            this.createLogFileAndAddToMap(sessionId);
            logFile = this.sessionToLogFileMap.get(sessionId);
        }
        logFile.openLogWriter();
        for (LogRecord record : records) {
            logFile.getLogWriter().writeObject(record);
        }
        logFile.closeLogWriter();
    }

    public List<LogRecord> getLogRecords(SessionId sessionId) throws IOException {
        LogFile logFile = this.sessionToLogFileMap.get(sessionId);
        if (logFile == null) {
            return new ArrayList<LogRecord>();
        }
        ArrayList<LogRecord> logRecords = new ArrayList<LogRecord>();
        try {
            LogRecord tmpLogRecord;
            logFile.openLogReader();
            ObjectInputStream logObjInStream = logFile.getLogReader();
            while (null != (tmpLogRecord = (LogRecord)logObjInStream.readObject())) {
                logRecords.add(tmpLogRecord);
            }
        }
        catch (IOException | ClassNotFoundException ex) {
            logFile.closeLogReader();
            return logRecords;
        }
        logFile.closeLogReader();
        return logRecords;
    }

    public void removeLogFile(SessionId sessionId) {
        LogFile logFile = this.sessionToLogFileMap.get(sessionId);
        this.sessionToLogFileMap.remove(sessionId);
        if (logFile == null) {
            return;
        }
        try {
            logFile.removeLogFile();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static class LogFile {
        private final String logName;
        private ObjectOutputStream logWriter;
        private ObjectInputStream logReader;

        public LogFile(String logName) {
            this.logName = logName;
        }

        public void openLogWriter() throws IOException {
            this.logWriter = new ObjectOutputStream(new FileOutputStream(this.logName));
        }

        public void closeLogWriter() throws IOException {
            if (this.logWriter != null) {
                this.logWriter.close();
            }
        }

        public void openLogReader() throws IOException {
            this.logReader = new ObjectInputStream(new FileInputStream(this.logName));
        }

        public void closeLogReader() throws IOException {
            if (this.logReader != null) {
                this.logReader.close();
            }
        }

        public ObjectOutputStream getLogWriter() {
            return this.logWriter;
        }

        public ObjectInputStream getLogReader() {
            return this.logReader;
        }

        public void removeLogFile() throws IOException {
            if (this.logName != null) {
                this.closeLogReader();
                this.closeLogWriter();
                if (!new File(this.logName).delete()) {
                    LOG.warning("Unable to delete " + this.logName);
                }
            }
        }
    }
}

