/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.deser.std;

import java.io.IOException;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.JsonParser;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.JsonProcessingException;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.JsonToken;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.DeserializationContext;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.util.ClassUtil;

@JacksonStdImpl
public class ClassDeserializer
extends StdScalarDeserializer<Class<?>> {
    private static final long serialVersionUID = 1L;
    public static final ClassDeserializer instance = new ClassDeserializer();

    public ClassDeserializer() {
        super(Class.class);
    }

    @Override
    public Class<?> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            try {
                return deserializationContext.findClass(string);
            }
            catch (Exception exception) {
                throw deserializationContext.instantiationException(this._valueClass, ClassUtil.getRootCause(exception));
            }
        }
        throw deserializationContext.mappingException(this._valueClass, jsonToken);
    }
}

