/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.route;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.cloud.gateway.event.RefreshRoutesEvent;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import reactor.cache.CacheFlux;
import reactor.core.publisher.Flux;

public class CachingRouteLocator
implements Ordered,
RouteLocator,
ApplicationListener<RefreshRoutesEvent> {
    private static final String CACHE_KEY = "routes";
    private final RouteLocator delegate;
    private final Flux<Route> routes;
    private final Map<String, List> cache = new ConcurrentHashMap<String, List>();

    public CachingRouteLocator(RouteLocator delegate) {
        this.delegate = delegate;
        this.routes = CacheFlux.lookup(this.cache, (Object)CACHE_KEY, Route.class).onCacheMissResume(this::fetch);
    }

    private Flux<Route> fetch() {
        return this.delegate.getRoutes().sort((Comparator)AnnotationAwareOrderComparator.INSTANCE);
    }

    @Override
    public Flux<Route> getRoutes() {
        return this.routes;
    }

    public Flux<Route> refresh() {
        this.cache.clear();
        return this.routes;
    }

    public void onApplicationEvent(RefreshRoutesEvent event) {
        this.fetch().materialize().collect(Collectors.toList()).doOnNext(routes -> this.cache.put(CACHE_KEY, (List)routes)).subscribe();
    }

    @Deprecated
    void handleRefresh() {
        this.refresh();
    }

    public int getOrder() {
        return 0;
    }
}

