/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.springframework.cloud.sleuth.Log;
import org.springframework.cloud.sleuth.SpanContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class Span
implements SpanContext {
    public static final String SAMPLED_NAME = "X-B3-Sampled";
    public static final String PROCESS_ID_NAME = "X-Process-Id";
    public static final String PARENT_ID_NAME = "X-B3-ParentSpanId";
    public static final String TRACE_ID_NAME = "X-B3-TraceId";
    public static final String SPAN_NAME_NAME = "X-Span-Name";
    public static final String SPAN_ID_NAME = "X-B3-SpanId";
    public static final String SPAN_EXPORT_NAME = "X-Span-Export";
    public static final String SPAN_FLAGS = "X-B3-Flags";
    public static final String SPAN_BAGGAGE_HEADER_PREFIX = "baggage";
    public static final Set<String> SPAN_HEADERS = new HashSet<String>(Arrays.asList("X-B3-Sampled", "X-Process-Id", "X-B3-ParentSpanId", "X-B3-TraceId", "X-B3-SpanId", "X-Span-Name", "X-Span-Export"));
    public static final String SPAN_SAMPLED = "1";
    public static final String SPAN_NOT_SAMPLED = "0";
    public static final String SPAN_LOCAL_COMPONENT_TAG_NAME = "lc";
    public static final String SPAN_ERROR_TAG_NAME = "error";
    public static final String CLIENT_RECV = "cr";
    public static final String CLIENT_SEND = "cs";
    public static final String SERVER_RECV = "sr";
    public static final String SERVER_SEND = "ss";
    public static final String SPAN_PEER_SERVICE_TAG_NAME = "peer.service";
    public static final String INSTANCEID = "spring.instance_id";
    private final long begin;
    private long end = 0L;
    private final String name;
    private final long traceIdHigh;
    private final long traceId;
    private List<Long> parents = new ArrayList<Long>();
    private final long spanId;
    private boolean remote = false;
    private boolean exportable = true;
    private final Map<String, String> tags;
    private final String processId;
    private final Collection<Log> logs;
    private final Span savedSpan;
    @JsonIgnore
    private final Map<String, String> baggage;
    @JsonIgnore
    private final Long startNanos;
    private Long durationMicros;
    static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private Span() {
        this(-1L, -1L, "dummy", 0L, Collections.emptyList(), 0L, false, false, null);
    }

    public Span(Span current, Span savedSpan) {
        this.begin = current.getBegin();
        this.end = current.getEnd();
        this.name = current.getName();
        this.traceIdHigh = current.getTraceIdHigh();
        this.traceId = current.getTraceId();
        this.parents = current.getParents();
        this.spanId = current.getSpanId();
        this.remote = current.isRemote();
        this.exportable = current.isExportable();
        this.processId = current.getProcessId();
        this.tags = current.tags;
        this.logs = current.logs;
        this.startNanos = current.startNanos;
        this.durationMicros = current.durationMicros;
        this.baggage = current.baggage;
        this.savedSpan = savedSpan;
    }

    @Deprecated
    public Span(long begin, long end, String name, long traceId, List<Long> parents, long spanId, boolean remote, boolean exportable, String processId) {
        this(begin, end, name, traceId, parents, spanId, remote, exportable, processId, null);
    }

    @Deprecated
    public Span(long begin, long end, String name, long traceId, List<Long> parents, long spanId, boolean remote, boolean exportable, String processId, Span savedSpan) {
        this(new SpanBuilder().begin(begin).end(end).name(name).traceId(traceId).parents(parents).spanId(spanId).remote(remote).exportable(exportable).processId(processId).savedSpan(savedSpan));
    }

    Span(SpanBuilder builder) {
        if (builder.begin > 0L) {
            this.startNanos = null;
            this.begin = builder.begin;
        } else {
            this.startNanos = this.nanoTime();
            this.begin = System.currentTimeMillis();
        }
        if (builder.end > 0L) {
            this.end = builder.end;
            this.durationMicros = (this.end - this.begin) * 1000L;
        }
        this.name = builder.name != null ? builder.name : "";
        this.traceIdHigh = builder.traceIdHigh;
        this.traceId = builder.traceId;
        this.parents.addAll(builder.parents);
        this.spanId = builder.spanId;
        this.remote = builder.remote;
        this.exportable = builder.exportable;
        this.processId = builder.processId;
        this.savedSpan = builder.savedSpan;
        this.tags = new ConcurrentHashMap<String, String>();
        this.tags.putAll(builder.tags);
        this.logs = new ConcurrentLinkedQueue<Log>();
        this.logs.addAll(builder.logs);
        this.baggage = new ConcurrentHashMap<String, String>();
        this.baggage.putAll(builder.baggage);
    }

    public static SpanBuilder builder() {
        return new SpanBuilder();
    }

    public synchronized void stop() {
        if (this.durationMicros == null) {
            if (this.begin == 0L) {
                throw new IllegalStateException("Span for " + this.name + " has not been started");
            }
            if (this.end == 0L) {
                this.end = System.currentTimeMillis();
            }
            this.durationMicros = this.startNanos != null ? Long.valueOf(Math.max(1L, (this.nanoTime() - this.startNanos) / 1000L)) : Long.valueOf((this.end - this.begin) * 1000L);
        }
    }

    @Deprecated
    @JsonIgnore
    public synchronized long getAccumulatedMillis() {
        return this.getAccumulatedMicros() / 1000L;
    }

    @JsonIgnore
    public synchronized long getAccumulatedMicros() {
        if (this.durationMicros != null) {
            return this.durationMicros;
        }
        if (this.begin == 0L) {
            return 0L;
        }
        if (this.startNanos != null) {
            return Math.max(1L, (this.nanoTime() - this.startNanos) / 1000L);
        }
        return (System.currentTimeMillis() - this.begin) * 1000L;
    }

    @JsonIgnore
    long nanoTime() {
        return System.nanoTime();
    }

    @JsonIgnore
    public synchronized boolean isRunning() {
        return this.begin != 0L && this.durationMicros == null;
    }

    public void tag(String key, String value) {
        if (StringUtils.hasText((String)value)) {
            this.tags.put(key, value);
        }
    }

    public void logEvent(String event) {
        this.logEvent(System.currentTimeMillis(), event);
    }

    public void logEvent(long timestampMilliseconds, String event) {
        this.logs.add(new Log(timestampMilliseconds, event));
    }

    public Span setBaggageItem(String key, String value) {
        this.baggage.put(key, value);
        return this;
    }

    public String getBaggageItem(String key) {
        return this.baggage.get(key);
    }

    @Override
    public final Iterable<Map.Entry<String, String>> baggageItems() {
        return this.baggage.entrySet();
    }

    public final Map<String, String> getBaggage() {
        return Collections.unmodifiableMap(this.baggage);
    }

    public Map<String, String> tags() {
        return Collections.unmodifiableMap(new LinkedHashMap<String, String>(this.tags));
    }

    public List<Log> logs() {
        return Collections.unmodifiableList(new ArrayList<Log>(this.logs));
    }

    @JsonIgnore
    public Span getSavedSpan() {
        return this.savedSpan;
    }

    public boolean hasSavedSpan() {
        return this.savedSpan != null;
    }

    public String getName() {
        return this.name;
    }

    public long getSpanId() {
        return this.spanId;
    }

    public long getTraceIdHigh() {
        return this.traceIdHigh;
    }

    public long getTraceId() {
        return this.traceId;
    }

    public String getProcessId() {
        return this.processId;
    }

    public List<Long> getParents() {
        return this.parents;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public long getBegin() {
        return this.begin;
    }

    public long getEnd() {
        return this.end;
    }

    public boolean isExportable() {
        return this.exportable;
    }

    public String traceIdString() {
        if (this.traceIdHigh != 0L) {
            char[] result = new char[32];
            Span.writeHexLong(result, 0, this.traceIdHigh);
            Span.writeHexLong(result, 16, this.traceId);
            return new String(result);
        }
        char[] result = new char[16];
        Span.writeHexLong(result, 0, this.traceId);
        return new String(result);
    }

    public static String idToHex(long id) {
        char[] data = new char[16];
        Span.writeHexLong(data, 0, id);
        return new String(data);
    }

    static void writeHexLong(char[] data, int pos, long v) {
        Span.writeHexByte(data, pos + 0, (byte)(v >>> 56 & 0xFFL));
        Span.writeHexByte(data, pos + 2, (byte)(v >>> 48 & 0xFFL));
        Span.writeHexByte(data, pos + 4, (byte)(v >>> 40 & 0xFFL));
        Span.writeHexByte(data, pos + 6, (byte)(v >>> 32 & 0xFFL));
        Span.writeHexByte(data, pos + 8, (byte)(v >>> 24 & 0xFFL));
        Span.writeHexByte(data, pos + 10, (byte)(v >>> 16 & 0xFFL));
        Span.writeHexByte(data, pos + 12, (byte)(v >>> 8 & 0xFFL));
        Span.writeHexByte(data, pos + 14, (byte)(v & 0xFFL));
    }

    static void writeHexByte(char[] data, int pos, byte b) {
        data[pos + 0] = HEX_DIGITS[b >> 4 & 0xF];
        data[pos + 1] = HEX_DIGITS[b & 0xF];
    }

    public static long hexToId(String hexString) {
        Assert.hasText((String)hexString, (String)"Can't convert empty hex string to long");
        int length = hexString.length();
        if (length < 1 || length > 32) {
            throw new IllegalArgumentException("Malformed id: " + hexString);
        }
        int beginIndex = length > 16 ? length - 16 : 0;
        return Span.hexToId(hexString, beginIndex);
    }

    public static long hexToId(String lowerHex, int index) {
        Assert.hasText((String)lowerHex, (String)"Can't convert empty hex string to long");
        long result = 0L;
        int endIndex = Math.min(index + 16, lowerHex.length());
        while (index < endIndex) {
            char c = lowerHex.charAt(index);
            result <<= 4;
            if (c >= '0' && c <= '9') {
                result |= (long)(c - 48);
            } else if (c >= 'a' && c <= 'f') {
                result |= (long)(c - 97 + 10);
            } else {
                throw new IllegalArgumentException("Malformed id: " + lowerHex);
            }
            ++index;
        }
        return result;
    }

    public String toString() {
        return "[Trace: " + this.traceIdString() + ", Span: " + Span.idToHex(this.spanId) + ", Parent: " + this.getParentIdIfPresent() + ", exportable:" + this.exportable + "]";
    }

    private String getParentIdIfPresent() {
        return this.getParents().isEmpty() ? "null" : Span.idToHex(this.getParents().get(0));
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h = (int)((long)h ^ (this.traceIdHigh >>> 32 ^ this.traceIdHigh));
        h *= 1000003;
        h = (int)((long)h ^ (this.traceId >>> 32 ^ this.traceId));
        h *= 1000003;
        h = (int)((long)h ^ (this.spanId >>> 32 ^ this.spanId));
        return h *= 1000003;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Span) {
            Span that = (Span)o;
            return this.traceIdHigh == that.traceIdHigh && this.traceId == that.traceId && this.spanId == that.spanId;
        }
        return false;
    }

    public static class SpanBuilder {
        private long begin;
        private long end;
        private String name;
        private long traceIdHigh;
        private long traceId;
        private ArrayList<Long> parents = new ArrayList();
        private long spanId;
        private boolean remote;
        private boolean exportable = true;
        private String processId;
        private Span savedSpan;
        private List<Log> logs = new ArrayList<Log>();
        private Map<String, String> tags = new LinkedHashMap<String, String>();
        private Map<String, String> baggage = new LinkedHashMap<String, String>();

        SpanBuilder() {
        }

        public SpanBuilder begin(long begin) {
            this.begin = begin;
            return this;
        }

        public SpanBuilder end(long end) {
            this.end = end;
            return this;
        }

        public SpanBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SpanBuilder traceIdHigh(long traceIdHigh) {
            this.traceIdHigh = traceIdHigh;
            return this;
        }

        public SpanBuilder traceId(long traceId) {
            this.traceId = traceId;
            return this;
        }

        public SpanBuilder parent(Long parent) {
            this.parents.add(parent);
            return this;
        }

        public SpanBuilder parents(Collection<Long> parents) {
            this.parents.addAll(parents);
            return this;
        }

        public SpanBuilder log(Log log) {
            this.logs.add(log);
            return this;
        }

        public SpanBuilder logs(Collection<Log> logs) {
            this.logs.addAll(logs);
            return this;
        }

        public SpanBuilder tag(String tagKey, String tagValue) {
            this.tags.put(tagKey, tagValue);
            return this;
        }

        public SpanBuilder tags(Map<String, String> tags) {
            this.tags.putAll(tags);
            return this;
        }

        public SpanBuilder baggage(String baggageKey, String baggageValue) {
            this.baggage.put(baggageKey, baggageValue);
            return this;
        }

        public SpanBuilder baggage(Map<String, String> baggage) {
            this.baggage.putAll(baggage);
            return this;
        }

        public SpanBuilder spanId(long spanId) {
            this.spanId = spanId;
            return this;
        }

        public SpanBuilder remote(boolean remote) {
            this.remote = remote;
            return this;
        }

        public SpanBuilder exportable(boolean exportable) {
            this.exportable = exportable;
            return this;
        }

        public SpanBuilder processId(String processId) {
            this.processId = processId;
            return this;
        }

        public SpanBuilder savedSpan(Span savedSpan) {
            this.savedSpan = savedSpan;
            return this;
        }

        public Span build() {
            return new Span(this);
        }

        public String toString() {
            return new Span(this).toString();
        }
    }
}

