/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.annotation;

import java.lang.invoke.MethodHandles;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.annotation.NewSpan;
import org.springframework.cloud.sleuth.annotation.SpanCreator;
import org.springframework.cloud.sleuth.util.SpanNameUtil;
import org.springframework.util.StringUtils;

class DefaultSpanCreator
implements SpanCreator {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final Tracer tracer;

    DefaultSpanCreator(Tracer tracer) {
        this.tracer = tracer;
    }

    @Override
    public Span createSpan(MethodInvocation pjp, NewSpan newSpanAnnotation) {
        String name = StringUtils.isEmpty((Object)newSpanAnnotation.name()) ? pjp.getMethod().getName() : newSpanAnnotation.name();
        String changedName = SpanNameUtil.toLowerHyphen(name);
        if (log.isDebugEnabled()) {
            log.debug((Object)("For the class [" + pjp.getThis().getClass() + "] method " + "[" + pjp.getMethod().getName() + "] will name the span [" + changedName + "]"));
        }
        return this.createSpan(changedName);
    }

    private Span createSpan(String name) {
        if (this.tracer.isTracing()) {
            return this.tracer.createSpan(name, this.tracer.getCurrentSpan());
        }
        return this.tracer.createSpan(name);
    }
}

