/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.annotation;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.IntroductionInterceptor;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.annotation.ContinueSpan;
import org.springframework.cloud.sleuth.annotation.NewSpan;
import org.springframework.cloud.sleuth.annotation.SleuthAnnotationUtils;
import org.springframework.cloud.sleuth.annotation.SpanCreator;
import org.springframework.cloud.sleuth.annotation.SpanTagAnnotationHandler;
import org.springframework.cloud.sleuth.util.ExceptionUtils;
import org.springframework.util.StringUtils;

class SleuthInterceptor
implements IntroductionInterceptor,
BeanFactoryAware {
    private static final Log logger = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private BeanFactory beanFactory;
    private SpanCreator spanCreator;
    private Tracer tracer;
    private SpanTagAnnotationHandler spanTagAnnotationHandler;

    SleuthInterceptor() {
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        if (method == null) {
            return invocation.proceed();
        }
        Method mostSpecificMethod = AopUtils.getMostSpecificMethod((Method)method, invocation.getThis().getClass());
        NewSpan newSpan = SleuthAnnotationUtils.findAnnotation(mostSpecificMethod, NewSpan.class);
        ContinueSpan continueSpan = SleuthAnnotationUtils.findAnnotation(mostSpecificMethod, ContinueSpan.class);
        if (newSpan == null && continueSpan == null) {
            return invocation.proceed();
        }
        Span span = this.tracer().getCurrentSpan();
        String log = this.log(continueSpan);
        boolean hasLog = StringUtils.hasText((String)log);
        try {
            if (newSpan != null) {
                span = this.spanCreator().createSpan(invocation, newSpan);
            }
            if (hasLog) {
                this.logEvent(span, log + ".before");
            }
            this.spanTagAnnotationHandler().addAnnotatedParameters(invocation);
            Object object = invocation.proceed();
            return object;
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Exception occurred while trying to continue the pointcut", (Throwable)e);
            }
            if (hasLog) {
                this.logEvent(span, log + ".afterFailure");
            }
            this.tracer().addTag("error", ExceptionUtils.getExceptionMessage(e));
            throw e;
        }
        finally {
            if (span != null) {
                if (hasLog) {
                    this.logEvent(span, log + ".after");
                }
                if (newSpan != null) {
                    this.tracer().close(span);
                }
            }
        }
    }

    private void logEvent(Span span, String name) {
        if (span == null) {
            logger.warn((Object)"You were trying to continue a span which was null. Please remember that if two proxied methods are calling each other from the same class then the aspect will not be properly resolved");
            return;
        }
        span.logEvent(name);
    }

    private String log(ContinueSpan continueSpan) {
        if (continueSpan != null) {
            return continueSpan.log();
        }
        return "";
    }

    private Tracer tracer() {
        if (this.tracer == null) {
            this.tracer = (Tracer)this.beanFactory.getBean(Tracer.class);
        }
        return this.tracer;
    }

    private SpanCreator spanCreator() {
        if (this.spanCreator == null) {
            this.spanCreator = (SpanCreator)this.beanFactory.getBean(SpanCreator.class);
        }
        return this.spanCreator;
    }

    private SpanTagAnnotationHandler spanTagAnnotationHandler() {
        if (this.spanTagAnnotationHandler == null) {
            this.spanTagAnnotationHandler = new SpanTagAnnotationHandler(this.beanFactory);
        }
        return this.spanTagAnnotationHandler;
    }

    public boolean implementsInterface(Class<?> intf) {
        return true;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

