/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.cloud.sleuth.DefaultSpanNamer;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.async.SpanContinuingTraceCallable;
import org.springframework.cloud.sleuth.instrument.async.SpanContinuingTraceRunnable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.concurrent.ListenableFuture;

public class LazyTraceThreadPoolTaskExecutor
extends ThreadPoolTaskExecutor {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private Tracer tracer;
    private final BeanFactory beanFactory;
    private final ThreadPoolTaskExecutor delegate;
    private TraceKeys traceKeys;
    private SpanNamer spanNamer;

    public LazyTraceThreadPoolTaskExecutor(BeanFactory beanFactory, ThreadPoolTaskExecutor delegate) {
        this.beanFactory = beanFactory;
        this.delegate = delegate;
    }

    public void execute(Runnable task) {
        this.delegate.execute((Runnable)new SpanContinuingTraceRunnable(this.tracer(), this.traceKeys(), this.spanNamer(), task));
    }

    public void execute(Runnable task, long startTimeout) {
        this.delegate.execute((Runnable)new SpanContinuingTraceRunnable(this.tracer(), this.traceKeys(), this.spanNamer(), task), startTimeout);
    }

    public Future<?> submit(Runnable task) {
        return this.delegate.submit((Runnable)new SpanContinuingTraceRunnable(this.tracer(), this.traceKeys(), this.spanNamer(), task));
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.delegate.submit(new SpanContinuingTraceCallable<T>(this.tracer(), this.traceKeys(), this.spanNamer(), task));
    }

    public ListenableFuture<?> submitListenable(Runnable task) {
        return this.delegate.submitListenable((Runnable)new SpanContinuingTraceRunnable(this.tracer(), this.traceKeys(), this.spanNamer(), task));
    }

    public <T> ListenableFuture<T> submitListenable(Callable<T> task) {
        return this.delegate.submitListenable(new SpanContinuingTraceCallable<T>(this.tracer(), this.traceKeys(), this.spanNamer(), task));
    }

    public ThreadPoolExecutor getThreadPoolExecutor() throws IllegalStateException {
        return this.delegate.getThreadPoolExecutor();
    }

    public void destroy() {
        this.delegate.destroy();
        super.destroy();
    }

    public void afterPropertiesSet() {
        this.delegate.afterPropertiesSet();
        super.afterPropertiesSet();
    }

    private Tracer tracer() {
        if (this.tracer == null) {
            this.tracer = (Tracer)this.beanFactory.getBean(Tracer.class);
        }
        return this.tracer;
    }

    private TraceKeys traceKeys() {
        if (this.traceKeys == null) {
            try {
                this.traceKeys = (TraceKeys)this.beanFactory.getBean(TraceKeys.class);
            }
            catch (NoSuchBeanDefinitionException e) {
                log.warn((Object)"TraceKeys bean not found - will provide a manually created instance");
                return new TraceKeys();
            }
        }
        return this.traceKeys;
    }

    private SpanNamer spanNamer() {
        if (this.spanNamer == null) {
            try {
                this.spanNamer = (SpanNamer)this.beanFactory.getBean(SpanNamer.class);
            }
            catch (NoSuchBeanDefinitionException e) {
                log.warn((Object)"SpanNamer bean not found - will provide a manually created instance");
                return new DefaultSpanNamer();
            }
        }
        return this.spanNamer;
    }
}

