/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import java.lang.reflect.Method;
import java.util.concurrent.Executor;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.async.LazyTraceExecutor;
import org.springframework.cloud.sleuth.instrument.async.LazyTraceThreadPoolTaskExecutor;
import org.springframework.cloud.sleuth.util.SpanNameUtil;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.ReflectionUtils;

@Aspect
public class TraceAsyncAspect {
    private static final String ASYNC_COMPONENT = "async";
    private final Tracer tracer;
    private final TraceKeys traceKeys;
    private final BeanFactory beanFactory;

    public TraceAsyncAspect(Tracer tracer, TraceKeys traceKeys, BeanFactory beanFactory) {
        this.tracer = tracer;
        this.traceKeys = traceKeys;
        this.beanFactory = beanFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execution (@org.springframework.scheduling.annotation.Async  * *.*(..))")
    public Object traceBackgroundThread(ProceedingJoinPoint pjp) throws Throwable {
        Span span = this.tracer.createSpan(SpanNameUtil.toLowerHyphen(pjp.getSignature().getName()));
        this.tracer.addTag("lc", ASYNC_COMPONENT);
        this.tracer.addTag(this.traceKeys.getAsync().getPrefix() + this.traceKeys.getAsync().getClassNameKey(), pjp.getTarget().getClass().getSimpleName());
        this.tracer.addTag(this.traceKeys.getAsync().getPrefix() + this.traceKeys.getAsync().getMethodNameKey(), pjp.getSignature().getName());
        try {
            Object object = pjp.proceed();
            return object;
        }
        finally {
            this.tracer.close(span);
        }
    }

    @Around(value="execution (* org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor.*(..))")
    public Object traceThreadPoolTaskExecutor(ProceedingJoinPoint pjp) throws Throwable {
        LazyTraceThreadPoolTaskExecutor executor = new LazyTraceThreadPoolTaskExecutor(this.beanFactory, (ThreadPoolTaskExecutor)pjp.getTarget());
        Method methodOnTracedBean = this.getMethod(pjp, (Object)executor);
        if (methodOnTracedBean != null) {
            return methodOnTracedBean.invoke((Object)executor, pjp.getArgs());
        }
        return pjp.proceed();
    }

    @Around(value="execution (* java.util.concurrent.Executor.*(..))")
    public Object traceExecutor(ProceedingJoinPoint pjp) throws Throwable {
        LazyTraceExecutor executor = new LazyTraceExecutor(this.beanFactory, (Executor)pjp.getTarget());
        Method methodOnTracedBean = this.getMethod(pjp, executor);
        if (methodOnTracedBean != null) {
            return methodOnTracedBean.invoke((Object)executor, pjp.getArgs());
        }
        return pjp.proceed();
    }

    private Method getMethod(ProceedingJoinPoint pjp, Object object) {
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        Method method = signature.getMethod();
        return ReflectionUtils.findMethod(object.getClass(), (String)method.getName(), (Class[])method.getParameterTypes());
    }
}

