/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import java.util.Map;
import java.util.Random;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanTextMap;
import org.springframework.cloud.sleuth.instrument.messaging.MessagingSpanTextMapExtractor;
import org.springframework.cloud.sleuth.util.TextMapUtil;

public class HeaderBasedMessagingExtractor
implements MessagingSpanTextMapExtractor {
    @Override
    public Span joinTrace(SpanTextMap textMap) {
        Map<String, String> carrier = TextMapUtil.asMap(textMap);
        if ("1".equals(carrier.get("spanFlags"))) {
            String traceId = this.generateTraceIdIfMissing(carrier);
            if (!carrier.containsKey("spanId")) {
                carrier.put("spanId", traceId);
            }
        } else if (!this.hasHeader(carrier, "spanId") || !this.hasHeader(carrier, "spanTraceId")) {
            return null;
        }
        return this.extractSpanFromHeaders(carrier, Span.builder());
    }

    private String generateTraceIdIfMissing(Map<String, String> carrier) {
        if (!this.hasHeader(carrier, "spanTraceId")) {
            carrier.put("spanTraceId", Span.idToHex(new Random().nextLong()));
        }
        return carrier.get("spanTraceId");
    }

    private Span extractSpanFromHeaders(Map<String, String> carrier, Span.SpanBuilder spanBuilder) {
        String traceId = carrier.get("spanTraceId");
        spanBuilder = spanBuilder.traceIdHigh(traceId.length() == 32 ? Span.hexToId(traceId, 0) : 0L).traceId(Span.hexToId(traceId)).spanId(Span.hexToId(carrier.get("spanId")));
        String flags = carrier.get("spanFlags");
        if ("1".equals(flags)) {
            spanBuilder.exportable(true);
        } else {
            spanBuilder.exportable("1".equals(carrier.get("spanSampled")));
        }
        String processId = carrier.get("spanProcessId");
        String spanName = carrier.get("spanName");
        if (spanName != null) {
            spanBuilder.name(spanName);
        }
        if (processId != null) {
            spanBuilder.processId(processId);
        }
        this.setParentIdIfApplicable(carrier, spanBuilder, "spanParentSpanId");
        spanBuilder.remote(true);
        for (Map.Entry<String, String> entry : carrier.entrySet()) {
            if (!entry.getKey().startsWith("baggage_")) continue;
            spanBuilder.baggage(this.unprefixedKey(entry.getKey()), entry.getValue());
        }
        return spanBuilder.build();
    }

    boolean hasHeader(Map<String, String> message, String name) {
        return message.containsKey(name);
    }

    private void setParentIdIfApplicable(Map<String, String> carrier, Span.SpanBuilder spanBuilder, String spanParentIdHeader) {
        String parentId = carrier.get(spanParentIdHeader);
        if (parentId != null) {
            spanBuilder.parent(Span.hexToId(parentId));
        }
    }

    private String unprefixedKey(String key) {
        return key.substring(key.indexOf("_") + 1);
    }
}

