/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import java.util.Map;
import org.springframework.cloud.sleuth.Log;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.messaging.AbstractTraceChannelInterceptor;
import org.springframework.cloud.sleuth.instrument.messaging.MessagingSpanTextMapExtractor;
import org.springframework.cloud.sleuth.instrument.messaging.MessagingSpanTextMapInjector;
import org.springframework.cloud.sleuth.instrument.messaging.MessagingTextMap;
import org.springframework.cloud.sleuth.sampler.NeverSampler;
import org.springframework.cloud.sleuth.util.ExceptionUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.messaging.support.MessageHeaderAccessor;

public class TraceChannelInterceptor
extends AbstractTraceChannelInterceptor {
    public TraceChannelInterceptor(Tracer tracer, TraceKeys traceKeys, MessagingSpanTextMapExtractor spanExtractor, MessagingSpanTextMapInjector spanInjector) {
        super(tracer, traceKeys, spanExtractor, spanInjector);
    }

    public void afterSendCompletion(Message<?> message, MessageChannel channel, boolean sent, Exception ex) {
        Span currentSpan = this.getTracer().getCurrentSpan();
        if (this.containsServerReceived(currentSpan)) {
            currentSpan.logEvent("ss");
        } else if (currentSpan != null) {
            currentSpan.logEvent("cr");
        }
        this.addErrorTag(ex);
        this.getTracer().close(currentSpan);
    }

    private boolean containsServerReceived(Span span) {
        if (span == null) {
            return false;
        }
        for (Log log : span.logs()) {
            if (!"sr".equals(log.getEvent())) continue;
            return true;
        }
        return false;
    }

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        MessageBuilder messageBuilder = MessageBuilder.fromMessage(message);
        Span parentSpan = this.getTracer().isTracing() ? this.getTracer().getCurrentSpan() : this.buildSpan(new MessagingTextMap(messageBuilder));
        String name = this.getMessageChannelName(channel);
        Span span = this.startSpan(parentSpan, name, message);
        if (message.getHeaders().containsKey((Object)"messageSent")) {
            span.logEvent("sr");
        } else {
            span.logEvent("cs");
            messageBuilder.setHeader("messageSent", (Object)true);
        }
        this.getSpanInjector().inject(span, new MessagingTextMap(messageBuilder));
        MessageHeaderAccessor headers = MessageHeaderAccessor.getMutableAccessor(message);
        headers.copyHeaders((Map)messageBuilder.build().getHeaders());
        return new GenericMessage(message.getPayload(), headers.getMessageHeaders());
    }

    private Span startSpan(Span span, String name, Message<?> message) {
        if (span != null) {
            return this.getTracer().createSpan(name, span);
        }
        if ("0".equals(message.getHeaders().get((Object)"spanSampled"))) {
            return this.getTracer().createSpan(name, NeverSampler.INSTANCE);
        }
        return this.getTracer().createSpan(name);
    }

    public Message<?> beforeHandle(Message<?> message, MessageChannel channel, MessageHandler handler) {
        Span spanFromHeader = this.getTracer().getCurrentSpan();
        if (spanFromHeader != null) {
            spanFromHeader.logEvent("sr");
        }
        this.getTracer().continueSpan(spanFromHeader);
        return message;
    }

    public void afterMessageHandled(Message<?> message, MessageChannel channel, MessageHandler handler, Exception ex) {
        Span spanFromHeader = this.getTracer().getCurrentSpan();
        if (spanFromHeader != null) {
            spanFromHeader.logEvent("ss");
            this.addErrorTag(ex);
        }
        if (this.getTracer().isTracing()) {
            this.getTracer().detach(spanFromHeader);
        }
    }

    private void addErrorTag(Exception ex) {
        if (ex != null) {
            this.getTracer().addTag("error", ExceptionUtils.getExceptionMessage(ex));
        }
    }
}

