/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.autoconfigure.web.ErrorController;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.web.TraceFilter;
import org.springframework.cloud.sleuth.instrument.web.TraceRequestAttributes;
import org.springframework.cloud.sleuth.util.ExceptionUtils;
import org.springframework.cloud.sleuth.util.SpanNameUtil;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class TraceHandlerInterceptor
extends HandlerInterceptorAdapter {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final BeanFactory beanFactory;
    private Tracer tracer;
    private TraceKeys traceKeys;
    private AtomicReference<ErrorController> errorController;

    public TraceHandlerInterceptor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        Span span;
        String spanName = this.spanName(handler);
        boolean continueSpan = this.getRootSpanFromAttribute(request) != null;
        Span span2 = span = continueSpan ? this.getRootSpanFromAttribute(request) : this.getTracer().createSpan(spanName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Handling span " + span));
        }
        this.addClassMethodTag(handler, span);
        this.addClassNameTag(handler, span);
        this.setSpanInAttribute(request, span);
        if (!continueSpan) {
            this.setNewSpanCreatedAttribute(request, span);
        }
        return true;
    }

    private boolean isErrorControllerRelated(HttpServletRequest request) {
        return this.getErrorController() != null && this.getErrorController().getErrorPath().equals(request.getRequestURI());
    }

    private void addClassMethodTag(Object handler, Span span) {
        if (handler instanceof HandlerMethod) {
            String methodName = ((HandlerMethod)handler).getMethod().getName();
            this.getTracer().addTag(this.getTraceKeys().getMvc().getControllerMethod(), methodName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding a method tag with value [" + methodName + "] to a span " + span));
            }
        }
    }

    private void addClassNameTag(Object handler, Span span) {
        String className = handler instanceof HandlerMethod ? ((HandlerMethod)handler).getBeanType().getSimpleName() : handler.getClass().getSimpleName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding a class tag with value [" + className + "] to a span " + span));
        }
        this.getTracer().addTag(this.getTraceKeys().getMvc().getControllerClass(), className);
    }

    private String spanName(Object handler) {
        if (handler instanceof HandlerMethod) {
            return SpanNameUtil.toLowerHyphen(((HandlerMethod)handler).getMethod().getName());
        }
        return SpanNameUtil.toLowerHyphen(handler.getClass().getSimpleName());
    }

    public void afterConcurrentHandlingStarted(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        Span spanFromRequest = this.getNewSpanFromAttribute(request);
        Span rootSpanFromRequest = this.getRootSpanFromAttribute(request);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Closing the span " + spanFromRequest + " and detaching its parent " + rootSpanFromRequest + " since the request is asynchronous"));
        }
        this.getTracer().close(spanFromRequest);
        this.getTracer().detach(rootSpanFromRequest);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        if (this.isErrorControllerRelated(request)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Skipping closing of a span for error controller processing");
            }
            return;
        }
        Span span = this.getRootSpanFromAttribute(request);
        if (ex != null) {
            String errorMsg = ExceptionUtils.getExceptionMessage(ex);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding an error tag [" + errorMsg + "] to span " + span + ""));
            }
            this.getTracer().addTag("error", errorMsg);
        }
        if (this.getNewSpanFromAttribute(request) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Closing span " + span));
            }
            Span newSpan = this.getNewSpanFromAttribute(request);
            this.getTracer().continueSpan(newSpan);
            this.getTracer().close(newSpan);
            this.clearNewSpanCreatedAttribute(request);
        }
    }

    private Span getNewSpanFromAttribute(HttpServletRequest request) {
        return (Span)request.getAttribute(TraceRequestAttributes.NEW_SPAN_REQUEST_ATTR);
    }

    private Span getRootSpanFromAttribute(HttpServletRequest request) {
        return (Span)request.getAttribute(TraceFilter.TRACE_REQUEST_ATTR);
    }

    private void setSpanInAttribute(HttpServletRequest request, Span span) {
        request.setAttribute(TraceRequestAttributes.HANDLED_SPAN_REQUEST_ATTR, (Object)span);
    }

    private void setNewSpanCreatedAttribute(HttpServletRequest request, Span span) {
        request.setAttribute(TraceRequestAttributes.NEW_SPAN_REQUEST_ATTR, (Object)span);
    }

    private void clearNewSpanCreatedAttribute(HttpServletRequest request) {
        request.removeAttribute(TraceRequestAttributes.NEW_SPAN_REQUEST_ATTR);
    }

    private Tracer getTracer() {
        if (this.tracer == null) {
            this.tracer = (Tracer)this.beanFactory.getBean(Tracer.class);
        }
        return this.tracer;
    }

    private TraceKeys getTraceKeys() {
        if (this.traceKeys == null) {
            this.traceKeys = (TraceKeys)this.beanFactory.getBean(TraceKeys.class);
        }
        return this.traceKeys;
    }

    ErrorController getErrorController() {
        if (this.errorController == null) {
            try {
                ErrorController errorController = (ErrorController)this.beanFactory.getBean(ErrorController.class);
                this.errorController = new AtomicReference<ErrorController>(errorController);
            }
            catch (NoSuchBeanDefinitionException e) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"ErrorController bean not found");
                }
                this.errorController = new AtomicReference();
            }
        }
        return this.errorController.get();
    }
}

