/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.MethodHandles;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.instrument.web.SsLogSetter;
import org.springframework.cloud.sleuth.instrument.web.TracePrintWriter;
import org.springframework.cloud.sleuth.instrument.web.TraceServletOutputStream;

class TraceHttpServletResponse
extends HttpServletResponseWrapper {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final Span span;

    TraceHttpServletResponse(HttpServletResponse response, Span span) {
        super(response);
        this.span = span;
    }

    public void flushBuffer() throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Will annotate SS once the response is flushed");
        }
        SsLogSetter.annotateWithServerSendIfLogIsNotAlreadyPresent(this.span);
        super.flushBuffer();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return new TraceServletOutputStream(super.getOutputStream(), this.span);
    }

    public PrintWriter getWriter() throws IOException {
        return new TracePrintWriter(super.getWriter(), this.span);
    }
}

