/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import java.util.regex.Pattern;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.actuate.autoconfigure.ManagementServerProperties;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.SpanReporter;
import org.springframework.cloud.sleuth.TraceKeys;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.web.HttpSpanExtractor;
import org.springframework.cloud.sleuth.instrument.web.HttpTraceKeysInjector;
import org.springframework.cloud.sleuth.instrument.web.SleuthWebProperties;
import org.springframework.cloud.sleuth.instrument.web.TraceFilter;
import org.springframework.cloud.sleuth.instrument.web.TraceHttpAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.web.TraceSpringDataBeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.web.TraceWebAspect;
import org.springframework.cloud.sleuth.instrument.web.TraceWebMvcConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@ConditionalOnProperty(value={"spring.sleuth.web.enabled"}, matchIfMissing=true)
@ConditionalOnWebApplication
@ConditionalOnBean(value={Tracer.class})
@AutoConfigureAfter(value={TraceHttpAutoConfiguration.class})
public class TraceWebAutoConfiguration {
    @Bean
    public TraceWebAspect traceWebAspect(Tracer tracer, TraceKeys traceKeys, SpanNamer spanNamer) {
        return new TraceWebAspect(tracer, spanNamer, traceKeys);
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.data.rest.webmvc.support.DelegatingHandlerMapping"})
    public TraceSpringDataBeanPostProcessor traceSpringDataBeanPostProcessor(BeanFactory beanFactory) {
        return new TraceSpringDataBeanPostProcessor(beanFactory);
    }

    @Bean
    public FilterRegistrationBean traceWebFilter(TraceFilter traceFilter) {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)traceFilter, new ServletRegistrationBean[0]);
        filterRegistrationBean.setDispatcherTypes(DispatcherType.ASYNC, new DispatcherType[]{DispatcherType.ERROR, DispatcherType.FORWARD, DispatcherType.INCLUDE, DispatcherType.REQUEST});
        filterRegistrationBean.setOrder(-2147483643);
        return filterRegistrationBean;
    }

    @Bean
    public TraceFilter traceFilter(Tracer tracer, TraceKeys traceKeys, SkipPatternProvider skipPatternProvider, SpanReporter spanReporter, HttpSpanExtractor spanExtractor, HttpTraceKeysInjector httpTraceKeysInjector) {
        return new TraceFilter(tracer, traceKeys, skipPatternProvider.skipPattern(), spanReporter, spanExtractor, httpTraceKeysInjector);
    }

    @Bean
    @ConditionalOnMissingClass(value={"org.springframework.boot.actuate.autoconfigure.ManagementServerProperties"})
    @ConditionalOnMissingBean(value={SkipPatternProvider.class})
    public SkipPatternProvider defaultSkipPatternBean(SleuthWebProperties sleuthWebProperties) {
        return TraceWebAutoConfiguration.defaultSkipPatternProvider(sleuthWebProperties.getSkipPattern());
    }

    private static SkipPatternProvider defaultSkipPatternProvider(final String skipPattern) {
        return new SkipPatternProvider(){

            @Override
            public Pattern skipPattern() {
                return TraceWebAutoConfiguration.defaultSkipPattern(skipPattern);
            }
        };
    }

    private static Pattern defaultSkipPattern(String skipPattern) {
        return StringUtils.hasText((String)skipPattern) ? Pattern.compile(skipPattern) : Pattern.compile("/api-docs.*|/autoconfig|/configprops|/dump|/health|/info|/metrics.*|/mappings|/trace|/swagger.*|.*\\.png|.*\\.css|.*\\.js|.*\\.html|/favicon.ico|/hystrix.stream");
    }

    static interface SkipPatternProvider {
        public Pattern skipPattern();
    }

    @Configuration
    @ConditionalOnClass(value={ManagementServerProperties.class})
    @ConditionalOnMissingBean(value={SkipPatternProvider.class})
    @EnableConfigurationProperties(value={SleuthWebProperties.class})
    protected static class SkipPatternProviderConfig {
        protected SkipPatternProviderConfig() {
        }

        @Bean
        @ConditionalOnBean(value={ManagementServerProperties.class})
        public SkipPatternProvider skipPatternForManagementServerProperties(final ManagementServerProperties managementServerProperties, final SleuthWebProperties sleuthWebProperties) {
            return new SkipPatternProvider(){

                @Override
                public Pattern skipPattern() {
                    return SkipPatternProviderConfig.getPatternForManagementServerProperties(managementServerProperties, sleuthWebProperties);
                }
            };
        }

        static Pattern getPatternForManagementServerProperties(ManagementServerProperties managementServerProperties, SleuthWebProperties sleuthWebProperties) {
            String skipPattern = sleuthWebProperties.getSkipPattern();
            if (StringUtils.hasText((String)skipPattern) && StringUtils.hasText((String)managementServerProperties.getContextPath())) {
                return Pattern.compile(skipPattern + "|" + managementServerProperties.getContextPath() + ".*");
            }
            if (StringUtils.hasText((String)managementServerProperties.getContextPath())) {
                return Pattern.compile(managementServerProperties.getContextPath() + ".*");
            }
            return TraceWebAutoConfiguration.defaultSkipPattern(skipPattern);
        }

        @Bean
        @ConditionalOnMissingBean(value={ManagementServerProperties.class})
        public SkipPatternProvider defaultSkipPatternBeanIfManagementServerPropsArePresent(SleuthWebProperties sleuthWebProperties) {
            return TraceWebAutoConfiguration.defaultSkipPatternProvider(sleuthWebProperties.getSkipPattern());
        }
    }

    @Configuration
    @ConditionalOnClass(value={WebMvcConfigurerAdapter.class})
    @Import(value={TraceWebMvcConfigurer.class})
    protected static class TraceWebMvcAutoConfiguration {
        protected TraceWebMvcAutoConfiguration() {
        }
    }
}

