/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanTextMap;
import org.springframework.cloud.sleuth.instrument.web.HttpSpanExtractor;
import org.springframework.cloud.sleuth.util.TextMapUtil;
import org.springframework.util.StringUtils;

public class ZipkinHttpSpanExtractor
implements HttpSpanExtractor {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final String HEADER_DELIMITER = "-";
    static final String URI_HEADER = "X-Span-Uri";
    private static final String HTTP_COMPONENT = "http";
    private final Pattern skipPattern;

    public ZipkinHttpSpanExtractor(Pattern skipPattern) {
        this.skipPattern = skipPattern;
    }

    @Override
    public Span joinTrace(SpanTextMap textMap) {
        Map<String, String> carrier = TextMapUtil.asMap(textMap);
        boolean debug = "1".equals(carrier.get("X-B3-Flags"));
        if (debug) {
            this.generateIdIfMissing(carrier, "X-B3-TraceId");
        } else if (carrier.get("X-B3-TraceId") == null) {
            return null;
        }
        try {
            String uri = carrier.get(URI_HEADER);
            boolean skip = this.skipPattern.matcher(uri).matches() || "0".equals(carrier.get("X-B3-Sampled"));
            long spanId = this.spanId(carrier);
            return this.buildParentSpan(carrier, uri, skip, spanId);
        }
        catch (Exception e) {
            log.error((Object)"Exception occurred while trying to extract span from carrier", (Throwable)e);
            return null;
        }
    }

    private void generateIdIfMissing(Map<String, String> carrier, String key) {
        if (!carrier.containsKey(key)) {
            carrier.put(key, Span.idToHex(new Random().nextLong()));
        }
    }

    private long spanId(Map<String, String> carrier) {
        String spanId = carrier.get("X-B3-SpanId");
        if (spanId == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Request is missing a span id but it has a trace id. We'll assume that this is a root span with span id equal to the lower 64-bits of the trace id");
            }
            return Span.hexToId(carrier.get("X-B3-TraceId"));
        }
        return Span.hexToId(spanId);
    }

    private Span buildParentSpan(Map<String, String> carrier, String uri, boolean skip, long spanId) {
        String traceId = carrier.get("X-B3-TraceId");
        Span.SpanBuilder span = Span.builder().traceIdHigh(traceId.length() == 32 ? Span.hexToId(traceId, 0) : 0L).traceId(Span.hexToId(traceId)).spanId(spanId);
        String processId = carrier.get("X-Process-Id");
        String parentName = carrier.get("X-Span-Name");
        if (StringUtils.hasText((String)parentName)) {
            span.name(parentName);
        } else {
            span.name("http:/parent" + uri);
        }
        if (StringUtils.hasText((String)processId)) {
            span.processId(processId);
        }
        if (carrier.containsKey("X-B3-ParentSpanId")) {
            span.parent(Span.hexToId(carrier.get("X-B3-ParentSpanId")));
        }
        span.remote(true);
        boolean debug = "1".equals(carrier.get("X-B3-Flags"));
        if (debug) {
            span.exportable(true);
        } else if (skip) {
            span.exportable(false);
        }
        for (Map.Entry<String, String> entry : carrier.entrySet()) {
            if (!entry.getKey().startsWith("baggage-")) continue;
            span.baggage(this.unprefixedKey(entry.getKey()), entry.getValue());
        }
        return span.build();
    }

    private String unprefixedKey(String key) {
        return key.substring(key.indexOf(HEADER_DELIMITER) + 1);
    }
}

