/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import java.util.Map;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanTextMap;
import org.springframework.cloud.sleuth.instrument.web.HttpSpanInjector;
import org.springframework.util.StringUtils;

public class ZipkinHttpSpanInjector
implements HttpSpanInjector {
    private static final String HEADER_DELIMITER = "-";

    @Override
    public void inject(Span span, SpanTextMap carrier) {
        this.setHeader(carrier, "X-B3-TraceId", span.traceIdString());
        this.setIdHeader(carrier, "X-B3-SpanId", span.getSpanId());
        this.setHeader(carrier, "X-B3-Sampled", span.isExportable() ? "1" : "0");
        this.setHeader(carrier, "X-Span-Name", span.getName());
        this.setIdHeader(carrier, "X-B3-ParentSpanId", this.getParentId(span));
        this.setHeader(carrier, "X-Process-Id", span.getProcessId());
        for (Map.Entry<String, String> entry : span.baggageItems()) {
            carrier.put(this.prefixedKey(entry.getKey()), entry.getValue());
        }
    }

    private String prefixedKey(String key) {
        if (key.startsWith("baggage-")) {
            return key;
        }
        return "baggage-" + key;
    }

    private Long getParentId(Span span) {
        return !span.getParents().isEmpty() ? span.getParents().get(0) : null;
    }

    private void setIdHeader(SpanTextMap carrier, String name, Long value) {
        if (value != null) {
            this.setHeader(carrier, name, Span.idToHex(value));
        }
    }

    private void setHeader(SpanTextMap carrier, String name, String value) {
        if (StringUtils.hasText((String)value)) {
            carrier.put(name, value);
        }
    }
}

