/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.zuul;

import com.netflix.zuul.ExecutionStatus;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.ZuulFilterResult;
import com.netflix.zuul.context.RequestContext;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.web.HttpSpanInjector;
import org.springframework.cloud.sleuth.instrument.web.HttpTraceKeysInjector;
import org.springframework.cloud.sleuth.instrument.web.TraceRequestAttributes;
import org.springframework.cloud.sleuth.instrument.zuul.RequestContextTextMap;

public class TracePreZuulFilter
extends ZuulFilter {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final String ZUUL_COMPONENT = "zuul";
    private final Tracer tracer;
    private final HttpSpanInjector spanInjector;
    private final HttpTraceKeysInjector httpTraceKeysInjector;

    public TracePreZuulFilter(Tracer tracer, HttpSpanInjector spanInjector, HttpTraceKeysInjector httpTraceKeysInjector) {
        this.tracer = tracer;
        this.spanInjector = spanInjector;
        this.httpTraceKeysInjector = httpTraceKeysInjector;
    }

    public boolean shouldFilter() {
        return true;
    }

    public Object run() {
        this.getCurrentSpan().logEvent("cs");
        return null;
    }

    public ZuulFilterResult runFilter() {
        RequestContext ctx = RequestContext.getCurrentContext();
        Span span = this.getCurrentSpan();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Current span is " + span + ""));
        }
        this.markRequestAsHandled(ctx);
        Span newSpan = this.tracer.createSpan(span.getName(), span);
        newSpan.tag("lc", ZUUL_COMPONENT);
        this.spanInjector.inject(newSpan, new RequestContextTextMap(ctx));
        this.httpTraceKeysInjector.addRequestTags(newSpan, URI.create(ctx.getRequest().getRequestURI()), ctx.getRequest().getMethod());
        if (log.isDebugEnabled()) {
            log.debug((Object)("New Zuul Span is " + newSpan + ""));
        }
        ZuulFilterResult result = super.runFilter();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Result of Zuul filter is [" + result.getStatus() + "]"));
        }
        if (ExecutionStatus.SUCCESS != result.getStatus()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("The result of Zuul filter execution was not successful thus will close the current span " + newSpan));
            }
            this.tracer.close(newSpan);
        }
        return result;
    }

    private void markRequestAsHandled(RequestContext ctx) {
        ctx.getRequest().setAttribute(TraceRequestAttributes.HANDLED_SPAN_REQUEST_ATTR, (Object)"true");
    }

    private Span getCurrentSpan() {
        return this.tracer.getCurrentSpan();
    }

    public String filterType() {
        return "pre";
    }

    public int filterOrder() {
        return 0;
    }
}

