/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.metric;

import java.lang.invoke.MethodHandles;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.metrics.CounterService;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.metric.CounterServiceBasedSpanMetricReporter;
import org.springframework.cloud.sleuth.metric.NoOpSpanMetricReporter;
import org.springframework.cloud.sleuth.metric.SleuthMetricProperties;
import org.springframework.cloud.sleuth.metric.SpanMetricReporter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration
@Conditional(value={PickMetricIfMetricsIsMissing.class})
@EnableConfigurationProperties
public class TraceMetricsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public SleuthMetricProperties sleuthMetricProperties() {
        return new SleuthMetricProperties();
    }

    @Bean
    @ConditionalOnMissingClass(value={"org.springframework.boot.actuate.metrics.CounterService"})
    @ConditionalOnMissingBean(value={SpanMetricReporter.class})
    public SpanMetricReporter noOpSpanReporterCounterService() {
        return new NoOpSpanMetricReporter();
    }

    static class PickMetricIfMetricsIsMissing
    extends SpringBootCondition {
        private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
        static final String DEPRECATED_SPRING_SLEUTH_METRICS_ENABLED = "spring.sleuth.metrics.enabled";
        static final String SPRING_SLEUTH_METRIC_ENABLED = "spring.sleuth.metric.enabled";

        PickMetricIfMetricsIsMissing() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            Boolean oldValue = (Boolean)context.getEnvironment().getProperty(DEPRECATED_SPRING_SLEUTH_METRICS_ENABLED, Boolean.class);
            Boolean newValue = (Boolean)context.getEnvironment().getProperty(SPRING_SLEUTH_METRIC_ENABLED, Boolean.class);
            if (oldValue != null) {
                log.warn((Object)"You're using an old version of the metrics property. Instead of using [spring.sleuth.metrics.enabled] please use [spring.sleuth.metric.enabled]");
                return this.matchCondition(oldValue, DEPRECATED_SPRING_SLEUTH_METRICS_ENABLED);
            }
            if (newValue != null) {
                return this.matchCondition(newValue, SPRING_SLEUTH_METRIC_ENABLED);
            }
            return ConditionOutcome.match((String)"No property was passed - assuming that metrics are enabled.");
        }

        private ConditionOutcome matchCondition(Boolean value, String property) {
            if (Boolean.TRUE.equals(value)) {
                return ConditionOutcome.match();
            }
            return ConditionOutcome.noMatch((String)("Property [" + property + "] is set to false."));
        }
    }

    @Configuration
    @ConditionalOnClass(value={CounterService.class})
    @ConditionalOnMissingBean(value={SpanMetricReporter.class})
    protected static class CounterServiceSpanReporterConfig {
        protected CounterServiceSpanReporterConfig() {
        }

        @Bean
        @ConditionalOnBean(value={CounterService.class})
        public SpanMetricReporter spanReporterCounterService(CounterService counterService, SleuthMetricProperties sleuthMetricProperties) {
            return new CounterServiceBasedSpanMetricReporter(sleuthMetricProperties.getSpan().getAcceptedName(), sleuthMetricProperties.getSpan().getDroppedName(), counterService);
        }

        @Bean
        @ConditionalOnMissingBean(value={CounterService.class})
        public SpanMetricReporter noOpSpanReporterCounterService() {
            return new NoOpSpanMetricReporter();
        }
    }
}

