/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.reactor;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.reactivestreams.Subscription;
import org.springframework.cloud.sleuth.instrument.reactor.SpanSubscription;
import reactor.util.context.Context;

final class LazySpanSubscriber<T>
extends AtomicBoolean
implements SpanSubscription<T> {
    private final Supplier<SpanSubscription<T>> supplier;

    LazySpanSubscriber(Supplier<SpanSubscription<T>> supplier) {
        this.supplier = supplier;
    }

    public void onSubscribe(Subscription subscription) {
        this.supplier.get().onSubscribe(subscription);
    }

    public void request(long n) {
        this.supplier.get().request(n);
    }

    public void cancel() {
        this.supplier.get().cancel();
    }

    public void onNext(T o) {
        this.supplier.get().onNext(o);
    }

    public void onError(Throwable throwable) {
        this.supplier.get().onError(throwable);
    }

    public void onComplete() {
        this.supplier.get().onComplete();
    }

    public Context currentContext() {
        return this.supplier.get().currentContext();
    }
}

