/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import brave.Span;
import brave.Tracer;
import brave.http.HttpServerAdapter;
import brave.http.HttpServerHandler;
import brave.http.HttpTracing;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Subscription;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.instrument.web.SleuthWebProperties;
import org.springframework.core.Ordered;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoOperator;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

public final class TraceWebFilter
implements WebFilter,
Ordered {
    public static final int ORDER = -2147483643;
    protected static final String TRACE_REQUEST_ATTR = TraceWebFilter.class.getName() + ".TRACE";
    static final String MVC_CONTROLLER_CLASS_KEY = "mvc.controller.class";
    static final String MVC_CONTROLLER_METHOD_KEY = "mvc.controller.method";
    static final Propagation.Getter<HttpHeaders, String> GETTER = new Propagation.Getter<HttpHeaders, String>(){

        public String get(HttpHeaders carrier, String key) {
            return carrier.getFirst(key);
        }

        public String toString() {
            return "HttpHeaders::getFirst";
        }
    };
    private static final Log log = LogFactory.getLog(TraceWebFilter.class);
    private static final String STATUS_CODE_KEY = "http.status_code";
    private static final String TRACE_SPAN_WITHOUT_PARENT = TraceWebFilter.class.getName() + ".SPAN_WITH_NO_PARENT";
    private final BeanFactory beanFactory;
    Tracer tracer;
    HttpServerHandler<ServerHttpRequest, ServerHttpResponse> handler;
    TraceContext.Extractor<HttpHeaders> extractor;
    SleuthWebProperties webProperties;

    TraceWebFilter(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public static WebFilter create(BeanFactory beanFactory) {
        return new TraceWebFilter(beanFactory);
    }

    HttpServerHandler<ServerHttpRequest, ServerHttpResponse> handler() {
        if (this.handler == null) {
            this.handler = HttpServerHandler.create((HttpTracing)((HttpTracing)this.beanFactory.getBean(HttpTracing.class)), (HttpServerAdapter)new HttpAdapter());
        }
        return this.handler;
    }

    Tracer tracer() {
        if (this.tracer == null) {
            this.tracer = ((HttpTracing)this.beanFactory.getBean(HttpTracing.class)).tracing().tracer();
        }
        return this.tracer;
    }

    TraceContext.Extractor<HttpHeaders> extractor() {
        if (this.extractor == null) {
            this.extractor = ((HttpTracing)this.beanFactory.getBean(HttpTracing.class)).tracing().propagation().extractor(GETTER);
        }
        return this.extractor;
    }

    SleuthWebProperties sleuthWebProperties() {
        if (this.webProperties == null) {
            this.webProperties = (SleuthWebProperties)this.beanFactory.getBean(SleuthWebProperties.class);
        }
        return this.webProperties;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        if (this.tracer().currentSpan() != null) {
            this.tracer().withSpanInScope(null);
        }
        String uri = exchange.getRequest().getPath().pathWithinApplication().value();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received a request to uri [" + uri + "]"));
        }
        return new MonoWebFilterTrace((Mono<? extends Void>)chain.filter(exchange), exchange, this);
    }

    public int getOrder() {
        return this.sleuthWebProperties().getFilterOrder();
    }

    static final class HttpAdapter
    extends HttpServerAdapter<ServerHttpRequest, ServerHttpResponse> {
        HttpAdapter() {
        }

        public String method(ServerHttpRequest request) {
            return request.getMethodValue();
        }

        public String url(ServerHttpRequest request) {
            return request.getURI().toString();
        }

        public String requestHeader(ServerHttpRequest request, String name) {
            String result = request.getHeaders().getFirst(name);
            return result != null ? result.toString() : null;
        }

        public Integer statusCode(ServerHttpResponse response) {
            return response.getStatusCode() != null ? Integer.valueOf(response.getStatusCode().value()) : null;
        }

        public String methodFromResponse(ServerHttpResponse response) {
            if (response instanceof DecoratedServerHttpResponse) {
                return ((DecoratedServerHttpResponse)response).method;
            }
            return null;
        }

        public String route(ServerHttpResponse response) {
            if (response instanceof DecoratedServerHttpResponse) {
                return ((DecoratedServerHttpResponse)response).httpRoute;
            }
            return null;
        }
    }

    static final class DecoratedServerHttpResponse
    extends ServerHttpResponseDecorator {
        final String method;
        final String httpRoute;

        DecoratedServerHttpResponse(ServerHttpResponse delegate, String method, String httpRoute) {
            super(delegate);
            this.method = method;
            this.httpRoute = httpRoute;
        }
    }

    private static class MonoWebFilterTrace
    extends MonoOperator<Void, Void> {
        final ServerWebExchange exchange;
        final Tracer tracer;
        final Span attrSpan;
        final HttpServerHandler<ServerHttpRequest, ServerHttpResponse> handler;
        final TraceContext.Extractor<HttpHeaders> extractor;

        MonoWebFilterTrace(Mono<? extends Void> source, ServerWebExchange exchange, TraceWebFilter parent) {
            super(source);
            this.tracer = parent.tracer();
            this.extractor = parent.extractor();
            this.handler = parent.handler();
            this.exchange = exchange;
            this.attrSpan = (Span)exchange.getAttribute(TRACE_REQUEST_ATTR);
        }

        public void subscribe(CoreSubscriber<? super Void> subscriber) {
            Context context = subscriber.currentContext();
            this.source.subscribe((CoreSubscriber)new WebFilterTraceSubscriber(subscriber, context, this.findOrCreateSpan(context), this));
        }

        private Span findOrCreateSpan(Context c) {
            Span span;
            if (c.hasKey(Span.class)) {
                Span parent = (Span)c.get(Span.class);
                span = this.tracer.nextSpan(TraceContextOrSamplingFlags.create((TraceContext)parent.context())).start();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found span in reactor context" + span));
                }
            } else {
                if (this.attrSpan != null) {
                    span = this.attrSpan;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Found span in attribute " + span));
                    }
                } else {
                    span = this.handler.handleReceive(this.extractor, (Object)this.exchange.getRequest().getHeaders(), (Object)this.exchange.getRequest());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Handled receive of span " + span));
                    }
                }
                this.exchange.getAttributes().put(TRACE_REQUEST_ATTR, span);
            }
            return span;
        }

        static final class WebFilterTraceSubscriber
        implements CoreSubscriber<Void> {
            final CoreSubscriber<? super Void> actual;
            final Context context;
            final Span span;
            final ServerWebExchange exchange;
            final HttpServerHandler<ServerHttpRequest, ServerHttpResponse> handler;

            WebFilterTraceSubscriber(CoreSubscriber<? super Void> actual, Context context, Span span, MonoWebFilterTrace parent) {
                this.actual = actual;
                this.span = span;
                this.context = context.put(Span.class, (Object)span);
                this.exchange = parent.exchange;
                this.handler = parent.handler;
            }

            public void onSubscribe(Subscription subscription) {
                this.actual.onSubscribe(subscription);
            }

            public void onNext(Void aVoid) {
            }

            public void onError(Throwable t) {
                this.terminateSpan(t);
                this.actual.onError(t);
            }

            public void onComplete() {
                this.terminateSpan(null);
                this.actual.onComplete();
            }

            public Context currentContext() {
                return this.context;
            }

            private void terminateSpan(@Nullable Throwable t) {
                String httpRoute = null;
                Object attribute = this.exchange.getAttribute(HandlerMapping.BEST_MATCHING_HANDLER_ATTRIBUTE);
                if (attribute instanceof HandlerMethod) {
                    HandlerMethod handlerMethod = (HandlerMethod)attribute;
                    this.addClassMethodTag(handlerMethod, this.span);
                    this.addClassNameTag(handlerMethod, this.span);
                    Object pattern = this.exchange.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
                    httpRoute = pattern != null ? pattern.toString() : "";
                }
                this.addResponseTagsForSpanWithoutParent(this.exchange, this.exchange.getResponse(), this.span);
                DecoratedServerHttpResponse delegate = new DecoratedServerHttpResponse(this.exchange.getResponse(), this.exchange.getRequest().getMethodValue(), httpRoute);
                this.handler.handleSend((Object)delegate, t, this.span);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Handled send of " + this.span));
                }
            }

            private void addClassMethodTag(Object handler, Span span) {
                if (handler instanceof HandlerMethod) {
                    String methodName = ((HandlerMethod)handler).getMethod().getName();
                    span.tag(TraceWebFilter.MVC_CONTROLLER_METHOD_KEY, methodName);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Adding a method tag with value [" + methodName + "] to a span " + span));
                    }
                }
            }

            private void addClassNameTag(Object handler, Span span) {
                String className = handler instanceof HandlerMethod ? ((HandlerMethod)handler).getBeanType().getSimpleName() : handler.getClass().getSimpleName();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding a class tag with value [" + className + "] to a span " + span));
                }
                span.tag(TraceWebFilter.MVC_CONTROLLER_CLASS_KEY, className);
            }

            private void addResponseTagsForSpanWithoutParent(ServerWebExchange exchange, ServerHttpResponse response, Span span) {
                if (this.spanWithoutParent(exchange) && response.getStatusCode() != null && span != null) {
                    span.tag(TraceWebFilter.STATUS_CODE_KEY, String.valueOf(response.getStatusCode().value()));
                }
            }

            private boolean spanWithoutParent(ServerWebExchange exchange) {
                return exchange.getAttribute(TRACE_SPAN_WITHOUT_PARENT) != null;
            }
        }
    }
}

