/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.log;

import brave.internal.HexCodec;
import brave.internal.Nullable;
import brave.propagation.CurrentTraceContext;
import brave.propagation.ExtraFieldPropagation;
import brave.propagation.TraceContext;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.cloud.sleuth.autoconfig.SleuthProperties;
import org.springframework.cloud.sleuth.log.SleuthSlf4jProperties;
import org.springframework.util.StringUtils;

final class Slf4jScopeDecorator
implements CurrentTraceContext.ScopeDecorator {
    private static final String LEGACY_EXPORTABLE_NAME = "X-Span-Export";
    private static final String LEGACY_PARENT_ID_NAME = "X-B3-ParentSpanId";
    private static final String LEGACY_TRACE_ID_NAME = "X-B3-TraceId";
    private static final String LEGACY_SPAN_ID_NAME = "X-B3-SpanId";
    private static final Logger log = LoggerFactory.getLogger(Slf4jScopeDecorator.class);
    private final SleuthProperties sleuthProperties;
    private final SleuthSlf4jProperties sleuthSlf4jProperties;

    Slf4jScopeDecorator(SleuthProperties sleuthProperties, SleuthSlf4jProperties sleuthSlf4jProperties) {
        this.sleuthProperties = sleuthProperties;
        this.sleuthSlf4jProperties = sleuthSlf4jProperties;
    }

    static void replace(String key, @Nullable String value) {
        if (value != null) {
            MDC.put((String)key, (String)value);
        } else {
            MDC.remove((String)key);
        }
    }

    public CurrentTraceContext.Scope decorateScope(final TraceContext currentSpan, final CurrentTraceContext.Scope scope) {
        final String previousTraceId = MDC.get((String)"traceId");
        final String previousParentId = MDC.get((String)"parentId");
        final String previousSpanId = MDC.get((String)"spanId");
        final String spanExportable = MDC.get((String)"spanExportable");
        final String legacyPreviousTraceId = MDC.get((String)LEGACY_TRACE_ID_NAME);
        final String legacyPreviousParentId = MDC.get((String)LEGACY_PARENT_ID_NAME);
        final String legacyPreviousSpanId = MDC.get((String)LEGACY_SPAN_ID_NAME);
        final String legacySpanExportable = MDC.get((String)LEGACY_EXPORTABLE_NAME);
        final List<AbstractMap.SimpleEntry<String, String>> previousMdc = this.previousMdc();
        if (currentSpan != null) {
            String traceIdString = currentSpan.traceIdString();
            MDC.put((String)"traceId", (String)traceIdString);
            MDC.put((String)LEGACY_TRACE_ID_NAME, (String)traceIdString);
            String parentId = currentSpan.parentId() != null ? HexCodec.toLowerHex((long)currentSpan.parentId()) : null;
            Slf4jScopeDecorator.replace("parentId", parentId);
            Slf4jScopeDecorator.replace(LEGACY_PARENT_ID_NAME, parentId);
            String spanId = HexCodec.toLowerHex((long)currentSpan.spanId());
            MDC.put((String)"spanId", (String)spanId);
            MDC.put((String)LEGACY_SPAN_ID_NAME, (String)spanId);
            String sampled = String.valueOf(currentSpan.sampled());
            MDC.put((String)"spanExportable", (String)sampled);
            MDC.put((String)LEGACY_EXPORTABLE_NAME, (String)sampled);
            this.log("Starting scope for span: {}", currentSpan);
            if (currentSpan.parentId() != null && log.isTraceEnabled()) {
                log.trace("With parent: {}", (Object)currentSpan.parentId());
            }
            for (String key : this.whitelistedBaggageKeysWithValue(currentSpan)) {
                MDC.put((String)key, (String)ExtraFieldPropagation.get((TraceContext)currentSpan, (String)key));
            }
            for (String key : this.whitelistedPropagationKeysWithValue(currentSpan)) {
                MDC.put((String)key, (String)ExtraFieldPropagation.get((TraceContext)currentSpan, (String)key));
            }
            for (String key : this.whitelistedLocalKeysWithValue(currentSpan)) {
                MDC.put((String)key, (String)ExtraFieldPropagation.get((TraceContext)currentSpan, (String)key));
            }
        } else {
            MDC.remove((String)"traceId");
            MDC.remove((String)"parentId");
            MDC.remove((String)"spanId");
            MDC.remove((String)"spanExportable");
            MDC.remove((String)LEGACY_TRACE_ID_NAME);
            MDC.remove((String)LEGACY_PARENT_ID_NAME);
            MDC.remove((String)LEGACY_SPAN_ID_NAME);
            MDC.remove((String)LEGACY_EXPORTABLE_NAME);
            for (String s : this.whitelistedBaggageKeys()) {
                MDC.remove((String)s);
            }
            for (String s : this.whitelistedPropagationKeys()) {
                MDC.remove((String)s);
            }
            for (String s : this.whitelistedLocalKeys()) {
                MDC.remove((String)s);
            }
            previousMdc.clear();
        }
        class ThreadContextCurrentTraceContextScope
        implements CurrentTraceContext.Scope {
            ThreadContextCurrentTraceContextScope() {
            }

            public void close() {
                Slf4jScopeDecorator.this.log("Closing scope for span: {}", currentSpan);
                scope.close();
                Slf4jScopeDecorator.replace("traceId", previousTraceId);
                Slf4jScopeDecorator.replace("parentId", previousParentId);
                Slf4jScopeDecorator.replace("spanId", previousSpanId);
                Slf4jScopeDecorator.replace("spanExportable", spanExportable);
                Slf4jScopeDecorator.replace(Slf4jScopeDecorator.LEGACY_TRACE_ID_NAME, legacyPreviousTraceId);
                Slf4jScopeDecorator.replace(Slf4jScopeDecorator.LEGACY_PARENT_ID_NAME, legacyPreviousParentId);
                Slf4jScopeDecorator.replace(Slf4jScopeDecorator.LEGACY_SPAN_ID_NAME, legacyPreviousSpanId);
                Slf4jScopeDecorator.replace(Slf4jScopeDecorator.LEGACY_EXPORTABLE_NAME, legacySpanExportable);
                for (AbstractMap.SimpleEntry entry : previousMdc) {
                    Slf4jScopeDecorator.replace((String)entry.getKey(), (String)entry.getValue());
                }
            }
        }
        return new ThreadContextCurrentTraceContextScope();
    }

    private List<AbstractMap.SimpleEntry<String, String>> previousMdc() {
        ArrayList<AbstractMap.SimpleEntry<String, String>> previousMdc = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
        ArrayList<String> keys = new ArrayList<String>(this.whitelistedBaggageKeys());
        keys.addAll(this.whitelistedPropagationKeys());
        keys.addAll(this.whitelistedLocalKeys());
        for (String key : keys) {
            previousMdc.add(new AbstractMap.SimpleEntry<String, String>(key, MDC.get((String)key)));
        }
        return previousMdc;
    }

    private List<String> whitelistedKeys(List<String> keysToFilter) {
        ArrayList<String> keys = new ArrayList<String>();
        for (String baggageKey : keysToFilter) {
            if (!this.sleuthSlf4jProperties.getWhitelistedMdcKeys().contains(baggageKey)) continue;
            keys.add(baggageKey);
        }
        return keys;
    }

    private List<String> whitelistedBaggageKeys() {
        return this.whitelistedKeys(this.sleuthProperties.getBaggageKeys());
    }

    private List<String> whitelistedKeysWithValue(TraceContext context, List<String> keys) {
        if (context == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> nonEmpty = new ArrayList<String>();
        for (String key : keys) {
            if (!StringUtils.hasText((String)ExtraFieldPropagation.get((TraceContext)context, (String)key))) continue;
            nonEmpty.add(key);
        }
        return nonEmpty;
    }

    private List<String> whitelistedBaggageKeysWithValue(TraceContext context) {
        return this.whitelistedKeysWithValue(context, this.whitelistedBaggageKeys());
    }

    private List<String> whitelistedPropagationKeys() {
        return this.whitelistedKeys(this.sleuthProperties.getPropagationKeys());
    }

    private List<String> whitelistedLocalKeys() {
        return this.whitelistedKeys(this.sleuthProperties.getLocalKeys());
    }

    private List<String> whitelistedPropagationKeysWithValue(TraceContext context) {
        return this.whitelistedKeysWithValue(context, this.whitelistedPropagationKeys());
    }

    private List<String> whitelistedLocalKeysWithValue(TraceContext context) {
        return this.whitelistedKeysWithValue(context, this.whitelistedLocalKeys());
    }

    private void log(String text, TraceContext span) {
        if (span == null) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace(text, (Object)span);
        }
    }
}

