/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.properties;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.stream.binder.HeaderMode;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.binder.kafka.properties.JaasLoginModuleConfiguration;
import org.springframework.cloud.stream.binder.kafka.properties.KafkaProducerProperties;
import org.springframework.cloud.stream.binder.kafka.properties.KafkaTopicProperties;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.expression.Expression;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="spring.cloud.stream.kafka.binder")
public class KafkaBinderConfigurationProperties {
    private static final String DEFAULT_KAFKA_CONNECTION_STRING = "localhost:9092";
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Transaction transaction = new Transaction();
    private final KafkaProperties kafkaProperties;
    private Map<String, String> configuration = new HashMap<String, String>();
    private Map<String, String> consumerProperties = new HashMap<String, String>();
    private Map<String, String> producerProperties = new HashMap<String, String>();
    private String[] brokers = new String[]{"localhost"};
    private String defaultBrokerPort = "9092";
    private String[] headers = new String[0];
    private boolean autoCreateTopics = true;
    private boolean autoAlterTopics;
    private boolean autoAddPartitions;
    private boolean considerDownWhenAnyPartitionHasNoLeader;
    private String requiredAcks = "1";
    private short replicationFactor = (short)-1;
    private int minPartitionCount = 1;
    private int healthTimeout = 60;
    private JaasLoginModuleConfiguration jaas;
    private String headerMapperBeanName;
    private Duration authorizationExceptionRetryInterval;
    private String certificateStoreDirectory;

    public KafkaBinderConfigurationProperties(KafkaProperties kafkaProperties) {
        Assert.notNull((Object)kafkaProperties, (String)"'kafkaProperties' cannot be null");
        this.kafkaProperties = kafkaProperties;
    }

    public KafkaProperties getKafkaProperties() {
        return this.kafkaProperties;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public String getKafkaConnectionString() {
        this.moveCertsToFileSystemIfNecessary();
        return this.toConnectionString(this.brokers, this.defaultBrokerPort);
    }

    private void moveCertsToFileSystemIfNecessary() {
        try {
            String keyStoreLocation;
            String trustStoreLocation = this.configuration.get("ssl.truststore.location");
            if (trustStoreLocation != null && trustStoreLocation.startsWith("classpath:")) {
                String fileSystemLocation = this.moveCertToFileSystem(trustStoreLocation, this.certificateStoreDirectory);
                this.configuration.put("ssl.truststore.location", fileSystemLocation);
            }
            if ((keyStoreLocation = this.configuration.get("ssl.keystore.location")) != null && keyStoreLocation.startsWith("classpath:")) {
                String fileSystemLocation = this.moveCertToFileSystem(keyStoreLocation, this.certificateStoreDirectory);
                this.configuration.put("ssl.keystore.location", fileSystemLocation);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private String moveCertToFileSystem(String classpathLocation, String fileSystemLocation) throws IOException {
        File targetFile;
        String tempDir = System.getProperty("java.io.tmpdir");
        Resource resource = new DefaultResourceLoader().getResource(classpathLocation);
        if (StringUtils.hasText((String)fileSystemLocation)) {
            Path path = Paths.get(fileSystemLocation, new String[0]);
            if (!(Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0]) && Files.isWritable(path))) {
                this.logger.warn((Object)("The filesystem location to move the cert files (" + fileSystemLocation + ") is not found or a directory that is writable. The system temp folder (java.io.tmpdir) will be used instead."));
                targetFile = new File(Paths.get(tempDir, resource.getFilename()).toString());
            } else {
                targetFile = new File(Paths.get(fileSystemLocation, resource.getFilename()).toString());
            }
        } else {
            targetFile = new File(Paths.get(tempDir, resource.getFilename()).toString());
        }
        try (InputStream inputStream = resource.getInputStream();){
            Files.copy(inputStream, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        return targetFile.getAbsolutePath();
    }

    public String getDefaultKafkaConnectionString() {
        return DEFAULT_KAFKA_CONNECTION_STRING;
    }

    public String[] getHeaders() {
        return this.headers;
    }

    public String[] getBrokers() {
        return this.brokers;
    }

    public void setBrokers(String ... brokers) {
        this.brokers = brokers;
    }

    public void setDefaultBrokerPort(String defaultBrokerPort) {
        this.defaultBrokerPort = defaultBrokerPort;
    }

    public void setHeaders(String ... headers) {
        this.headers = headers;
    }

    private String toConnectionString(String[] hosts, String defaultPort) {
        Object[] fullyFormattedHosts = new String[hosts.length];
        for (int i = 0; i < hosts.length; ++i) {
            fullyFormattedHosts[i] = hosts[i].contains(":") || StringUtils.isEmpty((Object)defaultPort) ? hosts[i] : hosts[i] + ":" + defaultPort;
        }
        return StringUtils.arrayToCommaDelimitedString((Object[])fullyFormattedHosts);
    }

    public String getRequiredAcks() {
        return this.requiredAcks;
    }

    public void setRequiredAcks(String requiredAcks) {
        this.requiredAcks = requiredAcks;
    }

    public short getReplicationFactor() {
        return this.replicationFactor;
    }

    public void setReplicationFactor(short replicationFactor) {
        this.replicationFactor = replicationFactor;
    }

    public int getMinPartitionCount() {
        return this.minPartitionCount;
    }

    public void setMinPartitionCount(int minPartitionCount) {
        this.minPartitionCount = minPartitionCount;
    }

    public int getHealthTimeout() {
        return this.healthTimeout;
    }

    public void setHealthTimeout(int healthTimeout) {
        this.healthTimeout = healthTimeout;
    }

    public boolean isAutoCreateTopics() {
        return this.autoCreateTopics;
    }

    public void setAutoCreateTopics(boolean autoCreateTopics) {
        this.autoCreateTopics = autoCreateTopics;
    }

    public boolean isAutoAlterTopics() {
        return this.autoAlterTopics;
    }

    public void setAutoAlterTopics(boolean autoAlterTopics) {
        this.autoAlterTopics = autoAlterTopics;
    }

    public boolean isAutoAddPartitions() {
        return this.autoAddPartitions;
    }

    public void setAutoAddPartitions(boolean autoAddPartitions) {
        this.autoAddPartitions = autoAddPartitions;
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Map<String, String> configuration) {
        this.configuration = configuration;
    }

    public Map<String, String> getConsumerProperties() {
        return this.consumerProperties;
    }

    public void setConsumerProperties(Map<String, String> consumerProperties) {
        Assert.notNull(consumerProperties, (String)"'consumerProperties' cannot be null");
        this.consumerProperties = consumerProperties;
    }

    public Map<String, String> getProducerProperties() {
        return this.producerProperties;
    }

    public void setProducerProperties(Map<String, String> producerProperties) {
        Assert.notNull(producerProperties, (String)"'producerProperties' cannot be null");
        this.producerProperties = producerProperties;
    }

    public Map<String, Object> mergedConsumerConfiguration() {
        HashMap<String, Object> consumerConfiguration = new HashMap<String, Object>();
        consumerConfiguration.putAll(this.kafkaProperties.buildConsumerProperties());
        for (Map.Entry<String, String> configurationEntry : this.configuration.entrySet()) {
            if (!ConsumerConfig.configNames().contains(configurationEntry.getKey())) continue;
            consumerConfiguration.put(configurationEntry.getKey(), configurationEntry.getValue());
        }
        consumerConfiguration.putAll(this.consumerProperties);
        this.filterStreamManagedConfiguration(consumerConfiguration);
        return this.getConfigurationWithBootstrapServer(consumerConfiguration, "bootstrap.servers");
    }

    public Map<String, Object> mergedProducerConfiguration() {
        HashMap<String, Object> producerConfiguration = new HashMap<String, Object>();
        producerConfiguration.putAll(this.kafkaProperties.buildProducerProperties());
        for (Map.Entry<String, String> configurationEntry : this.configuration.entrySet()) {
            if (!ProducerConfig.configNames().contains(configurationEntry.getKey())) continue;
            producerConfiguration.put(configurationEntry.getKey(), configurationEntry.getValue());
        }
        producerConfiguration.putAll(this.producerProperties);
        return this.getConfigurationWithBootstrapServer(producerConfiguration, "bootstrap.servers");
    }

    private void filterStreamManagedConfiguration(Map<String, Object> configuration) {
        if (configuration.containsKey("enable.auto.commit") && configuration.get("enable.auto.commit").equals(true)) {
            this.logger.warn((Object)(this.constructIgnoredConfigMessage("enable.auto.commit") + "enable.auto.commit" + "=true is not supported by the Kafka binder"));
            configuration.remove("enable.auto.commit");
        }
        if (configuration.containsKey("group.id")) {
            this.logger.warn((Object)(this.constructIgnoredConfigMessage("group.id") + "Use spring.cloud.stream.default.group or spring.cloud.stream.binding.<name>.group to specify the group instead of " + "group.id"));
            configuration.remove("group.id");
        }
    }

    private String constructIgnoredConfigMessage(String config) {
        return String.format("Ignoring provided value(s) for '%s'. ", config);
    }

    private Map<String, Object> getConfigurationWithBootstrapServer(Map<String, Object> configuration, String bootstrapServersConfig) {
        String kafkaConnectionString = this.getKafkaConnectionString();
        if (ObjectUtils.isEmpty((Object)configuration.get(bootstrapServersConfig)) || !kafkaConnectionString.equals(DEFAULT_KAFKA_CONNECTION_STRING)) {
            configuration.put(bootstrapServersConfig, kafkaConnectionString);
        }
        return Collections.unmodifiableMap(configuration);
    }

    public JaasLoginModuleConfiguration getJaas() {
        return this.jaas;
    }

    public void setJaas(JaasLoginModuleConfiguration jaas) {
        this.jaas = jaas;
    }

    public String getHeaderMapperBeanName() {
        return this.headerMapperBeanName;
    }

    public void setHeaderMapperBeanName(String headerMapperBeanName) {
        this.headerMapperBeanName = headerMapperBeanName;
    }

    public Duration getAuthorizationExceptionRetryInterval() {
        return this.authorizationExceptionRetryInterval;
    }

    public void setAuthorizationExceptionRetryInterval(Duration authorizationExceptionRetryInterval) {
        this.authorizationExceptionRetryInterval = authorizationExceptionRetryInterval;
    }

    public boolean isConsiderDownWhenAnyPartitionHasNoLeader() {
        return this.considerDownWhenAnyPartitionHasNoLeader;
    }

    public void setConsiderDownWhenAnyPartitionHasNoLeader(boolean considerDownWhenAnyPartitionHasNoLeader) {
        this.considerDownWhenAnyPartitionHasNoLeader = considerDownWhenAnyPartitionHasNoLeader;
    }

    public String getCertificateStoreDirectory() {
        return this.certificateStoreDirectory;
    }

    public void setCertificateStoreDirectory(String certificateStoreDirectory) {
        this.certificateStoreDirectory = certificateStoreDirectory;
    }

    public static class CombinedProducerProperties {
        private final ProducerProperties producerProperties = new ProducerProperties();
        private final KafkaProducerProperties kafkaProducerProperties = new KafkaProducerProperties();

        public Expression getPartitionKeyExpression() {
            return this.producerProperties.getPartitionKeyExpression();
        }

        public void setPartitionKeyExpression(Expression partitionKeyExpression) {
            this.producerProperties.setPartitionKeyExpression(partitionKeyExpression);
        }

        public boolean isPartitioned() {
            return this.producerProperties.isPartitioned();
        }

        public Expression getPartitionSelectorExpression() {
            return this.producerProperties.getPartitionSelectorExpression();
        }

        public void setPartitionSelectorExpression(Expression partitionSelectorExpression) {
            this.producerProperties.setPartitionSelectorExpression(partitionSelectorExpression);
        }

        @Min(value=1L, message="Partition count should be greater than zero.")
        public @Min(value=1L, message="Partition count should be greater than zero.") int getPartitionCount() {
            return this.producerProperties.getPartitionCount();
        }

        public void setPartitionCount(int partitionCount) {
            this.producerProperties.setPartitionCount(partitionCount);
        }

        public String[] getRequiredGroups() {
            return this.producerProperties.getRequiredGroups();
        }

        public void setRequiredGroups(String ... requiredGroups) {
            this.producerProperties.setRequiredGroups(requiredGroups);
        }

        @AssertTrue(message="Partition key expression and partition key extractor class properties are mutually exclusive.")
        public @AssertTrue(message="Partition key expression and partition key extractor class properties are mutually exclusive.") boolean isValidPartitionKeyProperty() {
            return this.producerProperties.isValidPartitionKeyProperty();
        }

        @AssertTrue(message="Partition selector class and partition selector expression properties are mutually exclusive.")
        public @AssertTrue(message="Partition selector class and partition selector expression properties are mutually exclusive.") boolean isValidPartitionSelectorProperty() {
            return this.producerProperties.isValidPartitionSelectorProperty();
        }

        public HeaderMode getHeaderMode() {
            return this.producerProperties.getHeaderMode();
        }

        public void setHeaderMode(HeaderMode headerMode) {
            this.producerProperties.setHeaderMode(headerMode);
        }

        public boolean isUseNativeEncoding() {
            return this.producerProperties.isUseNativeEncoding();
        }

        public void setUseNativeEncoding(boolean useNativeEncoding) {
            this.producerProperties.setUseNativeEncoding(useNativeEncoding);
        }

        public boolean isErrorChannelEnabled() {
            return this.producerProperties.isErrorChannelEnabled();
        }

        public void setErrorChannelEnabled(boolean errorChannelEnabled) {
            this.producerProperties.setErrorChannelEnabled(errorChannelEnabled);
        }

        public String getPartitionKeyExtractorName() {
            return this.producerProperties.getPartitionKeyExtractorName();
        }

        public void setPartitionKeyExtractorName(String partitionKeyExtractorName) {
            this.producerProperties.setPartitionKeyExtractorName(partitionKeyExtractorName);
        }

        public String getPartitionSelectorName() {
            return this.producerProperties.getPartitionSelectorName();
        }

        public void setPartitionSelectorName(String partitionSelectorName) {
            this.producerProperties.setPartitionSelectorName(partitionSelectorName);
        }

        public int getBufferSize() {
            return this.kafkaProducerProperties.getBufferSize();
        }

        public void setBufferSize(int bufferSize) {
            this.kafkaProducerProperties.setBufferSize(bufferSize);
        }

        @NotNull
        public KafkaProducerProperties.CompressionType getCompressionType() {
            return this.kafkaProducerProperties.getCompressionType();
        }

        public void setCompressionType(KafkaProducerProperties.CompressionType compressionType) {
            this.kafkaProducerProperties.setCompressionType(compressionType);
        }

        public boolean isSync() {
            return this.kafkaProducerProperties.isSync();
        }

        public void setSync(boolean sync) {
            this.kafkaProducerProperties.setSync(sync);
        }

        public int getBatchTimeout() {
            return this.kafkaProducerProperties.getBatchTimeout();
        }

        public void setBatchTimeout(int batchTimeout) {
            this.kafkaProducerProperties.setBatchTimeout(batchTimeout);
        }

        public Expression getMessageKeyExpression() {
            return this.kafkaProducerProperties.getMessageKeyExpression();
        }

        public void setMessageKeyExpression(Expression messageKeyExpression) {
            this.kafkaProducerProperties.setMessageKeyExpression(messageKeyExpression);
        }

        public String[] getHeaderPatterns() {
            return this.kafkaProducerProperties.getHeaderPatterns();
        }

        public void setHeaderPatterns(String[] headerPatterns) {
            this.kafkaProducerProperties.setHeaderPatterns(headerPatterns);
        }

        public Map<String, String> getConfiguration() {
            return this.kafkaProducerProperties.getConfiguration();
        }

        public void setConfiguration(Map<String, String> configuration) {
            this.kafkaProducerProperties.setConfiguration(configuration);
        }

        public KafkaTopicProperties getTopic() {
            return this.kafkaProducerProperties.getTopic();
        }

        public void setTopic(KafkaTopicProperties topic) {
            this.kafkaProducerProperties.setTopic(topic);
        }

        public KafkaProducerProperties getExtension() {
            return this.kafkaProducerProperties;
        }
    }

    public static class Transaction {
        private final CombinedProducerProperties producer = new CombinedProducerProperties();
        private String transactionIdPrefix;

        public String getTransactionIdPrefix() {
            return this.transactionIdPrefix;
        }

        public void setTransactionIdPrefix(String transactionIdPrefix) {
            this.transactionIdPrefix = transactionIdPrefix;
        }

        public CombinedProducerProperties getProducer() {
            return this.producer;
        }
    }
}

