/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.utils;

import org.apache.commons.logging.Log;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.lang.Nullable;

@FunctionalInterface
public interface DlqPartitionFunction {
    public static final DlqPartitionFunction ORIGINAL_PARTITION = (group, rec, ex) -> rec.partition();
    public static final DlqPartitionFunction PARTITION_ZERO = (group, rec, ex) -> 0;

    @Nullable
    public Integer apply(String var1, ConsumerRecord<?, ?> var2, Throwable var3);

    public static DlqPartitionFunction determineFallbackFunction(@Nullable Integer dlqPartitions, Log logger) {
        if (dlqPartitions == null) {
            return ORIGINAL_PARTITION;
        }
        if (dlqPartitions > 1) {
            logger.error((Object)"'dlqPartitions' is > 1 but a custom DlqPartitionFunction bean is not provided");
            return ORIGINAL_PARTITION;
        }
        return PARTITION_ZERO;
    }
}

