/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.ldap;

import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.security.config.ldap.AbstractLdapAuthenticationManagerFactory;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.ldap.authentication.PasswordComparisonAuthenticator;
import org.springframework.util.Assert;

public class LdapPasswordComparisonAuthenticationManagerFactory
extends AbstractLdapAuthenticationManagerFactory<PasswordComparisonAuthenticator> {
    private PasswordEncoder passwordEncoder;
    private String passwordAttribute;

    public LdapPasswordComparisonAuthenticationManagerFactory(BaseLdapPathContextSource contextSource, PasswordEncoder passwordEncoder) {
        super(contextSource);
        this.setPasswordEncoder(passwordEncoder);
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        Assert.notNull((Object)passwordEncoder, (String)"passwordEncoder must not be null.");
        this.passwordEncoder = passwordEncoder;
    }

    public void setPasswordAttribute(String passwordAttribute) {
        this.passwordAttribute = passwordAttribute;
    }

    @Override
    protected PasswordComparisonAuthenticator createDefaultLdapAuthenticator() {
        PasswordComparisonAuthenticator ldapAuthenticator = new PasswordComparisonAuthenticator(this.getContextSource());
        if (this.passwordAttribute != null) {
            ldapAuthenticator.setPasswordAttributeName(this.passwordAttribute);
        }
        ldapAuthenticator.setPasswordEncoder(this.passwordEncoder);
        return ldapAuthenticator;
    }
}

