/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authentication;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import org.springframework.security.authentication.AuthenticationObservationContext;
import org.springframework.security.authentication.AuthenticationObservationConvention;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import reactor.core.publisher.Mono;

public class ObservationReactiveAuthenticationManager
implements ReactiveAuthenticationManager {
    private final ObservationRegistry registry;
    private final ReactiveAuthenticationManager delegate;
    private final AuthenticationObservationConvention convention = new AuthenticationObservationConvention();

    public ObservationReactiveAuthenticationManager(ObservationRegistry registry, ReactiveAuthenticationManager delegate) {
        this.registry = registry;
        this.delegate = delegate;
    }

    @Override
    public Mono<Authentication> authenticate(Authentication authentication) throws AuthenticationException {
        AuthenticationObservationContext context = new AuthenticationObservationContext();
        context.setAuthenticationRequest(authentication);
        context.setAuthenticationManagerClass(this.delegate.getClass());
        Observation observation = Observation.createNotStarted((ObservationConvention)this.convention, () -> context, (ObservationRegistry)this.registry).start();
        return this.delegate.authenticate(authentication).doOnSuccess(result -> {
            context.setAuthenticationResult((Authentication)result);
            observation.stop();
        }).doOnCancel(() -> ((Observation)observation).stop()).doOnError(t -> {
            observation.error(t);
            observation.stop();
        });
    }
}

