/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.access.expression;

import java.io.Serializable;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.access.expression.DenyAllPermissionEvaluator;
import org.springframework.security.access.expression.SecurityExpressionOperations;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.AuthorizationManagerFactory;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.authorization.DefaultAuthorizationManagerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;
import org.springframework.util.function.SingletonSupplier;

public abstract class SecurityExpressionRoot<T>
implements SecurityExpressionOperations {
    private final Supplier<Authentication> authentication;
    private String defaultRolePrefix = "ROLE_";
    private final T object;
    private AuthorizationManagerFactory<T> authorizationManagerFactory = new DefaultAuthorizationManagerFactory();
    public final boolean permitAll = true;
    public final boolean denyAll = false;
    private PermissionEvaluator permissionEvaluator = new DenyAllPermissionEvaluator();
    public final String read = "read";
    public final String write = "write";
    public final String create = "create";
    public final String delete = "delete";
    public final String admin = "administration";

    @Deprecated(since="7.0")
    public SecurityExpressionRoot(@Nullable Authentication authentication) {
        this(() -> authentication, null);
    }

    @Deprecated(since="7.0")
    public SecurityExpressionRoot(Supplier<@Nullable Authentication> authentication) {
        this(authentication, null);
    }

    public SecurityExpressionRoot(Supplier<? extends @Nullable Authentication> authentication, T object) {
        this.authentication = SingletonSupplier.of(() -> {
            Authentication value = (Authentication)authentication.get();
            Assert.notNull((Object)value, (String)"Authentication object cannot be null");
            return value;
        });
        this.object = object;
    }

    @Override
    public final boolean hasAuthority(String authority) {
        return this.isGranted(this.authorizationManagerFactory.hasAnyAuthority(authority));
    }

    @Override
    public final boolean hasAnyAuthority(String ... authorities) {
        return this.isGranted(this.authorizationManagerFactory.hasAnyAuthority(authorities));
    }

    public final boolean hasAllAuthorities(String ... authorities) {
        AuthorizationManager<T> manager = this.authorizationManagerFactory.hasAllAuthorities(authorities);
        return this.isGranted(manager);
    }

    @Override
    public final boolean hasRole(String role) {
        String rolePrefix;
        if (this.authorizationManagerFactory instanceof DefaultAuthorizationManagerFactory && role.startsWith(rolePrefix = this.defaultRolePrefix)) {
            role = role.substring(rolePrefix.length());
        }
        return this.isGranted(this.authorizationManagerFactory.hasRole(role));
    }

    @Override
    public final boolean hasAnyRole(String ... roles) {
        if (this.authorizationManagerFactory instanceof DefaultAuthorizationManagerFactory) {
            String rolePrefix = this.defaultRolePrefix;
            for (int index = 0; index < roles.length; ++index) {
                String role = roles[index];
                if (!role.startsWith(rolePrefix)) continue;
                roles[index] = role.substring(rolePrefix.length());
            }
        }
        return this.isGranted(this.authorizationManagerFactory.hasAnyRole(roles));
    }

    public final boolean hasAllRoles(String ... roles) {
        AuthorizationManager<T> manager = this.authorizationManagerFactory.hasAllRoles(roles);
        return this.isGranted(manager);
    }

    @Override
    public final Authentication getAuthentication() {
        return this.authentication.get();
    }

    @Override
    public final boolean permitAll() {
        return this.isGranted(this.authorizationManagerFactory.permitAll());
    }

    @Override
    public final boolean denyAll() {
        return this.isGranted(this.authorizationManagerFactory.denyAll());
    }

    @Override
    public final boolean isAnonymous() {
        return this.isGranted(this.authorizationManagerFactory.anonymous());
    }

    @Override
    public final boolean isAuthenticated() {
        return this.isGranted(this.authorizationManagerFactory.authenticated());
    }

    @Override
    public final boolean isRememberMe() {
        return this.isGranted(this.authorizationManagerFactory.rememberMe());
    }

    @Override
    public final boolean isFullyAuthenticated() {
        return this.isGranted(this.authorizationManagerFactory.fullyAuthenticated());
    }

    private boolean isGranted(AuthorizationManager<T> authorizationManager) {
        AuthorizationResult authorizationResult = authorizationManager.authorize(this.authentication, this.object);
        return authorizationResult != null && authorizationResult.isGranted();
    }

    public @Nullable Object getPrincipal() {
        return this.getAuthentication().getPrincipal();
    }

    @Deprecated(since="7.0")
    public void setTrustResolver(AuthenticationTrustResolver trustResolver) {
        this.getDefaultAuthorizationManagerFactory().setTrustResolver(trustResolver);
    }

    @Deprecated(since="7.0")
    public void setRoleHierarchy(@Nullable RoleHierarchy roleHierarchy) {
        if (roleHierarchy != null) {
            this.getDefaultAuthorizationManagerFactory().setRoleHierarchy(roleHierarchy);
        }
    }

    @Deprecated(since="7.0")
    public void setDefaultRolePrefix(@Nullable String defaultRolePrefix) {
        if (defaultRolePrefix == null) {
            defaultRolePrefix = "";
        }
        this.getDefaultAuthorizationManagerFactory().setRolePrefix(defaultRolePrefix);
        this.defaultRolePrefix = defaultRolePrefix;
    }

    public void setAuthorizationManagerFactory(AuthorizationManagerFactory<T> authorizationManagerFactory) {
        Assert.notNull(authorizationManagerFactory, (String)"authorizationManagerFactory cannot be null");
        this.authorizationManagerFactory = authorizationManagerFactory;
    }

    @Deprecated(since="7.0", forRemoval=true)
    private DefaultAuthorizationManagerFactory<T> getDefaultAuthorizationManagerFactory() {
        AuthorizationManagerFactory<T> authorizationManagerFactory = this.authorizationManagerFactory;
        if (!(authorizationManagerFactory instanceof DefaultAuthorizationManagerFactory)) {
            throw new IllegalStateException("authorizationManagerFactory must be an instance of DefaultAuthorizationManagerFactory");
        }
        DefaultAuthorizationManagerFactory defaultAuthorizationManagerFactory = (DefaultAuthorizationManagerFactory)authorizationManagerFactory;
        return defaultAuthorizationManagerFactory;
    }

    @Override
    public boolean hasPermission(Object target, Object permission) {
        return this.permissionEvaluator.hasPermission(this.getAuthentication(), target, permission);
    }

    @Override
    public boolean hasPermission(Object targetId, String targetType, Object permission) {
        return this.permissionEvaluator.hasPermission(this.getAuthentication(), (Serializable)targetId, targetType, permission);
    }

    public void setPermissionEvaluator(PermissionEvaluator permissionEvaluator) {
        Assert.notNull((Object)permissionEvaluator, (String)"permissionEvaluator cannot be null");
        this.permissionEvaluator = permissionEvaluator;
    }
}

