/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authentication;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.security.core.AuthenticatedPrincipal;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.CredentialsContainer;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.Assert;

public abstract class AbstractAuthenticationToken
implements Authentication,
CredentialsContainer {
    private static final long serialVersionUID = -3194696462184782834L;
    private final Collection<GrantedAuthority> authorities;
    private @Nullable Object details;
    private boolean authenticated = false;

    public AbstractAuthenticationToken(@Nullable Collection<? extends GrantedAuthority> authorities) {
        if (authorities == null) {
            this.authorities = AuthorityUtils.NO_AUTHORITIES;
            return;
        }
        for (GrantedAuthority grantedAuthority : authorities) {
            Assert.notNull((Object)grantedAuthority, (String)"Authorities collection cannot contain any null elements");
        }
        this.authorities = Collections.unmodifiableList(new ArrayList<GrantedAuthority>(authorities));
    }

    protected AbstractAuthenticationToken(AbstractAuthenticationBuilder<?> builder) {
        this(builder.authorities);
        this.authenticated = builder.authenticated;
        this.details = builder.details;
    }

    public Collection<GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    @Override
    public String getName() {
        Object object = this.getPrincipal();
        if (object instanceof UserDetails) {
            UserDetails userDetails = (UserDetails)object;
            return userDetails.getUsername();
        }
        object = this.getPrincipal();
        if (object instanceof AuthenticatedPrincipal) {
            AuthenticatedPrincipal authenticatedPrincipal = (AuthenticatedPrincipal)object;
            return authenticatedPrincipal.getName();
        }
        object = this.getPrincipal();
        if (object instanceof Principal) {
            Principal principal = (Principal)object;
            return principal.getName();
        }
        return this.getPrincipal() == null ? "" : this.getPrincipal().toString();
    }

    @Override
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    @Override
    public void setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
    }

    @Override
    public @Nullable Object getDetails() {
        return this.details;
    }

    public void setDetails(@Nullable Object details) {
        this.details = details;
    }

    @Override
    public void eraseCredentials() {
        this.eraseSecret(this.getCredentials());
        this.eraseSecret(this.getPrincipal());
        this.eraseSecret(this.details);
    }

    private void eraseSecret(@Nullable Object secret) {
        if (secret instanceof CredentialsContainer) {
            CredentialsContainer container = (CredentialsContainer)secret;
            container.eraseCredentials();
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractAuthenticationToken)) {
            return false;
        }
        AbstractAuthenticationToken test = (AbstractAuthenticationToken)obj;
        if (!this.authorities.equals(test.authorities)) {
            return false;
        }
        if (this.details == null && test.getDetails() != null) {
            return false;
        }
        if (this.details != null && test.getDetails() == null) {
            return false;
        }
        if (this.details != null && !this.details.equals(test.getDetails())) {
            return false;
        }
        if (this.getCredentials() == null && test.getCredentials() != null) {
            return false;
        }
        if (this.getCredentials() != null && !this.getCredentials().equals(test.getCredentials())) {
            return false;
        }
        if (this.getPrincipal() == null && test.getPrincipal() != null) {
            return false;
        }
        if (this.getPrincipal() != null && !this.getPrincipal().equals(test.getPrincipal())) {
            return false;
        }
        return this.isAuthenticated() == test.isAuthenticated();
    }

    @Override
    public int hashCode() {
        int code = 31;
        for (GrantedAuthority authority : this.authorities) {
            code ^= authority.hashCode();
        }
        if (this.getPrincipal() != null) {
            code ^= this.getPrincipal().hashCode();
        }
        if (this.getCredentials() != null) {
            code ^= this.getCredentials().hashCode();
        }
        if (this.getDetails() != null) {
            code ^= this.getDetails().hashCode();
        }
        if (this.isAuthenticated()) {
            code ^= 0xFFFFFFDB;
        }
        return code;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append(" [");
        sb.append("Principal=").append(this.getPrincipal()).append(", ");
        sb.append("Credentials=[PROTECTED], ");
        sb.append("Authenticated=").append(this.isAuthenticated()).append(", ");
        sb.append("Details=").append(this.getDetails()).append(", ");
        sb.append("Granted Authorities=").append(this.authorities);
        sb.append("]");
        return sb.toString();
    }

    protected static abstract class AbstractAuthenticationBuilder<B extends AbstractAuthenticationBuilder<B>>
    implements Authentication.Builder<B> {
        private boolean authenticated;
        private @Nullable Object details;
        private final Collection<GrantedAuthority> authorities;

        protected AbstractAuthenticationBuilder(AbstractAuthenticationToken token) {
            this.authorities = new LinkedHashSet<GrantedAuthority>(token.getAuthorities());
            this.authenticated = token.isAuthenticated();
            this.details = token.getDetails();
        }

        @Override
        public B authenticated(boolean authenticated) {
            this.authenticated = authenticated;
            return (B)this;
        }

        @Override
        public B details(@Nullable Object details) {
            this.details = details;
            return (B)this;
        }

        @Override
        public B authorities(Consumer<Collection<GrantedAuthority>> authorities) {
            authorities.accept(this.authorities);
            this.authenticated = true;
            return (B)this;
        }
    }
}

