/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authentication.ott;

import java.util.HashSet;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.ott.InvalidOneTimeTokenException;
import org.springframework.security.authentication.ott.OneTimeToken;
import org.springframework.security.authentication.ott.OneTimeTokenAuthentication;
import org.springframework.security.authentication.ott.OneTimeTokenAuthenticationToken;
import org.springframework.security.authentication.ott.OneTimeTokenService;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.FactorGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.Assert;

public final class OneTimeTokenAuthenticationProvider
implements AuthenticationProvider {
    private static final String AUTHORITY = "FACTOR_OTT";
    private final OneTimeTokenService oneTimeTokenService;
    private final UserDetailsService userDetailsService;

    public OneTimeTokenAuthenticationProvider(OneTimeTokenService oneTimeTokenService, UserDetailsService userDetailsService) {
        Assert.notNull((Object)oneTimeTokenService, (String)"oneTimeTokenService cannot be null");
        Assert.notNull((Object)userDetailsService, (String)"userDetailsService cannot be null");
        this.userDetailsService = userDetailsService;
        this.oneTimeTokenService = oneTimeTokenService;
    }

    @Override
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        OneTimeTokenAuthenticationToken otpAuthenticationToken = (OneTimeTokenAuthenticationToken)authentication;
        OneTimeToken consumed = this.oneTimeTokenService.consume(otpAuthenticationToken);
        if (consumed == null) {
            throw new InvalidOneTimeTokenException("Invalid token");
        }
        try {
            UserDetails user = this.userDetailsService.loadUserByUsername(consumed.getUsername());
            HashSet<? extends GrantedAuthority> authorities = new HashSet<GrantedAuthority>(user.getAuthorities());
            authorities.add(FactorGrantedAuthority.fromAuthority(AUTHORITY));
            OneTimeTokenAuthentication authenticated = new OneTimeTokenAuthentication(user, authorities);
            authenticated.setDetails(otpAuthenticationToken.getDetails());
            return authenticated;
        }
        catch (UsernameNotFoundException ex) {
            throw new BadCredentialsException("Failed to authenticate the one-time token");
        }
    }

    @Override
    public boolean supports(Class<?> authentication) {
        return OneTimeTokenAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

