/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization;

import java.time.Duration;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;

public final class RequiredFactor {
    private final String authority;
    private final @Nullable Duration validDuration;

    private RequiredFactor(String authority, @Nullable Duration validDuration) {
        Assert.notNull((Object)authority, (String)"authority cannot be null");
        this.authority = authority;
        this.validDuration = validDuration;
    }

    public String getAuthority() {
        return this.authority;
    }

    public @Nullable Duration getValidDuration() {
        return this.validDuration;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RequiredFactor)) {
            return false;
        }
        RequiredFactor that = (RequiredFactor)o;
        return Objects.equals(this.authority, that.authority) && Objects.equals(this.validDuration, that.validDuration);
    }

    public int hashCode() {
        return Objects.hash(this.authority, this.validDuration);
    }

    public String toString() {
        return "RequiredFactor [authority=" + this.authority + ", validDuration=" + String.valueOf(this.validDuration) + "]";
    }

    public static Builder withAuthority(String authority) {
        return RequiredFactor.builder().authority(authority);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private @Nullable String authority;
        private @Nullable Duration validDuration;

        public Builder authority(String authority) {
            this.authority = authority;
            return this;
        }

        public Builder authorizationCodeAuthority() {
            return this.authority("FACTOR_AUTHORIZATION_CODE");
        }

        public Builder bearerTokenAuthority() {
            return this.authority("FACTOR_BEARER");
        }

        public Builder casAuthority() {
            return this.authority("FACTOR_CAS");
        }

        public Builder passwordAuthority() {
            return this.authority("FACTOR_PASSWORD");
        }

        public Builder ottAuthority() {
            return this.authority("FACTOR_OTT");
        }

        public Builder samlAuthority() {
            return this.authority("FACTOR_SAML_RESPONSE");
        }

        public Builder webauthnAuthority() {
            return this.authority("FACTOR_WEBAUTHN");
        }

        public Builder x509Authority() {
            return this.authority("FACTOR_X509");
        }

        public Builder validDuration(Duration validDuration) {
            this.validDuration = validDuration;
            return this;
        }

        public RequiredFactor build() {
            Assert.notNull((Object)this.authority, (String)"authority cannot be null");
            return new RequiredFactor(this.authority, this.validDuration);
        }
    }
}

