/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization;

import java.util.Objects;
import org.springframework.security.authorization.RequiredFactor;
import org.springframework.util.Assert;

public class RequiredFactorError {
    private final RequiredFactor requiredFactor;
    private final Reason reason;

    RequiredFactorError(RequiredFactor requiredFactor, Reason reason) {
        Assert.notNull((Object)requiredFactor, (String)"RequiredFactor must not be null");
        Assert.notNull((Object)((Object)reason), (String)"Reason must not be null");
        if (reason == Reason.EXPIRED && requiredFactor.getValidDuration() == null) {
            throw new IllegalArgumentException("If expired, RequiredFactor.getValidDuration() must not be null. Got " + String.valueOf(requiredFactor));
        }
        this.requiredFactor = requiredFactor;
        this.reason = reason;
    }

    public RequiredFactor getRequiredFactor() {
        return this.requiredFactor;
    }

    public boolean isExpired() {
        return this.reason == Reason.EXPIRED;
    }

    public boolean isMissing() {
        return this.reason == Reason.MISSING;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequiredFactorError that = (RequiredFactorError)o;
        return Objects.equals(this.requiredFactor, that.requiredFactor) && this.reason == that.reason;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.requiredFactor, this.reason});
    }

    public String toString() {
        return "RequiredFactorError{requiredFactor=" + String.valueOf(this.requiredFactor) + ", reason=" + String.valueOf((Object)this.reason) + "}";
    }

    public static RequiredFactorError createMissing(RequiredFactor requiredFactor) {
        return new RequiredFactorError(requiredFactor, Reason.MISSING);
    }

    public static RequiredFactorError createExpired(RequiredFactor requiredFactor) {
        return new RequiredFactorError(requiredFactor, Reason.EXPIRED);
    }

    private static enum Reason {
        MISSING,
        EXPIRED;

    }
}

