/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization;

import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.security.authorization.AuthorizationEventPublisher;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.authorization.event.AuthorizationDeniedEvent;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;

public final class SpringAuthorizationEventPublisher
implements AuthorizationEventPublisher {
    private final ApplicationEventPublisher eventPublisher;
    private Predicate<AuthorizationResult> shouldPublishResult = result -> !result.isGranted();

    public SpringAuthorizationEventPublisher(ApplicationEventPublisher eventPublisher) {
        Assert.notNull((Object)eventPublisher, (String)"eventPublisher cannot be null");
        this.eventPublisher = eventPublisher;
    }

    @Override
    public <T> void publishAuthorizationEvent(Supplier<Authentication> authentication, T object, @Nullable AuthorizationResult result) {
        if (result == null) {
            return;
        }
        if (!this.shouldPublishResult.test(result)) {
            return;
        }
        AuthorizationDeniedEvent<T> failure = new AuthorizationDeniedEvent<T>(authentication, object, result);
        this.eventPublisher.publishEvent(failure);
    }

    public void setShouldPublishResult(Predicate<AuthorizationResult> shouldPublishResult) {
        Assert.notNull(shouldPublishResult, (String)"shouldPublishResult cannot be null");
        this.shouldPublishResult = shouldPublishResult;
    }
}

