/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization.event;

import java.util.function.Supplier;
import org.springframework.context.ApplicationEvent;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;

public class AuthorizationEvent
extends ApplicationEvent {
    private static final long serialVersionUID = -9053927371500241295L;
    private final Supplier<Authentication> authentication;
    private final AuthorizationResult result;

    public AuthorizationEvent(Supplier<Authentication> authentication, Object object, AuthorizationDecision result) {
        super(object);
        Assert.notNull(authentication, (String)"authentication supplier cannot be null");
        this.authentication = authentication;
        this.result = result;
    }

    public AuthorizationEvent(Supplier<Authentication> authentication, Object object, AuthorizationResult result) {
        super(object);
        Assert.notNull(authentication, (String)"authentication supplier cannot be null");
        this.authentication = authentication;
        this.result = result;
    }

    public Supplier<Authentication> getAuthentication() {
        return this.authentication;
    }

    public Object getObject() {
        return this.getSource();
    }

    public AuthorizationResult getAuthorizationResult() {
        return this.result;
    }
}

