/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization.method;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInvocation;
import org.jspecify.annotations.Nullable;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.framework.AopInfrastructureBean;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.security.authorization.AuthorizationProxyFactory;
import org.springframework.security.authorization.method.AuthorizationAdvisor;
import org.springframework.security.authorization.method.AuthorizationManagerAfterMethodInterceptor;
import org.springframework.security.authorization.method.AuthorizationManagerAfterReactiveMethodInterceptor;
import org.springframework.security.authorization.method.AuthorizationManagerBeforeMethodInterceptor;
import org.springframework.security.authorization.method.AuthorizationManagerBeforeReactiveMethodInterceptor;
import org.springframework.security.authorization.method.AuthorizationProxy;
import org.springframework.security.authorization.method.AuthorizeReturnObjectMethodInterceptor;
import org.springframework.security.authorization.method.PostFilterAuthorizationMethodInterceptor;
import org.springframework.security.authorization.method.PostFilterAuthorizationReactiveMethodInterceptor;
import org.springframework.security.authorization.method.PreFilterAuthorizationMethodInterceptor;
import org.springframework.security.authorization.method.PreFilterAuthorizationReactiveMethodInterceptor;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class AuthorizationAdvisorProxyFactory
implements AuthorizationProxyFactory,
Iterable<AuthorizationAdvisor>,
AopInfrastructureBean,
SmartInitializingSingleton {
    private static final boolean isReactivePresent = ClassUtils.isPresent((String)"reactor.core.publisher.Mono", null);
    private static final TargetVisitor DEFAULT_VISITOR = isReactivePresent ? TargetVisitor.of(new ClassVisitor(), new ReactiveTypeVisitor(), new ContainerTypeVisitor()) : TargetVisitor.of(new ClassVisitor(), new ContainerTypeVisitor());
    private static final TargetVisitor DEFAULT_VISITOR_SKIP_VALUE_TYPES = TargetVisitor.of(new ClassVisitor(), new IgnoreValueTypeVisitor(), DEFAULT_VISITOR);
    private final AuthorizationProxyMethodInterceptor authorizationProxy = new AuthorizationProxyMethodInterceptor();
    private List<AuthorizationAdvisor> advisors;
    private TargetVisitor visitor = DEFAULT_VISITOR;

    public AuthorizationAdvisorProxyFactory(List<AuthorizationAdvisor> advisors) {
        this.advisors = new ArrayList<AuthorizationAdvisor>(advisors);
        for (AuthorizationAdvisor advisor : this.advisors) {
            if (!(advisor instanceof AuthorizeReturnObjectMethodInterceptor)) continue;
            AuthorizeReturnObjectMethodInterceptor interceptor = (AuthorizeReturnObjectMethodInterceptor)advisor;
            interceptor.setAuthorizationProxyFactory(this);
        }
    }

    public static AuthorizationAdvisorProxyFactory withDefaults() {
        ArrayList<AuthorizationAdvisor> advisors = new ArrayList<AuthorizationAdvisor>();
        advisors.add(AuthorizationManagerBeforeMethodInterceptor.preAuthorize());
        advisors.add(AuthorizationManagerAfterMethodInterceptor.postAuthorize());
        advisors.add(new PreFilterAuthorizationMethodInterceptor());
        advisors.add(new PostFilterAuthorizationMethodInterceptor());
        advisors.add(new AuthorizeReturnObjectMethodInterceptor());
        AuthorizationAdvisorProxyFactory proxyFactory = new AuthorizationAdvisorProxyFactory(advisors);
        AnnotationAwareOrderComparator.sort(proxyFactory.advisors);
        return proxyFactory;
    }

    public static AuthorizationAdvisorProxyFactory withReactiveDefaults() {
        ArrayList<AuthorizationAdvisor> advisors = new ArrayList<AuthorizationAdvisor>();
        advisors.add(AuthorizationManagerBeforeReactiveMethodInterceptor.preAuthorize());
        advisors.add(AuthorizationManagerAfterReactiveMethodInterceptor.postAuthorize());
        advisors.add(new PreFilterAuthorizationReactiveMethodInterceptor());
        advisors.add(new PostFilterAuthorizationReactiveMethodInterceptor());
        advisors.add(new AuthorizeReturnObjectMethodInterceptor());
        AuthorizationAdvisorProxyFactory proxyFactory = new AuthorizationAdvisorProxyFactory(advisors);
        AnnotationAwareOrderComparator.sort(proxyFactory.advisors);
        return proxyFactory;
    }

    public void afterSingletonsInstantiated() {
        AnnotationAwareOrderComparator.sort(this.advisors);
    }

    @Override
    public <T> @Nullable T proxy(@Nullable T target) {
        if (target == null) {
            return null;
        }
        if (target instanceof AuthorizationProxy) {
            AuthorizationProxy proxied = (AuthorizationProxy)target;
            return (T)proxied;
        }
        Object proxied = this.visitor.visit(this, target);
        if (proxied != null) {
            return (T)proxied;
        }
        ProxyFactory factory = new ProxyFactory(target);
        factory.addAdvisors(new Advisor[]{this.authorizationProxy});
        ArrayList<AuthorizationAdvisor> advisors = new ArrayList<AuthorizationAdvisor>(this.advisors);
        AnnotationAwareOrderComparator.sort(advisors);
        factory.addAdvisors(advisors);
        factory.addInterface(AuthorizationProxy.class);
        factory.setOpaque(true);
        factory.setProxyTargetClass(!Modifier.isFinal(target.getClass().getModifiers()));
        return (T)factory.getProxy();
    }

    @Deprecated
    public void setAdvisors(AuthorizationAdvisor ... advisors) {
        this.advisors = new ArrayList<AuthorizationAdvisor>(List.of(advisors));
    }

    @Deprecated
    public void setAdvisors(Collection<AuthorizationAdvisor> advisors) {
        this.advisors = new ArrayList<AuthorizationAdvisor>(advisors);
    }

    @Deprecated
    public void addAdvisor(AuthorizationAdvisor advisor) {
        this.advisors.add(advisor);
    }

    public void setTargetVisitor(TargetVisitor visitor) {
        Assert.notNull((Object)visitor, (String)"delegate cannot be null");
        this.visitor = visitor;
    }

    @Override
    public Iterator<AuthorizationAdvisor> iterator() {
        return this.advisors.iterator();
    }

    private static final class AuthorizationProxyMethodInterceptor
    implements AuthorizationAdvisor {
        private static final Method GET_TARGET_METHOD = ClassUtils.getMethod(AuthorizationProxy.class, (String)"toAuthorizedTarget", (Class[])new Class[0]);

        private AuthorizationProxyMethodInterceptor() {
        }

        public @Nullable Object invoke(MethodInvocation invocation) throws Throwable {
            if (invocation.getMethod().equals(GET_TARGET_METHOD)) {
                return invocation.getThis();
            }
            return invocation.proceed();
        }

        public Pointcut getPointcut() {
            return Pointcut.TRUE;
        }

        public Advice getAdvice() {
            return this;
        }

        public int getOrder() {
            return 0;
        }
    }

    public static interface TargetVisitor {
        public @Nullable Object visit(AuthorizationAdvisorProxyFactory var1, Object var2);

        public static TargetVisitor defaults() {
            return DEFAULT_VISITOR;
        }

        public static TargetVisitor defaultsSkipValueTypes() {
            return DEFAULT_VISITOR_SKIP_VALUE_TYPES;
        }

        public static TargetVisitor of(TargetVisitor ... visitors) {
            return (proxyFactory, target) -> {
                for (TargetVisitor visitor : visitors) {
                    Object result = visitor.visit(proxyFactory, target);
                    if (result == null) continue;
                    return result;
                }
                return null;
            };
        }
    }

    private static final class ClassVisitor
    implements TargetVisitor {
        private final AuthorizationProxyMethodInterceptor authorizationProxy = new AuthorizationProxyMethodInterceptor();

        private ClassVisitor() {
        }

        @Override
        public @Nullable Object visit(AuthorizationAdvisorProxyFactory proxyFactory, Object object) {
            if (object instanceof Class) {
                Class targetClass = (Class)object;
                if (AuthorizationProxy.class.isAssignableFrom(targetClass)) {
                    return targetClass;
                }
                ProxyFactory factory = new ProxyFactory();
                factory.setTargetClass(targetClass);
                factory.setInterfaces(ClassUtils.getAllInterfacesForClass((Class)targetClass));
                factory.setOpaque(true);
                factory.setProxyTargetClass(!Modifier.isFinal(targetClass.getModifiers()));
                factory.addAdvisor((Advisor)this.authorizationProxy);
                for (Advisor advisor : proxyFactory) {
                    factory.addAdvisors(new Advisor[]{advisor});
                }
                factory.addInterface(AuthorizationProxy.class);
                return factory.getProxyClass(this.getClass().getClassLoader());
            }
            return null;
        }
    }

    private static class ReactiveTypeVisitor
    implements TargetVisitor {
        private ReactiveTypeVisitor() {
        }

        @Override
        public @Nullable Object visit(AuthorizationAdvisorProxyFactory proxyFactory, Object target) {
            if (target instanceof Mono) {
                Mono mono = (Mono)target;
                return this.proxyMono(proxyFactory, mono);
            }
            if (target instanceof Flux) {
                Flux flux = (Flux)target;
                return this.proxyFlux(proxyFactory, flux);
            }
            return null;
        }

        private Mono<?> proxyMono(AuthorizationProxyFactory proxyFactory, Mono<?> mono) {
            return mono.mapNotNull(proxyFactory::proxy);
        }

        private Flux<?> proxyFlux(AuthorizationProxyFactory proxyFactory, Flux<?> flux) {
            return flux.mapNotNull(proxyFactory::proxy);
        }
    }

    private static final class ContainerTypeVisitor
    implements TargetVisitor {
        private ContainerTypeVisitor() {
        }

        @Override
        public @Nullable Object visit(AuthorizationAdvisorProxyFactory proxyFactory, Object target) {
            if (target instanceof Iterator) {
                Iterator iterator = (Iterator)target;
                return this.proxyIterator(proxyFactory, iterator);
            }
            if (target instanceof Queue) {
                Queue queue = (Queue)target;
                return this.proxyQueue(proxyFactory, queue);
            }
            if (target instanceof List) {
                List list = (List)target;
                return this.proxyList(proxyFactory, list);
            }
            if (target instanceof SortedSet) {
                SortedSet set = (SortedSet)target;
                return this.proxySortedSet(proxyFactory, set);
            }
            if (target instanceof Set) {
                Set set = (Set)target;
                return this.proxySet(proxyFactory, set);
            }
            if (target.getClass().isArray()) {
                return this.proxyArray(proxyFactory, (Object[])target);
            }
            if (target instanceof SortedMap) {
                SortedMap map = (SortedMap)target;
                return this.proxySortedMap(proxyFactory, map);
            }
            if (target instanceof Iterable) {
                Iterable iterable = (Iterable)target;
                return this.proxyIterable(proxyFactory, iterable);
            }
            if (target instanceof Map) {
                Map map = (Map)target;
                return this.proxyMap(proxyFactory, map);
            }
            if (target instanceof Stream) {
                Stream stream = (Stream)target;
                return this.proxyStream(proxyFactory, stream);
            }
            if (target instanceof Optional) {
                Optional optional = (Optional)target;
                return this.proxyOptional(proxyFactory, optional);
            }
            if (target instanceof Supplier) {
                Supplier supplier = (Supplier)target;
                return this.proxySupplier(proxyFactory, supplier);
            }
            return null;
        }

        private <T> @Nullable T proxyCast(AuthorizationProxyFactory proxyFactory, T target) {
            return proxyFactory.proxy(target);
        }

        private <T> Iterable<T> proxyIterable(AuthorizationProxyFactory proxyFactory, Iterable<T> iterable) {
            return () -> this.proxyIterator(proxyFactory, iterable.iterator());
        }

        private <T> Iterator<T> proxyIterator(final AuthorizationProxyFactory proxyFactory, final Iterator<T> iterator) {
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public @Nullable T next() {
                    return this.proxyCast(proxyFactory, iterator.next());
                }
            };
        }

        private <T> SortedSet<T> proxySortedSet(AuthorizationProxyFactory proxyFactory, SortedSet<T> set) {
            TreeSet<T> proxies = new TreeSet<T>(set.comparator());
            for (Object toProxy : set) {
                proxies.add(this.proxyCast(proxyFactory, toProxy));
            }
            try {
                set.clear();
                set.addAll(proxies);
                return proxies;
            }
            catch (UnsupportedOperationException ex) {
                return Collections.unmodifiableSortedSet(proxies);
            }
        }

        private <T> Set<T> proxySet(AuthorizationProxyFactory proxyFactory, Set<T> set) {
            LinkedHashSet<T> proxies = new LinkedHashSet<T>(set.size());
            for (T toProxy : set) {
                proxies.add(this.proxyCast(proxyFactory, toProxy));
            }
            try {
                set.clear();
                set.addAll(proxies);
                return proxies;
            }
            catch (UnsupportedOperationException ex) {
                return Collections.unmodifiableSet(proxies);
            }
        }

        private <T> Queue<T> proxyQueue(AuthorizationProxyFactory proxyFactory, Queue<T> queue) {
            LinkedList proxies = new LinkedList();
            for (Object toProxy : queue) {
                proxies.add(this.proxyCast(proxyFactory, toProxy));
            }
            queue.clear();
            queue.addAll(proxies);
            return proxies;
        }

        private <T> List<T> proxyList(AuthorizationProxyFactory proxyFactory, List<T> list) {
            ArrayList<T> proxies = new ArrayList<T>(list.size());
            for (T toProxy : list) {
                proxies.add(this.proxyCast(proxyFactory, toProxy));
            }
            try {
                list.clear();
                list.addAll(proxies);
                return proxies;
            }
            catch (UnsupportedOperationException ex) {
                return Collections.unmodifiableList(proxies);
            }
        }

        private Object[] proxyArray(AuthorizationProxyFactory proxyFactory, Object[] objects) {
            ArrayList<Object> retain = new ArrayList<Object>(objects.length);
            for (Object object : objects) {
                retain.add(proxyFactory.proxy(object));
            }
            Object[] proxies = (Object[])Array.newInstance(objects.getClass().getComponentType(), retain.size());
            for (int i = 0; i < retain.size(); ++i) {
                proxies[i] = retain.get(i);
            }
            return proxies;
        }

        private <K, V> SortedMap<K, V> proxySortedMap(AuthorizationProxyFactory proxyFactory, SortedMap<K, V> entries) {
            TreeMap<K, V> proxies = new TreeMap<K, V>(entries.comparator());
            for (Map.Entry<K, V> entry : entries.entrySet()) {
                proxies.put(entry.getKey(), this.proxyCast(proxyFactory, entry.getValue()));
            }
            try {
                entries.clear();
                entries.putAll(proxies);
                return entries;
            }
            catch (UnsupportedOperationException ex) {
                return Collections.unmodifiableSortedMap(proxies);
            }
        }

        private <K, V> Map<K, V> proxyMap(AuthorizationProxyFactory proxyFactory, Map<K, V> entries) {
            LinkedHashMap<K, V> proxies = new LinkedHashMap<K, V>(entries.size());
            for (Map.Entry<K, V> entry : entries.entrySet()) {
                proxies.put(entry.getKey(), this.proxyCast(proxyFactory, entry.getValue()));
            }
            try {
                entries.clear();
                entries.putAll(proxies);
                return entries;
            }
            catch (UnsupportedOperationException ex) {
                return Collections.unmodifiableMap(proxies);
            }
        }

        private Stream<?> proxyStream(AuthorizationProxyFactory proxyFactory, Stream<?> stream) {
            return (Stream)stream.map(proxyFactory::proxy).onClose(stream::close);
        }

        private Optional<?> proxyOptional(AuthorizationProxyFactory proxyFactory, Optional<?> optional) {
            return optional.map(proxyFactory::proxy);
        }

        private Supplier<?> proxySupplier(AuthorizationProxyFactory proxyFactory, Supplier<?> supplier) {
            return () -> proxyFactory.proxy(supplier.get());
        }
    }

    private static final class IgnoreValueTypeVisitor
    implements TargetVisitor {
        private IgnoreValueTypeVisitor() {
        }

        @Override
        public @Nullable Object visit(AuthorizationAdvisorProxyFactory proxyFactory, Object object) {
            if (ClassUtils.isSimpleValueType(object.getClass())) {
                return object;
            }
            return null;
        }
    }
}

