/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization.method;

import java.util.function.Supplier;
import org.aopalliance.intercept.MethodInvocation;
import org.jspecify.annotations.Nullable;
import org.springframework.context.ApplicationContext;
import org.springframework.expression.EvaluationContext;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.AuthorizationResult;
import org.springframework.security.authorization.method.ExpressionAttribute;
import org.springframework.security.authorization.method.ExpressionUtils;
import org.springframework.security.authorization.method.MethodAuthorizationDeniedHandler;
import org.springframework.security.authorization.method.PreAuthorizeExpressionAttribute;
import org.springframework.security.authorization.method.PreAuthorizeExpressionAttributeRegistry;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.annotation.AnnotationTemplateExpressionDefaults;

public final class PreAuthorizeAuthorizationManager
implements AuthorizationManager<MethodInvocation>,
MethodAuthorizationDeniedHandler {
    private PreAuthorizeExpressionAttributeRegistry registry = new PreAuthorizeExpressionAttributeRegistry();

    public void setExpressionHandler(MethodSecurityExpressionHandler expressionHandler) {
        this.registry.setExpressionHandler(expressionHandler);
    }

    public void setTemplateDefaults(AnnotationTemplateExpressionDefaults defaults) {
        this.registry.setTemplateDefaults(defaults);
    }

    public void setApplicationContext(ApplicationContext context) {
        this.registry.setApplicationContext(context);
    }

    @Override
    public @Nullable AuthorizationResult authorize(Supplier<? extends @Nullable Authentication> authentication, MethodInvocation mi) {
        Object attribute = this.registry.getAttribute(mi);
        if (attribute == null) {
            return null;
        }
        EvaluationContext ctx = this.registry.getExpressionHandler().createEvaluationContext(authentication, mi);
        return ExpressionUtils.evaluate(((ExpressionAttribute)attribute).getExpression(), ctx, authentication, mi);
    }

    @Override
    public @Nullable Object handleDeniedInvocation(MethodInvocation methodInvocation, AuthorizationResult authorizationResult) {
        Object attribute = this.registry.getAttribute(methodInvocation);
        PreAuthorizeExpressionAttribute preAuthorizeAttribute = (PreAuthorizeExpressionAttribute)attribute;
        return preAuthorizeAttribute.getHandler().handleDeniedInvocation(methodInvocation, authorizationResult);
    }
}

