/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.core.SpringVersion;
import org.springframework.security.core.ComparableVersion;
import org.springframework.util.Assert;

public final class SpringSecurityCoreVersion {
    private static final String DISABLE_CHECKS = SpringSecurityCoreVersion.class.getName().concat(".DISABLE_CHECKS");
    private static final Log logger = LogFactory.getLog(SpringSecurityCoreVersion.class);
    @Deprecated(forRemoval=true)
    public static final long SERIAL_VERSION_UID = 620L;
    static final @Nullable String MIN_SPRING_VERSION = SpringSecurityCoreVersion.getSpringVersion();

    private SpringSecurityCoreVersion() {
    }

    private static void performVersionChecks() {
        SpringSecurityCoreVersion.performVersionChecks(MIN_SPRING_VERSION);
    }

    private static void performVersionChecks(@Nullable String minSpringVersion) {
        String version;
        if (minSpringVersion == null) {
            return;
        }
        String springVersion = SpringVersion.getVersion();
        if (SpringSecurityCoreVersion.disableChecks(springVersion, version = SpringSecurityCoreVersion.getVersion())) {
            return;
        }
        Assert.notNull((Object)springVersion, (String)"springVersion cannot be null");
        logger.info((Object)("You are running with Spring Security Core " + version));
        if (new ComparableVersion(springVersion).compareTo(new ComparableVersion(minSpringVersion)) < 0) {
            logger.warn((Object)("**** You are advised to use Spring " + minSpringVersion + " or later with this version. You are running: " + springVersion));
        }
    }

    public static @Nullable String getVersion() {
        Package pkg = SpringSecurityCoreVersion.class.getPackage();
        return pkg != null ? pkg.getImplementationVersion() : null;
    }

    private static boolean disableChecks(@Nullable String springVersion, @Nullable String springSecurityVersion) {
        if (springVersion == null || springVersion.equals(springSecurityVersion)) {
            return true;
        }
        return Boolean.getBoolean(DISABLE_CHECKS);
    }

    private static @Nullable String getSpringVersion() {
        Properties properties = new Properties();
        try (InputStream is = SpringSecurityCoreVersion.class.getClassLoader().getResourceAsStream("META-INF/spring-security.versions");){
            properties.load(is);
        }
        catch (IOException | NullPointerException ex) {
            return null;
        }
        return properties.getProperty("org.springframework:spring-core");
    }

    static {
        SpringSecurityCoreVersion.performVersionChecks();
    }
}

