/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.core.annotation;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.security.core.annotation.AnnotationTemplateExpressionDefaults;
import org.springframework.security.core.annotation.ExpressionTemplateSecurityAnnotationScanner;
import org.springframework.security.core.annotation.SecurityAnnotationScanner;
import org.springframework.security.core.annotation.UniqueSecurityAnnotationScanner;

public final class SecurityAnnotationScanners {
    private static final Map<Class<? extends Annotation>, SecurityAnnotationScanner<? extends Annotation>> uniqueTemplateScanners = new ConcurrentHashMap<Class<? extends Annotation>, SecurityAnnotationScanner<? extends Annotation>>();
    private static final Map<List<Class<? extends Annotation>>, SecurityAnnotationScanner<? extends Annotation>> uniqueTypesScanners = new ConcurrentHashMap<List<Class<? extends Annotation>>, SecurityAnnotationScanner<? extends Annotation>>();

    private SecurityAnnotationScanners() {
    }

    public static <A extends Annotation> SecurityAnnotationScanner<A> requireUnique(Class<A> type) {
        return SecurityAnnotationScanners.requireUnique(type, new AnnotationTemplateExpressionDefaults());
    }

    public static <A extends Annotation> SecurityAnnotationScanner<A> requireUnique(Class<A> type, AnnotationTemplateExpressionDefaults templateDefaults) {
        return uniqueTemplateScanners.computeIfAbsent(type, t -> new ExpressionTemplateSecurityAnnotationScanner(t, templateDefaults));
    }

    public static SecurityAnnotationScanner<Annotation> requireUnique(List<Class<? extends Annotation>> types) {
        ArrayList casted = new ArrayList();
        types.forEach(type -> casted.add(type));
        return uniqueTypesScanners.computeIfAbsent(types, t -> new UniqueSecurityAnnotationScanner(casted));
    }
}

