/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.cluster.topology;

import com.lambdaworks.redis.LettuceStrings;
import com.lambdaworks.redis.RedisCommandInterruptedException;
import com.lambdaworks.redis.RedisConnectionException;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.api.StatefulRedisConnection;
import com.lambdaworks.redis.cluster.models.partitions.Partitions;
import com.lambdaworks.redis.cluster.models.partitions.RedisClusterNode;
import com.lambdaworks.redis.cluster.topology.Connections;
import com.lambdaworks.redis.cluster.topology.NodeConnectionFactory;
import com.lambdaworks.redis.cluster.topology.NodeTopologyView;
import com.lambdaworks.redis.cluster.topology.NodeTopologyViews;
import com.lambdaworks.redis.cluster.topology.RedisClusterNodeSnapshot;
import com.lambdaworks.redis.cluster.topology.Requests;
import com.lambdaworks.redis.cluster.topology.TopologyComparators;
import com.lambdaworks.redis.codec.Utf8StringCodec;
import com.lambdaworks.redis.resource.ClientResources;
import com.lambdaworks.redis.resource.SocketAddressResolver;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class ClusterTopologyRefresh {
    static final Utf8StringCodec CODEC = new Utf8StringCodec();
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ClusterTopologyRefresh.class);
    private final NodeConnectionFactory nodeConnectionFactory;
    private final ClientResources clientResources;

    public ClusterTopologyRefresh(NodeConnectionFactory nodeConnectionFactory, ClientResources clientResources) {
        this.nodeConnectionFactory = nodeConnectionFactory;
        this.clientResources = clientResources;
    }

    public Map<RedisURI, Partitions> loadViews(Iterable<RedisURI> seed, boolean discovery) {
        Connections connections = this.getConnections(seed);
        Requests requestedTopology = connections.requestTopology();
        Requests requestedClients = connections.requestClients();
        long commandTimeoutNs = this.getCommandTimeoutNs(seed);
        try {
            Set<RedisURI> allKnownUris;
            Set<RedisURI> discoveredNodes;
            NodeTopologyViews nodeSpecificViews = this.getNodeSpecificViews(requestedTopology, requestedClients, commandTimeoutNs);
            if (discovery && !(discoveredNodes = ClusterTopologyRefresh.difference(allKnownUris = nodeSpecificViews.getClusterNodes(), this.toSet(seed))).isEmpty()) {
                Connections discoveredConnections = this.getConnections(discoveredNodes);
                connections = connections.mergeWith(discoveredConnections);
                requestedTopology = requestedTopology.mergeWith(discoveredConnections.requestTopology());
                requestedClients = requestedClients.mergeWith(discoveredConnections.requestClients());
                nodeSpecificViews = this.getNodeSpecificViews(requestedTopology, requestedClients, commandTimeoutNs);
                Map<RedisURI, Partitions> map = nodeSpecificViews.toMap();
                return map;
            }
            Map<RedisURI, Partitions> map = nodeSpecificViews.toMap();
            return map;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RedisCommandInterruptedException(e);
        }
        finally {
            connections.close();
        }
    }

    private Set<RedisURI> toSet(Iterable<RedisURI> seed) {
        return StreamSupport.stream(seed.spliterator(), false).collect(Collectors.toCollection(HashSet::new));
    }

    NodeTopologyViews getNodeSpecificViews(Requests requestedTopology, Requests requestedClients, long commandTimeoutNs) throws InterruptedException {
        ArrayList allNodes = new ArrayList();
        HashMap<String, Long> latencies = new HashMap<String, Long>();
        HashMap<String, Integer> clientCountByNodeId = new HashMap<String, Integer>();
        long waitTime = requestedTopology.await(commandTimeoutNs, TimeUnit.NANOSECONDS);
        requestedClients.await(commandTimeoutNs - waitTime, TimeUnit.NANOSECONDS);
        Set<RedisURI> nodes = requestedTopology.nodes();
        ArrayList<NodeTopologyView> views = new ArrayList<NodeTopologyView>();
        for (RedisURI redisURI : nodes) {
            try {
                NodeTopologyView nodeTopologyView = NodeTopologyView.from(redisURI, requestedTopology, requestedClients);
                if (!nodeTopologyView.isAvailable()) continue;
                List nodeWithStats = nodeTopologyView.getPartitions().stream().filter(ClusterTopologyRefresh::validNode).map(RedisClusterNodeSnapshot::new).collect(Collectors.toList());
                for (RedisClusterNodeSnapshot partition : nodeWithStats) {
                    if (!partition.getFlags().contains((Object)RedisClusterNode.NodeFlag.MYSELF)) continue;
                    if (partition.getUri() == null) {
                        partition.setUri(redisURI);
                    }
                    latencies.put(partition.getNodeId(), nodeTopologyView.getLatency());
                    clientCountByNodeId.put(partition.getNodeId(), nodeTopologyView.getConnectedClients());
                }
                allNodes.addAll(nodeWithStats);
                Partitions partitions = new Partitions();
                partitions.addAll(nodeWithStats);
                nodeTopologyView.setPartitions(partitions);
                views.add(nodeTopologyView);
            }
            catch (ExecutionException e) {
                logger.warn(String.format("Cannot retrieve partition view from %s, error: %s", redisURI, e));
            }
        }
        for (RedisClusterNodeSnapshot redisClusterNodeSnapshot : allNodes) {
            redisClusterNodeSnapshot.setConnectedClients((Integer)clientCountByNodeId.get(redisClusterNodeSnapshot.getNodeId()));
            redisClusterNodeSnapshot.setLatencyNs((Long)latencies.get(redisClusterNodeSnapshot.getNodeId()));
        }
        for (NodeTopologyView nodeTopologyView : views) {
            Collections.sort(nodeTopologyView.getPartitions().getPartitions(), TopologyComparators.LatencyComparator.INSTANCE);
            nodeTopologyView.getPartitions().updateCache();
        }
        return new NodeTopologyViews(views);
    }

    private static boolean validNode(RedisClusterNode redisClusterNode) {
        if (redisClusterNode.is(RedisClusterNode.NodeFlag.NOADDR)) {
            return false;
        }
        return redisClusterNode.getUri() != null && redisClusterNode.getUri().getPort() != 0 && !LettuceStrings.isEmpty(redisClusterNode.getUri().getHost());
    }

    private Connections getConnections(Iterable<RedisURI> redisURIs) {
        Connections connections = new Connections();
        for (RedisURI redisURI : redisURIs) {
            if (redisURI.getHost() == null || connections.connectedNodes().contains(redisURI)) continue;
            try {
                SocketAddress socketAddress = SocketAddressResolver.resolve(redisURI, this.clientResources.dnsResolver());
                StatefulRedisConnection<String, String> connection = this.nodeConnectionFactory.connectToNode(CODEC, socketAddress);
                connection.async().clientSetname("lettuce#ClusterTopologyRefresh");
                connections.addConnection(redisURI, connection);
            }
            catch (RedisConnectionException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug(e.getMessage(), (Throwable)e);
                    continue;
                }
                logger.warn(e.getMessage());
            }
            catch (RuntimeException e) {
                logger.warn(String.format("Cannot connect to %s", redisURI), (Throwable)e);
            }
        }
        return connections;
    }

    public RedisURI getViewedBy(Map<RedisURI, Partitions> map, Partitions partitions) {
        for (Map.Entry<RedisURI, Partitions> entry : map.entrySet()) {
            if (entry.getValue() != partitions) continue;
            return entry.getKey();
        }
        return null;
    }

    private static <E> Set<E> difference(Set<E> set1, Set<E> set2) {
        Set result = set1.stream().filter(e -> !set2.contains(e)).collect(Collectors.toSet());
        result.addAll(set2.stream().filter(e -> !set1.contains(e)).collect(Collectors.toList()));
        return result;
    }

    private long getCommandTimeoutNs(Iterable<RedisURI> redisURIs) {
        RedisURI redisURI = redisURIs.iterator().next();
        return redisURI.getUnit().toNanos(redisURI.getTimeout());
    }
}

