/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.masterslave;

import com.lambdaworks.redis.RedisClient;
import com.lambdaworks.redis.RedisCommandInterruptedException;
import com.lambdaworks.redis.RedisFuture;
import com.lambdaworks.redis.RedisURI;
import com.lambdaworks.redis.api.StatefulRedisConnection;
import com.lambdaworks.redis.masterslave.MasterSlaveUtils;
import com.lambdaworks.redis.masterslave.TopologyProvider;
import com.lambdaworks.redis.models.role.RedisNodeDescription;
import com.lambdaworks.redis.output.StatusOutput;
import com.lambdaworks.redis.protocol.AsyncCommand;
import com.lambdaworks.redis.protocol.Command;
import com.lambdaworks.redis.protocol.CommandArgs;
import com.lambdaworks.redis.protocol.CommandType;
import com.lambdaworks.redis.protocol.RedisCommand;
import io.netty.buffer.ByteBuf;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

class MasterSlaveTopologyRefresh {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(MasterSlaveTopologyRefresh.class);
    private final RedisClient client;
    private final TopologyProvider topologyProvider;

    public MasterSlaveTopologyRefresh(RedisClient client, TopologyProvider topologyProvider) {
        this.client = client;
        this.topologyProvider = topologyProvider;
    }

    public List<RedisNodeDescription> getNodes(RedisURI seed) {
        List<RedisNodeDescription> nodes = this.topologyProvider.getNodes();
        this.addPasswordIfNeeded(nodes, seed);
        Map<RedisURI, StatefulRedisConnection<String, String>> connections = this.getConnections(nodes);
        Map<RedisURI, TimedAsyncCommand<String, String, String>> rawViews = this.requestPing(connections);
        List<RedisNodeDescription> result = this.getNodeSpecificViews(rawViews, nodes, seed);
        this.close(connections);
        return result;
    }

    private void addPasswordIfNeeded(List<RedisNodeDescription> nodes, RedisURI seed) {
        if (seed.getPassword() != null && seed.getPassword().length != 0) {
            for (RedisNodeDescription node : nodes) {
                node.getUri().setPassword(new String(seed.getPassword()));
            }
        }
    }

    protected List<RedisNodeDescription> getNodeSpecificViews(Map<RedisURI, TimedAsyncCommand<String, String, String>> rawViews, List<RedisNodeDescription> nodes, RedisURI seed) {
        ArrayList<RedisNodeDescription> result = new ArrayList<RedisNodeDescription>();
        long timeout = seed.getUnit().toNanos(seed.getTimeout());
        long waitTime = 0L;
        HashMap<RedisNodeDescription, Long> latencies = new HashMap<RedisNodeDescription, Long>();
        for (Map.Entry<RedisURI, TimedAsyncCommand<String, String, String>> entry : rawViews.entrySet()) {
            long timeoutLeft = timeout - waitTime;
            if (timeoutLeft <= 0L) break;
            long startWait = System.nanoTime();
            RedisFuture future = entry.getValue();
            try {
                if (!future.await(timeoutLeft, TimeUnit.NANOSECONDS)) break;
                waitTime += System.nanoTime() - startWait;
                future.get();
                RedisNodeDescription redisNodeDescription = MasterSlaveUtils.findNodeByUri(nodes, entry.getKey());
                latencies.put(redisNodeDescription, entry.getValue().duration());
                result.add(redisNodeDescription);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RedisCommandInterruptedException(e);
            }
            catch (ExecutionException e) {
                logger.warn("Cannot retrieve partition view from " + entry.getKey(), (Throwable)e);
            }
        }
        LatencyComparator comparator = new LatencyComparator(latencies);
        Collections.sort(result, comparator);
        return result;
    }

    private Map<RedisURI, TimedAsyncCommand<String, String, String>> requestPing(Map<RedisURI, StatefulRedisConnection<String, String>> connections) {
        TreeMap<RedisURI, TimedAsyncCommand<String, String, String>> rawViews = new TreeMap<RedisURI, TimedAsyncCommand<String, String, String>>(RedisUriComparator.INSTANCE);
        for (Map.Entry<RedisURI, StatefulRedisConnection<String, String>> entry : connections.entrySet()) {
            TimedAsyncCommand<String, String, String> timed = this.createPingCommand();
            entry.getValue().dispatch(timed);
            rawViews.put(entry.getKey(), timed);
        }
        return rawViews;
    }

    protected TimedAsyncCommand<String, String, String> createPingCommand() {
        CommandArgs<String, String> args = new CommandArgs<String, String>(MasterSlaveUtils.CODEC);
        Command command = new Command(CommandType.PING, new StatusOutput<String, String>(MasterSlaveUtils.CODEC), args);
        return new TimedAsyncCommand<String, String, String>(command);
    }

    private void close(Map<RedisURI, StatefulRedisConnection<String, String>> connections) {
        for (StatefulRedisConnection<String, String> connection : connections.values()) {
            connection.close();
        }
    }

    private Map<RedisURI, StatefulRedisConnection<String, String>> getConnections(Iterable<RedisNodeDescription> nodes) {
        TreeMap<RedisURI, StatefulRedisConnection<String, String>> connections = new TreeMap<RedisURI, StatefulRedisConnection<String, String>>(RedisUriComparator.INSTANCE);
        for (RedisNodeDescription node : nodes) {
            try {
                StatefulRedisConnection<String, String> connection = this.client.connect(node.getUri());
                connections.put(node.getUri(), connection);
            }
            catch (RuntimeException e) {
                logger.warn("Cannot connect to " + node.getUri(), (Throwable)e);
            }
        }
        return connections;
    }

    static class LatencyComparator
    implements Comparator<RedisNodeDescription> {
        private final Map<RedisNodeDescription, Long> latencies;

        public LatencyComparator(Map<RedisNodeDescription, Long> latencies) {
            this.latencies = latencies;
        }

        @Override
        public int compare(RedisNodeDescription o1, RedisNodeDescription o2) {
            Long latency1 = this.latencies.get(o1);
            Long latency2 = this.latencies.get(o2);
            if (latency1 != null && latency2 != null) {
                return latency1.compareTo(latency2);
            }
            if (latency1 != null && latency2 == null) {
                return -1;
            }
            if (latency1 == null && latency2 != null) {
                return 1;
            }
            return 0;
        }
    }

    static class TimedAsyncCommand<K, V, T>
    extends AsyncCommand<K, V, T> {
        long encodedAtNs = -1L;
        long completedAtNs = -1L;

        public TimedAsyncCommand(RedisCommand<K, V, T> command) {
            super(command);
        }

        @Override
        public void encode(ByteBuf buf) {
            this.completedAtNs = -1L;
            this.encodedAtNs = -1L;
            super.encode(buf);
            this.encodedAtNs = System.nanoTime();
        }

        @Override
        public void complete() {
            this.completedAtNs = System.nanoTime();
            super.complete();
        }

        public long duration() {
            if (this.completedAtNs == -1L || this.encodedAtNs == -1L) {
                return -1L;
            }
            return this.completedAtNs - this.encodedAtNs;
        }
    }

    static class RedisUriComparator
    implements Comparator<RedisURI> {
        public static final RedisUriComparator INSTANCE = new RedisUriComparator();

        RedisUriComparator() {
        }

        @Override
        public int compare(RedisURI o1, RedisURI o2) {
            String h1 = "";
            String h2 = "";
            if (o1 != null) {
                h1 = o1.getHost() + ":" + o1.getPort();
            }
            if (o2 != null) {
                h2 = o2.getHost() + ":" + o2.getPort();
            }
            return h1.compareToIgnoreCase(h2);
        }
    }
}

