/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.resource;

import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import rx.Scheduler;
import rx.Subscription;
import rx.functions.Action0;
import rx.internal.schedulers.ScheduledAction;
import rx.internal.util.SubscriptionList;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.Subscriptions;

public class RxJavaEventExecutorGroupScheduler
extends Scheduler {
    private final EventExecutorGroup eventLoopGroup;

    public RxJavaEventExecutorGroupScheduler(EventExecutorGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
    }

    public Scheduler.Worker createWorker() {
        EventExecutor eventLoop = this.eventLoopGroup.next();
        return new ScheduledExecutorServiceWorker(eventLoop);
    }

    private static class ScheduledExecutorServiceWorker
    extends Scheduler.Worker {
        private final SubscriptionList serial;
        private final CompositeSubscription timed;
        private final SubscriptionList both;
        private final ScheduledExecutorService scheduledExecutor;

        public ScheduledExecutorServiceWorker(EventExecutor scheduledExecutor) {
            this.scheduledExecutor = scheduledExecutor;
            this.serial = new SubscriptionList();
            this.timed = new CompositeSubscription();
            this.both = new SubscriptionList(new Subscription[]{this.serial, this.timed});
        }

        public Subscription schedule(Action0 action) {
            return this.schedule(action, 0L, TimeUnit.DAYS);
        }

        public Subscription schedule(Action0 action, long delayTime, TimeUnit unit) {
            ScheduledAction sa;
            if (this.isUnsubscribed()) {
                return Subscriptions.unsubscribed();
            }
            if (delayTime <= 0L) {
                sa = new ScheduledAction(action, this.serial);
                this.serial.add((Subscription)sa);
            } else {
                sa = new ScheduledAction(action, this.timed);
                this.timed.add((Subscription)sa);
            }
            final ScheduledFuture<?> result = this.scheduledExecutor.schedule((Runnable)sa, delayTime, unit);
            Subscription cancelFuture = Subscriptions.create((Action0)new Action0(){

                public void call() {
                    result.cancel(false);
                }
            });
            sa.add(cancelFuture);
            return sa;
        }

        public void unsubscribe() {
            this.both.unsubscribe();
        }

        public boolean isUnsubscribed() {
            return this.both.isUnsubscribed();
        }
    }
}

