/*
 * Decompiled with CFR 0.152.
 */
package cn.xfyun.model.sign;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.SignatureException;

public abstract class AbstractSignature {
    private String id;
    private String key;
    private String url;
    private String encryptType;
    private String originSign;
    protected String signa;
    private String ts;
    protected String requestMethod = "GET";

    public AbstractSignature(String id, String key, String url) {
        this.id = id;
        this.key = key;
        this.url = url;
        this.ts = this.generateTs();
    }

    public AbstractSignature(String id, String key, String url, boolean isPost) {
        this.id = id;
        this.key = key;
        this.url = url;
        this.requestMethod = isPost ? "POST" : "GET";
        this.ts = this.generateTs();
    }

    public String generateTs() {
        return String.valueOf(System.currentTimeMillis() / 1000L);
    }

    public abstract String getSigna() throws SignatureException;

    public String generateOriginSign() throws SignatureException {
        try {
            URL url = new URL(this.getUrl());
            return "host: " + url.getHost() + "\ndate: " + this.getTs() + "\nGET " + url.getPath() + " HTTP/1.1";
        }
        catch (MalformedURLException e) {
            throw new SignatureException("MalformedURLException:" + e.getMessage());
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getOriginSign() {
        return this.originSign;
    }

    public void setOriginSign(String originSign) {
        this.originSign = originSign;
    }

    public String getTs() {
        return this.ts;
    }

    public void setTs(String ts) {
        this.ts = ts;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getEncryptType() {
        return this.encryptType;
    }

    public void setEncryptType(String encryptType) {
        this.encryptType = encryptType;
    }
}

